/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.impl.FilePool;
import ch.powerunit.extensions.async.lang.WaitResult;
import ch.powerunit.extensions.async.lang.WaitResultBuilder1;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class WaitFile {
    private WaitFile() {
    }

    @SafeVarargs
    public static WaitResultBuilder1<Collection<WatchEvent<Path>>> eventIn(Path directory, WatchEvent.Kind<Path> ... events) {
        Objects.requireNonNull(directory, "directory can't be null");
        FilePool filePool = new FilePool(directory, events);
        return WaitResult.of(filePool, filePool::close);
    }

    public static WaitResultBuilder1<Collection<Path>> newFileIn(Path directory) {
        Objects.requireNonNull(directory, "directory can't be null");
        FilePool filePool = new FilePool(directory, StandardWatchEventKinds.ENTRY_CREATE);
        return WaitResult.of(WaitResult.callableWithToString(WaitFile.toPathCollection(filePool), () -> "new file in " + filePool), filePool::close);
    }

    public static WaitResultBuilder1<Path> newFileNamedIn(Path directory, String name) {
        Objects.requireNonNull(directory, "directory can't be null");
        Objects.requireNonNull(name, "name can't be null");
        FilePool filePool = new FilePool(directory, StandardWatchEventKinds.ENTRY_CREATE);
        return WaitResult.of(WaitResult.callableWithToString(WaitFile.toPathByName(WaitFile.toPathCollection(filePool), name), () -> String.format("New file named %s in %s", name, filePool)), filePool::close);
    }

    public static WaitResultBuilder1<Collection<Path>> removeFileFrom(Path directory) {
        Objects.requireNonNull(directory, "directory can't be null");
        FilePool filePool = new FilePool(directory, StandardWatchEventKinds.ENTRY_DELETE);
        return WaitResult.of(WaitResult.callableWithToString(WaitFile.toPathCollection(filePool), () -> "Removed file from " + directory), filePool::close);
    }

    private static Callable<Collection<Path>> toPathCollection(Callable<Collection<WatchEvent<Path>>> callable) {
        return () -> ((Collection)callable.call()).stream().map(WatchEvent::context).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static Callable<Path> toPathByName(Callable<Collection<Path>> callable, String name) {
        return () -> ((Collection)callable.call()).stream().filter(p -> Objects.equals(p.getName(p.getNameCount() - 1).toString(), name)).findFirst().orElse(null);
    }
}

