/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import ch.powerunit.extensions.async.lang.WaitResultBuilder6;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface WaitResultBuilder5<T>
extends Supplier<Optional<T>> {
    @Override
    public Optional<T> get();

    default public WaitResultBuilder5<T> onFinish(Runnable action) {
        if (action == null) {
            return this;
        }
        return () -> {
            try {
                Object object = this.get();
                return object;
            }
            finally {
                action.run();
            }
        };
    }

    default public WaitResultBuilder6<T> using(Executor executor) {
        return () -> CompletableFuture.supplyAsync(this, executor);
    }

    default public WaitResultBuilder6<T> usingDefaultExecutor() {
        return this.using(ForkJoinPool.commonPool());
    }

    @Deprecated
    default public CompletableFuture<Optional<T>> asyncExec(Executor executor) {
        return this.using(executor).asyncExec();
    }

    default public CompletableFuture<Optional<T>> asyncExec() {
        return this.usingDefaultExecutor().asyncExec();
    }

    @Deprecated
    default public Optional<T> finish(Executor executor) {
        return this.using(executor).finish();
    }

    default public Optional<T> finish() {
        return this.usingDefaultExecutor().finish();
    }

    @Deprecated
    default public T finishWithAResult(Executor executor) {
        return this.using(executor).finishWithAResult();
    }

    default public T finishWithAResult() {
        return this.usingDefaultExecutor().finishWithAResult();
    }

    default public <U> WaitResultBuilder5<U> map(Function<T, U> mapper) {
        return () -> ((Optional)this.get()).map(mapper);
    }

    default public <U> WaitResultBuilder5<U> flatMap(Function<T, Optional<U>> mapper) {
        return () -> ((Optional)this.get()).flatMap(mapper);
    }

    default public WaitResultBuilder5<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        throw new UnsupportedOperationException("Not available on java 8");
    }

    default public WaitResultBuilder5<T> filter(Predicate<T> filter) {
        return () -> ((Optional)this.get()).filter(filter);
    }
}

