/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.async.lang;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface WaitResultBuilder6<T> {
    public CompletableFuture<Optional<T>> asyncExec();

    default public Optional<T> finish() {
        try {
            return this.asyncExec().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Optional.ofNullable(e.getCause()).filter(c -> c instanceof AssertionError).map(AssertionError.class::cast).orElseGet(() -> new AssertionError("Unexpected error " + e.getMessage(), e));
        }
    }

    default public T finishWithAResult() {
        return this.finish().orElseThrow(() -> new AssertionError((Object)"No result is available"));
    }

    default public Optional<T> join() {
        return this.asyncExec().join();
    }

    default public T joinWithAResult() {
        return this.join().orElseThrow(() -> new AssertionError((Object)"No result is available when one is expected"));
    }

    default public CompletableFuture<Void> thenAccept(Consumer<? super Optional<T>> action) {
        return this.asyncExec().thenAccept(action);
    }

    default public <U> CompletableFuture<U> thenApply(Function<? super Optional<T>, ? extends U> fn) {
        return this.asyncExec().thenApply(fn);
    }

    default public CompletableFuture<Optional<T>> orTimeout(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Not available on java 8");
    }

    default public CompletionStage<Optional<T>> minimalCompletionStage() {
        throw new UnsupportedOperationException("Not available on java 8");
    }

    default public Optional<T> get() throws InterruptedException, ExecutionException {
        return this.asyncExec().get();
    }
}

