/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.provideprocessor.FieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersSubElementVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"ch.powerunit.extensions.matchers.ProvideMatchers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ProvidesMatchersAnnotationsProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementsUtils = this.processingEnv.getElementUtils();
        Filer filerUtils = this.processingEnv.getFiler();
        Types typesUtils = this.processingEnv.getTypeUtils();
        Messager messageUtils = this.processingEnv.getMessager();
        TypeElement provideMatchersTE = elementsUtils.getTypeElement("ch.powerunit.extensions.matchers.ProvideMatchers");
        TypeElement objectTE = elementsUtils.getTypeElement("java.lang.Object");
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ProvideMatchers.class);
        for (Element element : elements) {
            if (!roundEnv.getRootElements().contains(element)) break;
            TypeElement te = element.accept(new ProvidesMatchersElementVisitor(this, elementsUtils, filerUtils, typesUtils, messageUtils, provideMatchersTE), null);
            if (te == null) continue;
            this.processOneTypeElement(elementsUtils, filerUtils, typesUtils, messageUtils, te, objectTE);
        }
        return true;
    }

    private void processOneTypeElement(Elements elementsUtils, Filer filerUtils, Types typesUtils, Messager messageUtils, TypeElement te, TypeElement objectTE) {
        Name inputClassName = te.getQualifiedName();
        Name packageName = elementsUtils.getPackageOf(te).getQualifiedName();
        String outputClassName = inputClassName + "Matchers";
        String outputSimpleName = te.getSimpleName().toString() + "Matchers";
        String shortClassName = te.getSimpleName().toString();
        String methodShortClassName = shortClassName.substring(0, 1).toLowerCase() + shortClassName.substring(1);
        boolean hasParent = !objectTE.asType().equals(te.getSuperclass());
        String generic = "";
        String fullGeneric = "";
        if (te.getTypeParameters().size() > 0) {
            generic = "<" + te.getTypeParameters().stream().map(t -> t.toString()).collect(Collectors.joining(",")) + ">";
            fullGeneric = "<" + te.getTypeParameters().stream().map(t -> t.toString() + " extends " + t.getBounds().stream().map(b -> b.toString()).collect(Collectors.joining("&"))).collect(Collectors.joining(",")) + ">";
        }
        try {
            JavaFileObject jfo = filerUtils.createSourceFile(outputClassName, te);
            try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                wjfo.println("package " + packageName + ";");
                wjfo.println();
                wjfo.println("/**");
                wjfo.println(" * This class provides matchers for the class {@link " + shortClassName + "}.");
                wjfo.println(" * ");
                wjfo.println(" * @see " + shortClassName + " The class for which matchers are provided.");
                wjfo.println(" */");
                wjfo.println("@javax.annotation.Generated(\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\")");
                wjfo.println("public final class " + outputSimpleName + " {");
                wjfo.println();
                wjfo.println("  private " + outputSimpleName + "() {}");
                wjfo.println();
                ArrayList<FieldDescription> fields = new ArrayList<FieldDescription>();
                for (Element element : te.getEnclosedElements()) {
                    FieldDescription f = element.accept(new ProvidesMatchersSubElementVisitor(this, elementsUtils, filerUtils, typesUtils, messageUtils, te, generic, fullGeneric, wjfo), null);
                    if (f == null) continue;
                    fields.add(f);
                }
                if (hasParent) {
                    wjfo.println("  private static class SuperClassMatcher" + fullGeneric + " extends org.hamcrest.FeatureMatcher<" + shortClassName + "," + te.getSuperclass().toString() + "> {");
                    wjfo.println();
                    wjfo.println("    public SuperClassMatcher(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> matcher) {");
                    wjfo.println("      super(matcher,\"parent\",\"parent\");");
                    wjfo.println("  }");
                    wjfo.println();
                    wjfo.println("    protected " + te.getSuperclass().toString() + " featureValueOf(" + shortClassName + " actual) {");
                    wjfo.println("      return actual;");
                    wjfo.println("    }");
                    wjfo.println();
                    wjfo.println("  }");
                    wjfo.println();
                    wjfo.println();
                }
                wjfo.println("  /**");
                wjfo.println("   * DSL interface for matcher on {@link " + inputClassName + " " + shortClassName + "}.");
                wjfo.println("   */");
                wjfo.println("  public static interface " + shortClassName + "Matcher" + fullGeneric + " extends org.hamcrest.Matcher<" + shortClassName + generic + "> {");
                for (FieldDescription fieldDescription : fields) {
                    wjfo.println("    /**");
                    wjfo.println("     * Add a validation on the field " + fieldDescription.getFieldName() + ".");
                    wjfo.println("     *");
                    wjfo.println("     * {@link " + inputClassName + "#" + fieldDescription.getFieldAccessor() + " This field is accessed by using this approach}.");
                    wjfo.println("     *");
                    wjfo.println("     * @param matcher a Matcher on the field.");
                    wjfo.println("     * @return the DSL to continue the construction of the matcher.");
                    wjfo.println("     */");
                    if (fields.size() == 1) {
                        wjfo.println("    org.hamcrest.Matcher<" + shortClassName + generic + "> " + fieldDescription.getFieldName() + "(org.hamcrest.Matcher<? super " + fieldDescription.getFieldType() + "> matcher);");
                    } else {
                        wjfo.println("    " + shortClassName + "Matcher" + generic + " " + fieldDescription.getFieldName() + "(org.hamcrest.Matcher<? super " + fieldDescription.getFieldType() + "> matcher);");
                    }
                    wjfo.println("    /**");
                    wjfo.println("     * Add a validation on the field " + fieldDescription.getFieldName() + ".");
                    wjfo.println("     *");
                    wjfo.println("     * {@link " + inputClassName + "#" + fieldDescription.getFieldAccessor() + " This field is accessed by using this approach}.");
                    wjfo.println("     *");
                    wjfo.println("     * @param value an expected value for the field, which will be compared using the is matcher.");
                    wjfo.println("     * @return the DSL to continue the construction of the matcher.");
                    wjfo.println("     */");
                    if (fields.size() == 1) {
                        wjfo.println("    org.hamcrest.Matcher<" + shortClassName + generic + "> " + fieldDescription.getFieldName() + "(" + fieldDescription.getFieldType() + " value);");
                        continue;
                    }
                    wjfo.println("    " + shortClassName + "Matcher" + generic + " " + fieldDescription.getFieldName() + "(" + fieldDescription.getFieldType() + " value);");
                }
                wjfo.println("  }");
                wjfo.println();
                wjfo.println("  private static class " + shortClassName + "MatcherImpl" + fullGeneric + " extends org.hamcrest.TypeSafeDiagnosingMatcher<" + shortClassName + generic + "> implements " + shortClassName + "Matcher" + generic + " {");
                for (FieldDescription fieldDescription : fields) {
                    wjfo.println("    private " + fieldDescription.getMethodFieldName() + "Matcher " + fieldDescription.getFieldName() + " = new " + fieldDescription.getMethodFieldName() + "Matcher(org.hamcrest.Matchers.anything());");
                }
                wjfo.println();
                if (hasParent) {
                    wjfo.println("    private final SuperClassMatcher parent;");
                    wjfo.println();
                    wjfo.println("    public " + shortClassName + "MatcherImpl(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> parent) {");
                    wjfo.println("      this.parent=new SuperClassMatcher(parent);");
                    wjfo.println("    }");
                    wjfo.println();
                }
                for (FieldDescription fieldDescription : fields) {
                    wjfo.println("    @Override");
                    if (fields.size() == 1) {
                        wjfo.println("    public org.hamcrest.Matcher<" + shortClassName + generic + "> " + fieldDescription.getFieldName() + "(org.hamcrest.Matcher<? super " + fieldDescription.getFieldType() + "> matcher) {");
                    } else {
                        wjfo.println("    public " + shortClassName + "Matcher" + generic + " " + fieldDescription.getFieldName() + "(org.hamcrest.Matcher<? super " + fieldDescription.getFieldType() + "> matcher) {");
                    }
                    wjfo.println("      " + fieldDescription.getFieldName() + "= new " + fieldDescription.getMethodFieldName() + "Matcher(matcher);");
                    wjfo.println("      return this;");
                    wjfo.println("    }");
                    wjfo.println();
                    wjfo.println("    @Override");
                    if (fields.size() == 1) {
                        wjfo.println("    public org.hamcrest.Matcher<" + shortClassName + generic + "> " + fieldDescription.getFieldName() + "(" + fieldDescription.getFieldType() + " value) {");
                    } else {
                        wjfo.println("    public " + shortClassName + "Matcher" + generic + " " + fieldDescription.getFieldName() + "(" + fieldDescription.getFieldType() + " value) {");
                    }
                    wjfo.println("      return " + fieldDescription.getFieldName() + "(org.hamcrest.Matchers.is(value));");
                    wjfo.println("    }");
                    wjfo.println();
                }
                wjfo.println("    @Override");
                wjfo.println("    protected boolean matchesSafely(" + shortClassName + " actual, org.hamcrest.Description mismatchDescription) {");
                wjfo.println("      boolean result=true;");
                if (hasParent) {
                    wjfo.println("      if(!parent.matches(actual)) {");
                    wjfo.println("        mismatchDescription.appendText(\"[\");");
                    wjfo.println("        parent.describeMismatch(actual,mismatchDescription);");
                    wjfo.println("        mismatchDescription.appendText(\"]\\n\");");
                    wjfo.println("        result=false;");
                    wjfo.println("      }");
                }
                for (FieldDescription fieldDescription : fields) {
                    wjfo.println("      if(!" + fieldDescription.getFieldName() + ".matches(actual)) {");
                    wjfo.println("        mismatchDescription.appendText(\"[\");");
                    wjfo.println("        " + fieldDescription.getFieldName() + ".describeMismatch(actual,mismatchDescription);");
                    wjfo.println("        mismatchDescription.appendText(\"]\\n\");");
                    wjfo.println("        result=false;");
                    wjfo.println("      }");
                }
                wjfo.println("      return result;");
                wjfo.println("    }");
                wjfo.println();
                wjfo.println("    @Override");
                wjfo.println("    public void describeTo(org.hamcrest.Description description) {");
                wjfo.println("        description.appendText(\"an instance of " + inputClassName + " with\\n\");");
                if (hasParent) {
                    wjfo.println("        description.appendText(\"[\");");
                    wjfo.println("        description.appendDescriptionOf(parent);");
                    wjfo.println("        description.appendText(\"]\\n\");");
                }
                for (FieldDescription fieldDescription : fields) {
                    wjfo.println("        description.appendText(\"[\");");
                    wjfo.println("        description.appendDescriptionOf(" + fieldDescription.getFieldName() + ");");
                    wjfo.println("        description.appendText(\"]\\n\");");
                }
                wjfo.println("    }");
                wjfo.println("  }");
                wjfo.println();
                wjfo.println("  /**");
                wjfo.println("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.");
                wjfo.println("   * ");
                wjfo.println("   * @return the DSL matcher.");
                wjfo.println("   */");
                wjfo.println("  @org.hamcrest.Factory");
                wjfo.println("  public static " + fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With() {");
                if (hasParent) {
                    wjfo.println("    return new " + shortClassName + "MatcherImpl(org.hamcrest.Matchers.anything());");
                } else {
                    wjfo.println("    return new " + shortClassName + "MatcherImpl" + generic + "();");
                }
                wjfo.println("  }");
                if (hasParent) {
                    wjfo.println("  /**");
                    wjfo.println("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.");
                    wjfo.println("   * ");
                    wjfo.println("   * @param matcherOnParent the matcher on the parent data.");
                    wjfo.println("   * @return the DSL matcher.");
                    wjfo.println("   */");
                    wjfo.println("  @org.hamcrest.Factory");
                    wjfo.println("  public static " + fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> matcherOnParent) {");
                    wjfo.println("    return new " + shortClassName + "MatcherImpl" + generic + "(matcherOnParent);");
                    wjfo.println("  }");
                }
                wjfo.println();
                wjfo.println("}");
            }
        }
        catch (IOException e1) {
            messageUtils.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class", te);
        }
    }

    AnnotationMirror getProvideMatchersAnnotation(TypeElement provideMatchersTE, Collection<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().equals(provideMatchersTE.asType())) continue;
            return annotationMirror;
        }
        return null;
    }
}

