/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.FieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.TypeKindVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ProvidesMatchersSubElementVisitor
extends SimpleElementVisitor8<FieldDescription, Void> {
    private final ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor;
    private final Elements elementsUtils;
    private final Types typesUtils;
    private final Filer filerUtils;
    private final Messager messageUtils;
    private final TypeElement typeElement;
    private final String generic;
    private final String fullGeneric;
    private final PrintWriter writer;

    public ProvidesMatchersSubElementVisitor(ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor, Elements elementsUtils, Filer filerUtils, Types typesUtils, Messager messageUtils, TypeElement typeElement, String generic, String fullGeneric, PrintWriter writer) {
        this.providesMatchersAnnotationsProcessor = providesMatchersAnnotationsProcessor;
        this.elementsUtils = elementsUtils;
        this.typesUtils = typesUtils;
        this.filerUtils = filerUtils;
        this.messageUtils = messageUtils;
        this.typeElement = typeElement;
        this.generic = generic;
        this.fullGeneric = fullGeneric;
        this.writer = writer;
    }

    @Override
    public FieldDescription visitVariable(VariableElement e, Void p) {
        if (e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            String fieldName = e.getSimpleName().toString();
            String fieldType = this.parseType(e, e.asType(), false);
            if (fieldType != null) {
                FieldDescription.Type type = this.parseType(e.asType());
                this.writer.println("  // Field " + fieldName + " of " + fieldType);
                this.createFeatureMatcher(fieldName, fieldName, fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), fieldType, type);
                this.writer.println();
                return new FieldDescription(fieldName, fieldName, fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), fieldType, type);
            }
        }
        return null;
    }

    @Override
    public FieldDescription visitExecutable(ExecutableElement e, Void p) {
        if (e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getSimpleName().toString().startsWith("get") && e.getParameters().size() == 0) {
            String methodName = e.getSimpleName().toString();
            String fieldNameDirect = methodName.replaceFirst("get", "");
            String fieldName = fieldNameDirect.substring(0, 1).toLowerCase() + fieldNameDirect.substring(1);
            String fieldType = this.parseType(e, e.getReturnType(), false);
            if (fieldType != null) {
                FieldDescription.Type type = this.parseType(e.getReturnType());
                this.writer.println("  // Method " + methodName + " for field " + fieldName + " of " + fieldType);
                this.createFeatureMatcher(methodName + "()", fieldName, fieldNameDirect, fieldType, type);
                this.writer.println();
                return new FieldDescription(methodName + "()", fieldName, fieldNameDirect, fieldType, type);
            }
        } else if (e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getSimpleName().toString().startsWith("is") && e.getParameters().size() == 0) {
            String methodName = e.getSimpleName().toString();
            String fieldNameDirect = methodName.replaceFirst("is", "");
            String fieldName = fieldNameDirect.substring(0, 1).toLowerCase() + fieldNameDirect.substring(1);
            String fieldType = this.parseType(e, e.getReturnType(), false);
            if (fieldType != null) {
                FieldDescription.Type type = this.parseType(e.getReturnType());
                this.writer.println("  // Method " + methodName + " for field " + fieldName + " of " + fieldType);
                this.createFeatureMatcher(methodName + "()", fieldName, fieldNameDirect, fieldType, type);
                this.writer.println();
                return new FieldDescription(methodName + "()", fieldName, fieldNameDirect, fieldType, type);
            }
        }
        return null;
    }

    private void createFeatureMatcher(String fieldAccessor, String fieldName, String methodFieldName, String fieldType, FieldDescription.Type typeSpecial) {
        String type = this.typeElement.getSimpleName().toString();
        this.writer.println("  // " + (Object)((Object)typeSpecial));
        this.writer.println("  private static class " + methodFieldName + "Matcher" + this.fullGeneric + " extends org.hamcrest.FeatureMatcher<" + type + this.generic + "," + fieldType + "> {");
        this.writer.println();
        this.writer.println("    public " + methodFieldName + "Matcher(org.hamcrest.Matcher<? super " + fieldType + "> matcher) {");
        this.writer.println("      super(matcher,\"" + fieldName + "\",\"" + fieldName + "\");");
        this.writer.println("  }");
        switch (typeSpecial) {
            case ARRAY: {
                break;
            }
            case SET: {
                break;
            }
            case COLLECTION: {
                break;
            }
            case OPTIONAL: {
                this.writer.println("    public static " + methodFieldName + "Matcher isPresent() {");
                this.writer.println("      return new " + methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<java.util.Optional>(\"optional is present\"){");
                this.writer.println("        public boolean matchesSafely(java.util.Optional o) {return o.isPresent();}");
                this.writer.println("      });");
                this.writer.println("  }");
                this.writer.println("    public static " + methodFieldName + "Matcher isNotPresent() {");
                this.writer.println("      return new " + methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<java.util.Optional>(\"optional is not present\"){");
                this.writer.println("        public boolean matchesSafely(java.util.Optional o) {return !o.isPresent();}");
                this.writer.println("      });");
                this.writer.println("  }");
                break;
            }
        }
        this.writer.println();
        this.writer.println("    protected " + fieldType + " featureValueOf(" + type + this.generic + " actual) {");
        this.writer.println("      return actual." + fieldAccessor + ";");
        this.writer.println("    }");
        this.writer.println();
        this.writer.println("  }");
        this.writer.println();
    }

    private String parseType(Element e, TypeMirror type, boolean asPrimitif) {
        return type.accept(new ExtractNameVisitor(e, asPrimitif), null);
    }

    private FieldDescription.Type parseType(TypeMirror type) {
        return type.accept(new ExtracTypeVisitor(), null);
    }

    private final class ExtractNameVisitor
    extends TypeKindVisitor8<String, Void> {
        private final boolean asPrimitif;
        private final Element e;

        public ExtractNameVisitor(Element e, boolean asPrimitif) {
            this.asPrimitif = asPrimitif;
            this.e = e;
        }

        @Override
        public String visitPrimitiveAsBoolean(PrimitiveType t, Void p) {
            return this.asPrimitif ? "boolean" : "Boolean";
        }

        @Override
        public String visitPrimitiveAsByte(PrimitiveType t, Void p) {
            return this.asPrimitif ? "byte" : "Byte";
        }

        @Override
        public String visitPrimitiveAsShort(PrimitiveType t, Void p) {
            return this.asPrimitif ? "short" : "Short";
        }

        @Override
        public String visitPrimitiveAsInt(PrimitiveType t, Void p) {
            return this.asPrimitif ? "int" : "Integer";
        }

        @Override
        public String visitPrimitiveAsLong(PrimitiveType t, Void p) {
            return this.asPrimitif ? "long" : "Long";
        }

        @Override
        public String visitPrimitiveAsChar(PrimitiveType t, Void p) {
            return this.asPrimitif ? "char" : "Character";
        }

        @Override
        public String visitPrimitiveAsFloat(PrimitiveType t, Void p) {
            return this.asPrimitif ? "float" : "Float";
        }

        @Override
        public String visitPrimitiveAsDouble(PrimitiveType t, Void p) {
            return this.asPrimitif ? "double" : "Double";
        }

        @Override
        public String visitArray(ArrayType t, Void p) {
            return ProvidesMatchersSubElementVisitor.this.parseType(this.e, t.getComponentType(), true) + "[]";
        }

        @Override
        public String visitDeclared(DeclaredType t, Void p) {
            return t.toString();
        }

        @Override
        public String visitTypeVariable(TypeVariable t, Void p) {
            return t.toString();
        }

        @Override
        public String visitUnknown(TypeMirror t, Void p) {
            ProvidesMatchersSubElementVisitor.this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element", this.e);
            return null;
        }
    }

    private final class ExtracTypeVisitor
    extends TypeKindVisitor8<FieldDescription.Type, Void> {
        private ExtracTypeVisitor() {
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsBoolean(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsByte(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsShort(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsInt(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsLong(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsChar(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsFloat(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsDouble(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitArray(ArrayType t, Void p) {
            return FieldDescription.Type.ARRAY;
        }

        @Override
        public FieldDescription.Type visitDeclared(DeclaredType t, Void p) {
            if (ProvidesMatchersSubElementVisitor.this.typesUtils.isAssignable(t, ProvidesMatchersSubElementVisitor.this.typesUtils.erasure(ProvidesMatchersSubElementVisitor.this.elementsUtils.getTypeElement("java.util.Optional").asType()))) {
                return FieldDescription.Type.OPTIONAL;
            }
            if (ProvidesMatchersSubElementVisitor.this.typesUtils.isAssignable(t, ProvidesMatchersSubElementVisitor.this.typesUtils.erasure(ProvidesMatchersSubElementVisitor.this.elementsUtils.getTypeElement("java.util.Set").asType()))) {
                return FieldDescription.Type.SET;
            }
            if (ProvidesMatchersSubElementVisitor.this.typesUtils.isAssignable(t, ProvidesMatchersSubElementVisitor.this.typesUtils.erasure(ProvidesMatchersSubElementVisitor.this.elementsUtils.getTypeElement("java.util.List").asType()))) {
                return FieldDescription.Type.LIST;
            }
            if (ProvidesMatchersSubElementVisitor.this.typesUtils.isAssignable(t, ProvidesMatchersSubElementVisitor.this.typesUtils.erasure(ProvidesMatchersSubElementVisitor.this.elementsUtils.getTypeElement("java.util.Collection").asType()))) {
                return FieldDescription.Type.COLLECTION;
            }
            if (ProvidesMatchersSubElementVisitor.this.typesUtils.isAssignable(t, ProvidesMatchersSubElementVisitor.this.typesUtils.erasure(ProvidesMatchersSubElementVisitor.this.elementsUtils.getTypeElement("java.lang.Comparable").asType()))) {
                return FieldDescription.Type.COMPARABLE;
            }
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitTypeVariable(TypeVariable t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitUnknown(TypeMirror t, Void p) {
            ProvidesMatchersSubElementVisitor.this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element");
            return FieldDescription.Type.NA;
        }
    }
}

