/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FieldDescription {
    private final String fieldAccessor;
    private final String fieldName;
    private final String methodFieldName;
    private final String fieldType;
    private final Type type;
    private final List<Generator> implGenerator;
    private final List<Generator> dslGenerator;

    public FieldDescription(String fieldAccessor, String fieldName, String methodFieldName, String fieldType, Type type) {
        this.fieldAccessor = fieldAccessor;
        this.fieldName = fieldName;
        this.methodFieldName = methodFieldName;
        this.fieldType = fieldType;
        this.type = type;
        ArrayList<Generator> tmp1 = new ArrayList<Generator>();
        ArrayList<Generator> tmp2 = new ArrayList<Generator>();
        tmp1.add(this::getImplementationForDefault);
        tmp2.add(this::getDslForDefault);
        switch (type) {
            case ARRAY: {
                tmp1.add(this::getImplementationForArray);
                tmp2.add(this::getDslForArray);
                break;
            }
            case OPTIONAL: {
                tmp1.add(this::getImplementationForOptional);
                tmp2.add(this::getDslForOptional);
                break;
            }
            case COMPARABLE: {
                tmp1.add(this::getImplementationForComparable);
                tmp2.add(this::getDslForComparable);
                break;
            }
            case STRING: {
                tmp1.add(this::getImplementationForComparable);
                tmp2.add(this::getDslForComparable);
                tmp1.add(this::getImplementationForString);
                tmp2.add(this::getDslForString);
                break;
            }
            case COLLECTION: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case LIST: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case SET: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
        }
        this.implGenerator = Collections.unmodifiableList(tmp1);
        this.dslGenerator = Collections.unmodifiableList(tmp2);
    }

    private String getImplementationForDefault(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "(org.hamcrest.Matcher<? super " + this.fieldType + "> matcher) {").append("\n");
        sb.append(prefix).append("  " + this.fieldName + "= new " + this.methodFieldName + "Matcher(matcher);").append("\n");
        sb.append(prefix).append("  return this;").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.is(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForString(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "ContainsString(String other) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.containsString(other));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "StartsWith(String other) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.startsWith(other));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "EndsWith(String other) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.endsWith(other));").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForIterable(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "IsEmptyIterable() {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.emptyIterable());").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForArray(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "IsEmpty() {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.emptyArray());").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForCollection(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "IsEmpty() {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.empty());").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForOptional(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "IsPresent() {").append("\n");
        sb.append(prefix).append("  " + this.fieldName + " = " + this.methodFieldName + "Matcher.isPresent();").append("\n");
        sb.append(prefix).append("  return this;").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "IsNotPresent() {").append("\n");
        sb.append(prefix).append("  " + this.fieldName + " = " + this.methodFieldName + "Matcher.isNotPresent();").append("\n");
        sb.append(prefix).append("  return this;").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    private String getImplementationForComparable(String inputClassName, String returnMethod, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "ComparesEqualTo(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.comparesEqualTo(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "LessThan(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.lessThan(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "LessThanOrEqualTo(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.lessThanOrEqualTo(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "GreaterThan(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.greaterThan(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        sb.append(prefix).append("@Override").append("\n");
        sb.append(prefix).append("public " + returnMethod + " " + this.fieldName + "GreaterThanOrEqualTo(" + this.fieldType + " value) {").append("\n");
        sb.append(prefix).append("  return " + this.fieldName + "(org.hamcrest.Matchers.greaterThanOrEqualTo(value));").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    public String getImplementationInterface(String inputClassName, String returnMethod, String prefix) {
        return this.implGenerator.stream().map(g -> g.generate(inputClassName, returnMethod, prefix)).collect(Collectors.joining("\n"));
    }

    public String getDslForDefault(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + ".").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param matcher a Matcher on the field.").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("(org.hamcrest.Matcher<? super " + this.fieldType + "> matcher);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + ".").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value an expected value for the field, which will be compared using the is matcher.").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#is(java.lang.Object)").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("(" + this.fieldType + " value);").append("\n");
        return sb.toString();
    }

    private String getDslForString(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the string contains another one.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param other the string is contains in the other one.").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#containsString(java.lang.String)").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("ContainsString(String other);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the string contains another one.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param other the string is contains in the other one.").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#startsWith(java.lang.String)").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("StartsWith(String other);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the string contains another one.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param other the string is contains in the other one.").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#endsWith(java.lang.String)").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("EndsWith(String other);").append("\n");
        return sb.toString();
    }

    private String getDslForIterable(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the iterable is empty.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("IsEmptyIterable();").append("\n");
        return sb.toString();
    }

    private String getDslForArray(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the array is empty.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("IsEmpty();").append("\n");
        return sb.toString();
    }

    private String getDslForCollection(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that the collection is empty.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("IsEmpty();").append("\n");
        return sb.toString();
    }

    private String getDslForOptional(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " with a present optional.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("IsPresent();").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " with a not present optional.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("IsNotPresent();").append("\n");
        return sb.toString();
    }

    private String getDslForComparable(String inputClassName, String returnMethod, String prefix) {
        String linkToAccessor = "{@link " + inputClassName + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(" /**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that this field is equals to another one, using the compareTo method.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value the value to compare with").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#comparesEqualTo(java.lang.Comparable) ").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("ComparesEqualTo(" + this.fieldType + " value);").append("\n");
        sb.append(prefix).append(" /**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that this field is less than another value.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value the value to compare with").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#lessThan(java.lang.Comparable) ").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("LessThan(" + this.fieldType + " value);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that this field is less or equal than another value.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value the value to compare with").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#lessThanOrEqualTo(java.lang.Comparable) ").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("LessThanOrEqualTo(" + this.fieldType + " value);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that this field is greater than another value.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value the value to compare with").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#greaterThan(java.lang.Comparable) ").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("GreaterThan(" + this.fieldType + " value);").append("\n");
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * Add a validation on the field " + this.fieldName + " that this field is greater or equal than another value.").append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * ").append(linkToAccessor).append("\n");
        sb.append(prefix).append(" *").append("\n");
        sb.append(prefix).append(" * @param value the value to compare with").append("\n");
        sb.append(prefix).append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        sb.append(prefix).append(" * @see org.hamcrest.Matchers#greaterThanOrEqualTo(java.lang.Comparable) ").append("\n");
        sb.append(prefix).append(" */").append("\n");
        sb.append(prefix).append(returnMethod).append(this.fieldName).append("GreaterThanOrEqualTo(" + this.fieldType + " value);").append("\n");
        return sb.toString();
    }

    public String getDslInterface(String inputClassName, String returnMethod, String prefix) {
        return this.dslGenerator.stream().map(g -> g.generate(inputClassName, returnMethod, prefix)).collect(Collectors.joining("\n"));
    }

    public String getMatcherForField(String shortClassName, String generic, String fullGeneric, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("// " + (Object)((Object)this.type)).append("\n");
        sb.append(prefix).append("private static class " + this.methodFieldName + "Matcher" + fullGeneric + " extends org.hamcrest.FeatureMatcher<" + shortClassName + generic + "," + this.fieldType + "> {").append("\n");
        sb.append(prefix).append("  public " + this.methodFieldName + "Matcher(org.hamcrest.Matcher<? super " + this.fieldType + "> matcher) {").append("\n");
        sb.append(prefix).append("    super(matcher,\"" + this.fieldName + "\",\"" + this.fieldName + "\");").append("\n");
        sb.append(prefix).append("  }").append("\n");
        if (this.type == Type.OPTIONAL) {
            sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isPresent() {").append("\n");
            sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is present\"){").append("\n");
            sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return o.isPresent();}").append("\n");
            sb.append(prefix).append("    });").append("\n");
            sb.append(prefix).append("  }").append("\n");
            sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isNotPresent() {").append("\n");
            sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is not present\"){").append("\n");
            sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return !o.isPresent();}").append("\n");
            sb.append(prefix).append("    });").append("\n");
            sb.append(prefix).append("  }").append("\n");
        }
        sb.append(prefix).append("  protected " + this.fieldType + " featureValueOf(" + shortClassName + generic + " actual) {").append("\n");
        sb.append(prefix).append("    return actual." + this.fieldAccessor + ";").append("\n");
        sb.append(prefix).append("  }").append("\n");
        sb.append(prefix).append("}").append("\n");
        return sb.toString();
    }

    public String getFieldAccessor() {
        return this.fieldAccessor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Type getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface Generator {
        public String generate(String var1, String var2, String var3);
    }

    public static enum Type {
        NA,
        ARRAY,
        COLLECTION,
        LIST,
        SET,
        OPTIONAL,
        COMPARABLE,
        STRING;

    }
}

