/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.provideprocessor.FieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersSubElementVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"ch.powerunit.extensions.matchers.ProvideMatchers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor.factory"})
public class ProvidesMatchersAnnotationsProcessor
extends AbstractProcessor {
    private String factory = null;
    private List<String> factories = new ArrayList<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.factory = processingEnv.getOptions().get(ProvidesMatchersAnnotationsProcessor.class.getName() + ".factory");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementsUtils = this.processingEnv.getElementUtils();
        Filer filerUtils = this.processingEnv.getFiler();
        Types typesUtils = this.processingEnv.getTypeUtils();
        Messager messageUtils = this.processingEnv.getMessager();
        TypeElement provideMatchersTE = elementsUtils.getTypeElement("ch.powerunit.extensions.matchers.ProvideMatchers");
        TypeElement objectTE = elementsUtils.getTypeElement("java.lang.Object");
        if (!roundEnv.processingOver()) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ProvideMatchers.class);
            for (Element element : elements) {
                if (roundEnv.getRootElements().contains(element)) {
                    TypeElement te = element.accept(new ProvidesMatchersElementVisitor(this, elementsUtils, filerUtils, typesUtils, messageUtils, provideMatchersTE), null);
                    if (te == null) continue;
                    this.factories.add(this.processOneTypeElement(elementsUtils, filerUtils, typesUtils, messageUtils, te, objectTE, elements));
                    continue;
                }
                break;
            }
        } else if (this.factory != null) {
            try {
                JavaFileObject jfo = filerUtils.createSourceFile(this.factory, new Element[0]);
                Throwable throwable = null;
                try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                    wjfo.println("package " + this.factory.replaceAll("\\.[^.]+$", "") + ";");
                    wjfo.println();
                    wjfo.println("/**");
                    wjfo.println(" * Factories generated.");
                    wjfo.println(" * <p> ");
                    wjfo.println(" * This DSL can be use in several way : ");
                    wjfo.println(" * <ul> ");
                    wjfo.println(" *  <li>By implementing this interface. In this case, all the methods of this interface will be available inside the implementing class.</li>");
                    wjfo.println(" *  <li>By refering the static field named {@link #DSL} which expose all the DSL method.</li>");
                    wjfo.println(" * </ul> ");
                    wjfo.println(" */");
                    wjfo.println("@javax.annotation.Generated(value=\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\")");
                    String cName = this.factory.replaceAll("^([^.]+\\.)*", "");
                    wjfo.println("public interface " + cName + " {");
                    wjfo.println();
                    wjfo.println("  /**");
                    wjfo.println("   * Use this static field to access all the DSL syntax, without be required to implements this interface.");
                    wjfo.println("   */");
                    wjfo.println("  public static final " + cName + " DSL = new " + cName + "() {};");
                    wjfo.println();
                    this.factories.stream().forEach(wjfo::println);
                    wjfo.println("}");
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e1) {
                messageUtils.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + this.factory + "`, because of " + e1.getMessage());
            }
        }
        return true;
    }

    private String processOneTypeElement(Elements elementsUtils, Filer filerUtils, Types typesUtils, Messager messageUtils, TypeElement te, TypeElement objectTE, Set<? extends Element> elements) {
        StringBuilder factories = new StringBuilder();
        Name inputClassName = te.getQualifiedName();
        Name packageName = elementsUtils.getPackageOf(te).getQualifiedName();
        String outputClassName = inputClassName + "Matchers";
        String outputSimpleName = te.getSimpleName().toString() + "Matchers";
        String shortClassName = te.getSimpleName().toString();
        String methodShortClassName = shortClassName.substring(0, 1).toLowerCase() + shortClassName.substring(1);
        boolean hasParent = !objectTE.asType().equals(te.getSuperclass());
        boolean hasParentInSameRound = elements.stream().filter(e -> typesUtils.isSameType(e.asType(), te.asType())).findAny().isPresent();
        String generic = "";
        String fullGeneric = "";
        if (te.getTypeParameters().size() > 0) {
            generic = "<" + te.getTypeParameters().stream().map(t -> t.toString()).collect(Collectors.joining(",")) + ">";
            fullGeneric = "<" + te.getTypeParameters().stream().map(t -> t.toString() + " extends " + t.getBounds().stream().map(b -> b.toString()).collect(Collectors.joining("&"))).collect(Collectors.joining(",")) + ">";
        }
        try {
            JavaFileObject jfo = filerUtils.createSourceFile(outputClassName, te);
            try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                wjfo.println("package " + packageName + ";");
                wjfo.println();
                wjfo.println("/**");
                wjfo.println(" * This class provides matchers for the class {@link " + shortClassName + "}.");
                wjfo.println(" * ");
                wjfo.println(" * @see " + shortClassName + " The class for which matchers are provided.");
                wjfo.println(" */");
                wjfo.println("@javax.annotation.Generated(value=\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\")");
                wjfo.println("public final class " + outputSimpleName + " {");
                wjfo.println();
                wjfo.println("  private " + outputSimpleName + "() {}");
                wjfo.println();
                List<FieldDescription> fields = this.generateAndExtractFieldAndParentPrivateMatcher(elementsUtils, filerUtils, typesUtils, messageUtils, te, shortClassName, hasParent, generic, fullGeneric, wjfo);
                this.generatePublicInterface(inputClassName, shortClassName, generic, fullGeneric, wjfo, fields);
                wjfo.println();
                this.generatePrivateImplementation(te, inputClassName, shortClassName, hasParent, generic, fullGeneric, wjfo, fields);
                wjfo.println();
                factories.append(this.generateDSLStarter(packageName.toString(), typesUtils, te, inputClassName, shortClassName, methodShortClassName, hasParent, hasParentInSameRound, generic, fullGeneric, wjfo, fields));
                wjfo.println("}");
            }
        }
        catch (IOException e1) {
            messageUtils.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class", te);
        }
        return factories.toString();
    }

    private List<FieldDescription> generateAndExtractFieldAndParentPrivateMatcher(Elements elementsUtils, Filer filerUtils, Types typesUtils, Messager messageUtils, TypeElement te, String shortClassName, boolean hasParent, String generic, String fullGeneric, PrintWriter wjfo) {
        List<FieldDescription> fields = te.getEnclosedElements().stream().map(ie -> ie.accept(new ProvidesMatchersSubElementVisitor(elementsUtils, typesUtils, messageUtils), null)).filter(v -> v != null).collect(Collectors.toList());
        wjfo.println(fields.stream().map(f -> f.getMatcherForField(shortClassName, generic, fullGeneric, "  ")).collect(Collectors.joining("\n")));
        if (hasParent) {
            wjfo.println("  private static class SuperClassMatcher" + fullGeneric + " extends org.hamcrest.FeatureMatcher<" + shortClassName + "," + te.getSuperclass().toString() + "> {");
            wjfo.println();
            wjfo.println("    public SuperClassMatcher(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> matcher) {");
            wjfo.println("      super(matcher,\"parent\",\"parent\");");
            wjfo.println("  }");
            wjfo.println();
            wjfo.println("    protected " + te.getSuperclass().toString() + " featureValueOf(" + shortClassName + " actual) {");
            wjfo.println("      return actual;");
            wjfo.println("    }");
            wjfo.println();
            wjfo.println("  }");
            wjfo.println();
            wjfo.println();
        }
        return fields;
    }

    private String generateDSLStarter(String packageName, Types typesUtils, TypeElement te, Name inputClassName, String shortClassName, String methodShortClassName, boolean hasParent, boolean hasParentInSameRound, String generic, String fullGeneric, PrintWriter wjfo, List<FieldDescription> fields) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        String methodName = fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With()";
        javadoc.append("  /**").append("\n");
        javadoc.append("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.").append("\n");
        javadoc.append("   * ").append("\n");
        javadoc.append("   * @return the DSL matcher.").append("\n");
        javadoc.append("   */").append("\n");
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + (String)methodName + " {");
        factories.append("  default " + fullGeneric + " " + packageName + "." + shortClassName + "Matchers" + "." + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With()" + " {").append("\n");
        factories.append("    return " + packageName + "." + shortClassName + "Matchers." + methodShortClassName + "With();").append("\n");
        factories.append("  }").append("\n");
        if (hasParent) {
            wjfo.println("    return new " + shortClassName + "MatcherImpl(org.hamcrest.Matchers.anything());");
        } else {
            wjfo.println("    return new " + shortClassName + "MatcherImpl" + generic + "();");
        }
        wjfo.println("  }");
        if (hasParent) {
            javadoc = new StringBuilder();
            javadoc.append("  /**").append("\n");
            javadoc.append("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.").append("\n");
            javadoc.append("   * ").append("\n");
            javadoc.append("   * @param matcherOnParent the matcher on the parent data.").append("\n");
            javadoc.append("   * @return the DSL matcher.").append("\n");
            javadoc.append("   */").append("\n");
            wjfo.println(javadoc.toString());
            factories.append(javadoc.toString());
            wjfo.println("  @org.hamcrest.Factory");
            wjfo.println("  public static " + fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> matcherOnParent) {");
            wjfo.println("    return new " + shortClassName + "MatcherImpl" + generic + "(matcherOnParent);");
            wjfo.println("  }");
            factories.append("  default " + fullGeneric + " " + packageName + "." + shortClassName + "Matchers" + "." + shortClassName + "Matcher" + generic + " " + methodShortClassName + "With(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> matcherOnParent)" + " {").append("\n");
            factories.append("    return " + packageName + "." + shortClassName + "Matchers." + methodShortClassName + "With(matcherOnParent);").append("\n");
            factories.append("  }").append("\n");
        }
        wjfo.println();
        if (!hasParent) {
            javadoc = new StringBuilder();
            javadoc.append("  /**").append("\n");
            javadoc.append("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.").append("\n");
            javadoc.append("   * ").append("\n");
            javadoc.append("   * @param other the other object to be used as a reference.").append("\n");
            javadoc.append("   * @return the DSL matcher.").append("\n");
            javadoc.append("   */").append("\n");
            wjfo.println(javadoc.toString());
            factories.append(javadoc.toString());
            wjfo.println("  @org.hamcrest.Factory");
            wjfo.println("  public static " + fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "WithSameValue(" + shortClassName + " " + generic + " other) {");
            wjfo.println("    " + shortClassName + "Matcher" + generic + " m=new " + shortClassName + "MatcherImpl" + generic + "();");
            for (FieldDescription f : fields) {
                wjfo.println("    m." + f.getFieldName() + "(org.hamcrest.Matchers.is(other." + f.getFieldAccessor() + "));");
            }
            wjfo.println("    return m;");
            wjfo.println("  }");
            factories.append("  default " + fullGeneric + " " + packageName + "." + shortClassName + "Matchers" + "." + shortClassName + "Matcher" + generic + " " + methodShortClassName + "WithSameValue(" + shortClassName + " " + generic + " other)" + " {").append("\n");
            factories.append("    return " + packageName + "." + shortClassName + "Matchers." + methodShortClassName + "WithSameValue(other);").append("\n");
            factories.append("  }").append("\n");
        }
        if (hasParent && hasParentInSameRound) {
            javadoc = new StringBuilder();
            javadoc.append("  /**").append("\n");
            javadoc.append("   * Start a DSL matcher for the {@link " + inputClassName + " " + shortClassName + "}.").append("\n");
            javadoc.append("   * ").append("\n");
            javadoc.append("   * @param other the other object to be used as a reference.").append("\n");
            javadoc.append("   * @return the DSL matcher.").append("\n");
            javadoc.append("   */").append("\n");
            wjfo.println(javadoc.toString());
            factories.append(javadoc.toString());
            wjfo.println("  @org.hamcrest.Factory");
            String pname = typesUtils.asElement(te.getSuperclass()).getSimpleName().toString();
            wjfo.println("  public static " + fullGeneric + " " + shortClassName + "Matcher" + generic + " " + methodShortClassName + "WithSameValue(" + shortClassName + " " + generic + " other) {");
            wjfo.println("    " + shortClassName + "Matcher" + generic + " m=new " + shortClassName + "MatcherImpl" + generic + "(" + te.getSuperclass().toString().replaceAll("<.*$", "") + "Matchers." + pname.substring(0, 1).toLowerCase() + pname.substring(1) + "WithSameValue(other));");
            for (FieldDescription f : fields) {
                wjfo.println("    m." + f.getFieldName() + "(org.hamcrest.Matchers.is(other." + f.getFieldAccessor() + "));");
            }
            wjfo.println("    return m;");
            wjfo.println("  }");
            factories.append("  default " + fullGeneric + " " + packageName + "." + shortClassName + "Matchers" + "." + shortClassName + "Matcher" + generic + " " + methodShortClassName + "WithSameValue(" + shortClassName + " " + generic + " other)" + " {").append("\n");
            factories.append("    return " + packageName + "." + shortClassName + "Matchers." + methodShortClassName + "WithSameValue(other);").append("\n");
            factories.append("  }").append("\n");
        }
        return factories.toString();
    }

    private String generateMethodReturn(List<FieldDescription> fields, String shortClassName, String generic) {
        if (fields.size() == 1) {
            return "org.hamcrest.Matcher<" + shortClassName + generic + "> ";
        }
        return shortClassName + "Matcher" + generic + " ";
    }

    private void generatePrivateImplementation(TypeElement te, Name inputClassName, String shortClassName, boolean hasParent, String generic, String fullGeneric, PrintWriter wjfo, List<FieldDescription> fields) {
        wjfo.println("  /* package protected */ static class " + shortClassName + "MatcherImpl" + fullGeneric + " extends org.hamcrest.TypeSafeDiagnosingMatcher<" + shortClassName + generic + "> implements " + shortClassName + "Matcher" + generic + " {");
        for (FieldDescription f2 : fields) {
            wjfo.println("    private " + f2.getMethodFieldName() + "Matcher " + f2.getFieldName() + " = new " + f2.getMethodFieldName() + "Matcher(org.hamcrest.Matchers.anything());");
        }
        wjfo.println();
        if (hasParent) {
            wjfo.println("    private final SuperClassMatcher parent;");
            wjfo.println();
            wjfo.println("    public " + shortClassName + "MatcherImpl(org.hamcrest.Matcher<? super " + te.getSuperclass().toString() + "> parent) {");
            wjfo.println("      this.parent=new SuperClassMatcher(parent);");
            wjfo.println("    }");
            wjfo.println();
        }
        String returnMethod = this.generateMethodReturn(fields, shortClassName, generic);
        wjfo.println(fields.stream().map(f -> f.getImplementationInterface(inputClassName.toString(), returnMethod, "    ")).collect(Collectors.joining("\n")));
        wjfo.println("    @Override");
        wjfo.println("    protected boolean matchesSafely(" + shortClassName + " actual, org.hamcrest.Description mismatchDescription) {");
        wjfo.println("      boolean result=true;");
        if (hasParent) {
            wjfo.println("      if(!parent.matches(actual)) {");
            wjfo.println("        mismatchDescription.appendText(\"[\"); parent.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");");
            wjfo.println("        result=false;");
            wjfo.println("      }");
        }
        for (FieldDescription f3 : fields) {
            wjfo.println("      if(!" + f3.getFieldName() + ".matches(actual)) {");
            wjfo.println("        mismatchDescription.appendText(\"[\"); " + f3.getFieldName() + ".describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");");
            wjfo.println("        result=false;");
            wjfo.println("      }");
        }
        wjfo.println("      return result;");
        wjfo.println("    }");
        wjfo.println();
        wjfo.println("    @Override");
        wjfo.println("    public void describeTo(org.hamcrest.Description description) {");
        wjfo.println("        description.appendText(\"an instance of " + inputClassName + " with\\n\");");
        if (hasParent) {
            wjfo.println("        description.appendText(\"[\").appendDescriptionOf(parent).appendText(\"]\\n\");");
        }
        for (FieldDescription f3 : fields) {
            wjfo.println("        description.appendText(\"[\").appendDescriptionOf(" + f3.getFieldName() + ").appendText(\"]\\n\");");
        }
        wjfo.println("    }");
        wjfo.println("  }");
    }

    private void generatePublicInterface(Name inputClassName, String shortClassName, String generic, String fullGeneric, PrintWriter wjfo, List<FieldDescription> fields) {
        wjfo.println("  /**");
        wjfo.println("   * DSL interface for matcher on {@link " + inputClassName + " " + shortClassName + "}.");
        wjfo.println("   */");
        wjfo.println("  public static interface " + shortClassName + "Matcher" + fullGeneric + " extends org.hamcrest.Matcher<" + shortClassName + generic + "> {");
        String returnMethod = this.generateMethodReturn(fields, shortClassName, generic);
        wjfo.println(fields.stream().map(f -> f.getDslInterface(inputClassName.toString(), returnMethod, "    ")).collect(Collectors.joining("\n")));
        wjfo.println("  }");
    }

    AnnotationMirror getProvideMatchersAnnotation(TypeElement provideMatchersTE, Collection<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().equals(provideMatchersTE.asType())) continue;
            return annotationMirror;
        }
        return null;
    }
}

