/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

class FactoryElementVisitor
extends SimpleElementVisitor8<Optional<ExecutableElement>, Void> {
    private final FactoryAnnotationsProcessor factoryAnnotationsProcessor;
    private final Elements elementsUtils;
    private final Messager messageUtils;
    private final TypeElement factoryTE;

    public FactoryElementVisitor(FactoryAnnotationsProcessor factoryAnnotationsProcessor, Elements elementsUtils, Messager messageUtils, TypeElement factoryTE) {
        this.factoryAnnotationsProcessor = factoryAnnotationsProcessor;
        this.elementsUtils = elementsUtils;
        this.messageUtils = messageUtils;
        this.factoryTE = factoryTE;
    }

    @Override
    public Optional<ExecutableElement> visitExecutable(ExecutableElement e, Void p) {
        if (e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return Optional.of(e);
        }
        return this.defaultAction((Element)e, p);
    }

    @Override
    protected Optional<ExecutableElement> defaultAction(Element e, Void p) {
        this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `Factory` is used on an unsupported element", e, this.factoryAnnotationsProcessor.getFactoryAnnotation(this.factoryTE, this.elementsUtils.getAllAnnotationMirrors(e)));
        return Optional.empty();
    }
}

