/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

class ProvidesMatchersElementVisitor
extends SimpleElementVisitor8<Optional<TypeElement>, Void> {
    private final ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor;
    private final Elements elementsUtils;
    private final Messager messageUtils;
    private final TypeElement provideMatchersTE;

    public ProvidesMatchersElementVisitor(ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor, Elements elementsUtils, Messager messageUtils, TypeElement provideMatchersTE) {
        this.providesMatchersAnnotationsProcessor = providesMatchersAnnotationsProcessor;
        this.elementsUtils = elementsUtils;
        this.messageUtils = messageUtils;
        this.provideMatchersTE = provideMatchersTE;
    }

    @Override
    public Optional<TypeElement> visitType(TypeElement e, Void p) {
        switch (e.getKind()) {
            case ENUM: {
                this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an enum, which is not supported", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.elementsUtils.getAllAnnotationMirrors(e)));
                return Optional.empty();
            }
            case INTERFACE: {
                this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an interface, which is not supported", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.elementsUtils.getAllAnnotationMirrors(e)));
                return Optional.empty();
            }
        }
        return Optional.of(e);
    }

    @Override
    protected Optional<TypeElement> defaultAction(Element e, Void p) {
        this.messageUtils.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an unsupported element", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.elementsUtils.getAllAnnotationMirrors(e)));
        return Optional.empty();
    }
}

