/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.AddToMatcher;
import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatcherField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class FieldDescription {
    private static final String SEE_TEXT_FOR_IS_MATCHER = "org.hamcrest.Matchers#is(java.lang.Object)";
    private static final String SEE_TEXT_FOR_HAMCREST_MATCHER = "org.hamcrest.Matchers The main class from hamcrest that provides default matchers.";
    private final String fieldAccessor;
    private final String fieldName;
    private final String methodFieldName;
    private final String fieldType;
    private final String fullyQualifiedNameMatcherInSameRound;
    private final Type type;
    private final List<Function<String, String>> implGenerator;
    private final List<Function<String, String>> dslGenerator;
    private final ProcessingEnvironment processingEnv;
    private final ProvideMatchersAnnotatedElementMirror containingElementMirror;
    private final boolean ignore;
    private final Element fieldElement;
    private final TypeMirror fieldTypeMirror;
    private final String generic;
    private final String defaultReturnMethod;
    private final AddToMatcher[] addToMatchers;

    public FieldDescription(ProvideMatchersAnnotatedElementMirror containingElementMirror, String fieldAccessor, String fieldName, String methodFieldName, String fieldType, Type type, boolean isInSameRound, ProcessingEnvironment processingEnv, boolean ignore, Element fieldElement, TypeMirror fieldTypeMirror) {
        this.containingElementMirror = containingElementMirror;
        this.fieldAccessor = fieldAccessor;
        this.fieldName = fieldName;
        this.methodFieldName = methodFieldName;
        this.fieldType = fieldType;
        this.type = type;
        this.processingEnv = processingEnv;
        this.ignore = ignore;
        this.fieldElement = fieldElement;
        this.fieldTypeMirror = fieldTypeMirror;
        this.defaultReturnMethod = containingElementMirror.getDefaultReturnMethod();
        this.addToMatchers = (AddToMatcher[])fieldElement.getAnnotationsByType(AddToMatcher.class);
        if (fieldTypeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)fieldTypeMirror;
            this.generic = dt.getTypeArguments().stream().map(Object::toString).collect(Collectors.joining(","));
        } else {
            this.generic = "";
        }
        if (isInSameRound) {
            TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(fieldType);
            if (typeElement != null) {
                String simpleName = typeElement.getSimpleName().toString() + "Matchers";
                String packageName = processingEnv.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
                String fullyQualifiedNameMatcher = typeElement.getQualifiedName().toString() + "Matchers";
                ProvideMatchers pm = typeElement.getAnnotation(ProvideMatchers.class);
                if (!"".equals(pm.matchersClassName())) {
                    fullyQualifiedNameMatcher = fullyQualifiedNameMatcher.replaceAll(simpleName + "$", pm.matchersClassName());
                    simpleName = pm.matchersClassName();
                }
                if (!"".equals(pm.matchersPackageName())) {
                    fullyQualifiedNameMatcher = fullyQualifiedNameMatcher.replaceAll("^" + packageName, pm.matchersPackageName());
                    packageName = pm.matchersPackageName();
                }
                this.fullyQualifiedNameMatcherInSameRound = fullyQualifiedNameMatcher;
            } else {
                this.fullyQualifiedNameMatcherInSameRound = null;
            }
        } else {
            this.fullyQualifiedNameMatcherInSameRound = null;
        }
        ArrayList<Function<String, String>> tmp1 = new ArrayList<Function<String, String>>();
        ArrayList<Function<String, String>> tmp2 = new ArrayList<Function<String, String>>();
        tmp1.add(this::getImplementationForDefault);
        tmp2.add(this::getDslForDefault);
        if (this.fullyQualifiedNameMatcherInSameRound != null && processingEnv.getElementUtils().getTypeElement(fieldType).getTypeParameters().isEmpty()) {
            tmp1.add(this::getImplementationForDefaultChaining);
            tmp2.add(this::getDslForDefaultChaining);
        }
        switch (type) {
            case ARRAY: {
                tmp1.add(this::getImplementationForArray);
                tmp2.add(this::getDslForArray);
                break;
            }
            case OPTIONAL: {
                tmp1.add(this::getImplementationForOptional);
                tmp2.add(this::getDslForOptional);
                break;
            }
            case COMPARABLE: {
                tmp1.add(this::getImplementationForComparable);
                tmp2.add(this::getDslForComparable);
                break;
            }
            case STRING: {
                tmp1.add(this::getImplementationForComparable);
                tmp2.add(this::getDslForComparable);
                tmp1.add(this::getImplementationForString);
                tmp2.add(this::getDslForString);
                break;
            }
            case COLLECTION: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case LIST: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case SET: {
                tmp1.add(this::getImplementationForIterable);
                tmp2.add(this::getDslForIterable);
                tmp1.add(this::getImplementationForCollection);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case SUPPLIER: {
                tmp1.add(this::getImplementationForSupplier);
                tmp2.add(this::getDslForSupplier);
            }
        }
        tmp1.addAll(Arrays.stream(this.addToMatchers).map(this::generateFunctionForImplementation).filter(t -> t != null).collect(Collectors.toList()));
        tmp2.addAll(Arrays.stream(this.addToMatchers).map(this::generateFunctionForDSL).filter(t -> t != null).collect(Collectors.toList()));
        this.implGenerator = Collections.unmodifiableList(tmp1);
        this.dslGenerator = Collections.unmodifiableList(tmp2);
    }

    private Function<String, String> generateFunctionForDSL(AddToMatcher a) {
        return prefix -> this.buildDsl((String)prefix, this.getJavaDocFor(Optional.empty(), Optional.empty(), Optional.empty()), this.generateDeclaration(a.suffix(), a.argument()));
    }

    private Function<String, String> generateFunctionForImplementation(AddToMatcher a) {
        return prefix -> this.buildImplementation((String)prefix, this.generateDeclaration(a.suffix(), a.argument()), Arrays.stream(a.body()).map(l -> prefix + l).collect(Collectors.joining("\n")) + "\n" + prefix + "return this;");
    }

    private String getJavaDocFor(Optional<String> addToDescription, Optional<String> param, Optional<String> see) {
        String linkToAccessor = "{@link " + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append("/**").append("\n");
        sb.append(" * Add a validation on the field `").append(this.fieldName).append("`");
        addToDescription.ifPresent(t -> sb.append(" ").append((String)t));
        sb.append(".").append("\n");
        sb.append(" * <p>").append("\n");
        sb.append(" *").append("\n");
        sb.append(" * <i>").append(linkToAccessor).append("</i>").append("\n");
        sb.append(" * <p>").append("\n");
        sb.append(" * <b>In case method specifing a matcher on a fields are used several times, only the last setted matcher will be used.</b> ").append("\n");
        sb.append(" * When several control must be done on a single field, hamcrest itself provides a way to combine several matchers (See for instance {@link org.hamcrest.Matchers#both(org.hamcrest.Matcher)}.").append("\n");
        sb.append(" *").append("\n");
        param.ifPresent(t -> sb.append(" * @param ").append((String)t).append(".").append("\n"));
        sb.append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        see.ifPresent(t -> sb.append(" * @see ").append((String)t).append("\n"));
        sb.append(" */");
        return sb.toString();
    }

    private String buildImplementation(String prefix, String declaration, String body) {
        return prefix + "@Override" + "\n" + prefix + "public " + declaration + " {\n" + prefix + "  " + body.replaceAll("\\R", "\n" + prefix + "  ") + "\n" + prefix + "}" + "\n";
    }

    private String buildDsl(String prefix, String javadoc, String declaration) {
        return prefix + javadoc.replaceAll("\\R", "\n" + prefix) + "\n" + prefix + declaration + ";\n";
    }

    private String generateDeclaration(String postFix, String arguments) {
        return this.defaultReturnMethod + " " + this.fieldName + postFix + "(" + arguments + ")";
    }

    private String getImplementationForSupplier(String prefix) {
        return this.buildImplementation(prefix, this.generateDeclaration("SupplierResult", "org.hamcrest.Matcher<? super " + this.generic + "> matcherOnResult"), "return " + this.fieldName + "(new " + this.methodFieldName + "MatcherSupplier(matcherOnResult));");
    }

    private String getImplementationForDefault(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("", "org.hamcrest.Matcher<? super " + this.fieldType + "> matcher"), this.fieldName + "= new " + this.methodFieldName + "Matcher(matcher);\nreturn this;"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.is(value));"));
        return sb.toString();
    }

    private String getImplementationForDefaultChaining(String prefix) {
        TypeElement targetElement = this.processingEnv.getElementUtils().getTypeElement(this.fieldType);
        String name = targetElement.getSimpleName().toString();
        String lname = name.substring(0, 1).toLowerCase() + name.substring(1);
        return this.buildImplementation(prefix, this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher" + "<" + this.defaultReturnMethod + "> " + this.fieldName + "With()", this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher tmp = " + this.fullyQualifiedNameMatcherInSameRound + "." + lname + "WithParent(this);\n" + this.fieldName + "(tmp);\nreturn tmp;");
    }

    private String getImplementationForString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("ContainsString", "String other"), "return " + this.fieldName + "(org.hamcrest.Matchers.containsString(other));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("StartsWith", "String other"), "return " + this.fieldName + "(org.hamcrest.Matchers.startsWith(other));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("EndsWith", "String other"), "return " + this.fieldName + "(org.hamcrest.Matchers.endsWith(other));"));
        return sb.toString();
    }

    private String getImplementationForIterable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("IsEmptyIterable", ""), "return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.emptyIterable());"));
        if (!"".equals(this.generic)) {
            sb.append(this.buildImplementation(prefix, this.generateDeclaration("Contains", this.generic + "... elements"), "return " + this.fieldName + "(org.hamcrest.Matchers.contains(elements));"));
            sb.append(this.buildImplementation(prefix, this.generateDeclaration("Contains", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements"), "return " + this.fieldName + "(org.hamcrest.Matchers.contains(matchersOnElements));"));
            sb.append(this.buildImplementation(prefix, this.generateDeclaration("ContainsInAnyOrder", this.generic + "... elements"), "return " + this.fieldName + "(org.hamcrest.Matchers.containsInAnyOrder(elements));"));
            sb.append(this.buildImplementation(prefix, this.generateDeclaration("ContainsInAnyOrder", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements"), "return " + this.fieldName + "(org.hamcrest.Matchers.containsInAnyOrder(matchersOnElements));"));
            sb.append(this.buildImplementation(prefix, this.generateDeclaration("Contains", "java.util.List<org.hamcrest.Matcher<? super " + this.generic + ">> matchersOnElements"), "return " + this.fieldName + "(org.hamcrest.Matchers.contains(matchersOnElements));"));
        }
        return sb.toString();
    }

    private String getImplementationForArray(String prefix) {
        return this.buildImplementation(prefix, this.generateDeclaration("IsEmpty", ""), "return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.emptyArray());");
    }

    private String getImplementationForCollection(String prefix) {
        return this.buildImplementation(prefix, this.generateDeclaration("IsEmpty", ""), "return " + this.fieldName + "((org.hamcrest.Matcher)org.hamcrest.Matchers.empty());");
    }

    private String getImplementationForOptional(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("IsPresent", ""), this.fieldName + " = " + this.methodFieldName + "Matcher.isPresent();\nreturn this;"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("IsNotPresent", ""), this.fieldName + " = " + this.methodFieldName + "Matcher.isNotPresent();\nreturn this;"));
        return sb.toString();
    }

    private String getImplementationForComparable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("ComparesEqualTo", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.comparesEqualTo(value));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("LessThan", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.lessThan(value));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("LessThanOrEqualTo", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.lessThanOrEqualTo(value));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("GreaterThan", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.greaterThan(value));"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("GreaterThanOrEqualTo", this.fieldType + " value"), "return " + this.fieldName + "(org.hamcrest.Matchers.greaterThanOrEqualTo(value));"));
        return sb.toString();
    }

    public String getImplementationInterface(String prefix) {
        return this.implGenerator.stream().map(g -> (String)g.apply(prefix)).collect(Collectors.joining("\n"));
    }

    public String getDslForSupplier(String prefix) {
        return this.buildDsl(prefix, this.getJavaDocFor(Optional.of(" Validate that the result of the supplier is accepted by another matcher (the result of the execution must be stable)"), Optional.of("matcherOnResult a Matcher on result of the supplier execution"), Optional.empty()), this.generateDeclaration("SupplierResult", "org.hamcrest.Matcher<? super " + this.generic + "> matcherOnResult"));
    }

    public String getDslForDefault(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.empty(), Optional.of("matcher a Matcher on the field"), Optional.of(SEE_TEXT_FOR_HAMCREST_MATCHER)), this.generateDeclaration("", "org.hamcrest.Matcher<? super " + this.fieldType + "> matcher")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.empty(), Optional.of("value an expected value for the field, which will be compared using the is matcher"), Optional.of(SEE_TEXT_FOR_IS_MATCHER)), this.generateDeclaration("", this.fieldType + " value")));
        return sb.toString();
    }

    public String getDslForDefaultChaining(String prefix) {
        TypeElement targetElement = this.processingEnv.getElementUtils().getTypeElement(this.fieldType);
        String name = targetElement.getSimpleName().toString();
        return this.buildDsl(prefix, this.getJavaDocFor(Optional.of("by starting a matcher for this field"), Optional.empty(), Optional.empty()), this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher" + "<" + this.defaultReturnMethod + "> " + this.fieldName + "With()");
    }

    private String getDslForString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the string contains another one"), Optional.of("other the string is contains in the other one"), Optional.of("org.hamcrest.Matchers#containsString(java.lang.String)")), this.generateDeclaration("ContainsString", "String other")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the string starts with another one"), Optional.of("other the string to use to compare"), Optional.of("org.hamcrest.Matchers#startsWith(java.lang.String)")), this.generateDeclaration("StartsWith", "String other")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the string ends with another one"), Optional.of("other the string to use to compare"), Optional.of("org.hamcrest.Matchers#endsWith(java.lang.String)")), this.generateDeclaration("EndsWith", "String other")));
        return sb.toString();
    }

    private String getDslForIterable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmptyIterable", "")));
        if (!"".equals(this.generic)) {
            sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements"), Optional.of("elements the elements"), Optional.of("org.hamcrest.Matchers#contains(java.lang.Object[])")), this.generateDeclaration("Contains", this.generic + "... elements")));
            sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using matchers"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#contains(org.hamcrest.Matcher[])")), this.generateDeclaration("Contains", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements")));
            sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements in any order"), Optional.of("elements the elements"), Optional.of("org.hamcrest.Matchers#containsInAnyOrder(java.lang.Object[])")), this.generateDeclaration("ContainsInAnyOrder", this.generic + "... elements")));
            sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using matchers in any order"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#containsInAnyOrder(org.hamcrest.Matcher[])")), this.generateDeclaration("ContainsInAnyOrder", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements")));
            sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using list of matcher"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#contains(java.util.List)")), this.generateDeclaration("Contains", "java.util.List<org.hamcrest.Matcher<? super " + this.generic + ">> matchersOnElements")));
        }
        return sb.toString();
    }

    private String getDslForArray(String prefix) {
        return this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the array is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmpty", ""));
    }

    private String getDslForCollection(String prefix) {
        return this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that the collection is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmpty", ""));
    }

    private String getDslForOptional(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("with a present optional"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsPresent", "")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("with a not present optional"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsNotPresent", "")));
        return sb.toString();
    }

    private String getDslForComparable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that this field is equals to another one, using the compareTo method"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#comparesEqualTo(java.lang.Comparable)")), this.generateDeclaration("ComparesEqualTo", this.fieldType + " value")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that this field is less than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#lessThan(java.lang.Comparable)")), this.generateDeclaration("LessThan", this.fieldType + " value")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that this field is less or equal than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#lessThanOrEqualTo(java.lang.Comparable)")), this.generateDeclaration("LessThanOrEqualTo", this.fieldType + " value")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that this field is greater than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#greaterThan(java.lang.Comparable)")), this.generateDeclaration("GreaterThan", this.fieldType + " value")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("that this field is greater or equal than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#greaterThanOrEqualTo(java.lang.Comparable)")), this.generateDeclaration("GreaterThanOrEqualTo", this.fieldType + " value")));
        return sb.toString();
    }

    public String getDslInterface(String prefix) {
        return this.dslGenerator.stream().map(g -> (String)g.apply(prefix)).collect(Collectors.joining("\n"));
    }

    public String getMatcherForField(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("private static class " + this.methodFieldName + "Matcher" + this.containingElementMirror.getFullGeneric() + " extends org.hamcrest.FeatureMatcher<" + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + this.containingElementMirror.getGeneric() + "," + this.fieldType + "> {").append("\n");
        sb.append(prefix).append("  public " + this.methodFieldName + "Matcher(org.hamcrest.Matcher<? super " + this.fieldType + "> matcher) {").append("\n");
        sb.append(prefix).append("    super(matcher,\"" + this.fieldName + "\",\"" + this.fieldName + "\");").append("\n");
        sb.append(prefix).append("  }").append("\n");
        switch (this.type) {
            case OPTIONAL: {
                sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isPresent() {").append("\n");
                sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is present\"){").append("\n");
                sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return o.isPresent();}").append("\n");
                sb.append(prefix).append("    });").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isNotPresent() {").append("\n");
                sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is not present\"){").append("\n");
                sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return !o.isPresent();}").append("\n");
                sb.append(prefix).append("    });").append("\n");
                sb.append(prefix).append("  }").append("\n");
                break;
            }
        }
        sb.append(prefix).append("  protected " + this.fieldType + " featureValueOf(" + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + this.containingElementMirror.getGeneric() + " actual) {").append("\n");
        sb.append(prefix).append("    return actual." + this.fieldAccessor + ";").append("\n");
        sb.append(prefix).append("  }").append("\n");
        sb.append(prefix).append("}").append("\n");
        switch (this.type) {
            case SUPPLIER: {
                sb.append(prefix).append("private static class " + this.methodFieldName + "MatcherSupplier" + this.containingElementMirror.getFullGeneric() + " extends org.hamcrest.FeatureMatcher<java.util.function.Supplier<" + this.generic + ">," + this.generic + "> {").append("\n");
                sb.append(prefix).append("  public " + this.methodFieldName + "MatcherSupplier(org.hamcrest.Matcher<? super " + this.generic + "> matcher) {").append("\n");
                sb.append(prefix).append("    super(matcher,\"with supplier result\",\"with supplier result\");").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("  protected " + this.generic + " featureValueOf(java.util.function.Supplier<" + this.generic + "> actual) {").append("\n");
                sb.append(prefix).append("    return actual.get();").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("}").append("\n");
                break;
            }
        }
        return sb.toString();
    }

    private String getFieldCopyDefault(String lhs, String rhs) {
        return lhs + "." + this.fieldName + "(org.hamcrest.Matchers.is(" + rhs + "." + this.fieldAccessor + "))";
    }

    private String getSameValueMatcherFor(String target, TypeElement targetElement) {
        String name = targetElement.getSimpleName().toString();
        String lname = name.substring(0, 1).toLowerCase() + name.substring(1);
        return this.fullyQualifiedNameMatcherInSameRound + "." + lname + "WithSameValue(" + target + ")";
    }

    private String getFieldCopySameRound(String lhs, String rhs, TypeElement targetElement) {
        return lhs + "." + this.fieldName + "(" + rhs + "." + this.fieldAccessor + "==null?org.hamcrest.Matchers.nullValue():" + this.getSameValueMatcherFor(rhs + "." + this.fieldAccessor, targetElement) + ")";
    }

    private String generateMatcherBuilderReferenceFor(String generic) {
        ProvideMatchersAnnotatedElementMirror target = this.containingElementMirror.findMirrorFor(generic);
        if (target != null) {
            return target.getFullyQualifiedNameOfGeneratedClass() + "::" + target.getMethodShortClassName() + "WithSameValue";
        }
        return "org.hamcrest.Matchers::is";
    }

    private String getFieldCopyForList(String lhs, String rhs) {
        return "if(" + rhs + "." + this.fieldAccessor + "==null) {" + lhs + "." + this.fieldName + "(org.hamcrest.Matchers.nullValue()); } else if (" + rhs + "." + this.fieldAccessor + ".isEmpty()) {" + lhs + "." + this.fieldName + "IsEmptyIterable(); } else {" + lhs + "." + this.fieldName + "Contains(" + rhs + "." + this.fieldAccessor + ".stream().map(" + this.generateMatcherBuilderReferenceFor(this.generic) + ").collect(java.util.stream.Collectors.toList())); }";
    }

    public String getFieldCopy(String lhs, String rhs) {
        if (!(this.type != Type.LIST && this.type != Type.SET && this.type != Type.COLLECTION || "".equals(this.generic))) {
            return this.getFieldCopyForList(lhs, rhs);
        }
        if (this.fullyQualifiedNameMatcherInSameRound != null && this.processingEnv.getElementUtils().getTypeElement(this.fieldType).getTypeParameters().isEmpty()) {
            return this.getFieldCopySameRound(lhs, rhs, this.processingEnv.getElementUtils().getTypeElement(this.fieldType));
        }
        return this.getFieldCopyDefault(lhs, rhs);
    }

    public String getFieldAccessor() {
        return this.fieldAccessor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isNotIgnore() {
        return !this.ignore;
    }

    public String getDescriptionForIgnoreIfApplicable() {
        return Optional.ofNullable(this.fieldElement.getAnnotation(IgnoreInMatcher.class)).map(i -> i.comments()).orElse("");
    }

    public GeneratedMatcherField asGeneratedMatcherField() {
        GeneratedMatcherField gmf = new GeneratedMatcherField();
        gmf.setFieldIsIgnored(this.ignore);
        gmf.setFieldName(this.fieldName);
        gmf.setFieldCategory(this.type.name());
        gmf.setFieldAccessor(this.fieldAccessor);
        gmf.setGenericDetails(this.generic);
        return gmf;
    }

    public static enum Type {
        NA,
        ARRAY,
        COLLECTION,
        LIST,
        SET,
        OPTIONAL,
        COMPARABLE,
        STRING,
        SUPPLIER;

    }
}

