/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.provideprocessor.FieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersSubElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatcher;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class ProvideMatchersAnnotatedElementMirror {
    private final TypeElement typeElementForClassAnnotatedWithProvideMatcher;
    private final ProcessingEnvironment processingEnv;
    private final TypeElement objectTE;
    private final Predicate<Element> isInSameRound;
    private final String fullyQualifiedNameOfClassAnnotatedWithProvideMatcher;
    private final String packageNameOfGeneratedClass;
    private final String fullyQualifiedNameOfGeneratedClass;
    private final String simpleNameOfGeneratedClass;
    private final String simpleNameOfClassAnnotatedWithProvideMatcher;
    private final String methodShortClassName;
    private final boolean hasParent;
    private final boolean hasParentInSameRound;
    private final String generic;
    private final String fullGeneric;
    private final String comments;
    private final String paramJavadoc;
    private final String genericParent;
    private final String genericNoParent;
    private final String fullGenericParent;
    private final String fullGenericNoParent;
    private final String defaultReturnMethod;
    private final String fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher;
    private final String simpleNameOfGeneratedInterfaceMatcher;
    private final String simpleNameOfGeneratedImplementationMatcher;
    private final TypeElement typeElementForSuperClassOfClassAnnotatedWithProvideMatcher;
    private final Function<String, ProvideMatchersAnnotatedElementMirror> findMirrorForTypeName;
    private final String genericForChaining;
    private final Set<? extends Element>[] elementsWithOtherAnnotation;
    private final List<FieldDescription> fields;

    public ProvideMatchersAnnotatedElementMirror(TypeElement typeElement, ProcessingEnvironment processingEnv, Predicate<Element> isInSameRound, Function<String, ProvideMatchersAnnotatedElementMirror> findMirrorForTypeName, Set<? extends Element> ... elementsWithOtherAnnotation) {
        this.typeElementForClassAnnotatedWithProvideMatcher = typeElement;
        this.processingEnv = processingEnv;
        this.isInSameRound = isInSameRound;
        this.elementsWithOtherAnnotation = elementsWithOtherAnnotation;
        this.objectTE = processingEnv.getElementUtils().getTypeElement("java.lang.Object");
        this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher = typeElement.getQualifiedName().toString();
        String tpackageName = processingEnv.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        String toutputClassName = this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + "Matchers";
        String tsimpleNameOfGeneratedClass = typeElement.getSimpleName().toString() + "Matchers";
        ProvideMatchers pm = typeElement.getAnnotation(ProvideMatchers.class);
        this.comments = pm.comments();
        if (!"".equals(pm.matchersClassName())) {
            toutputClassName = toutputClassName.replaceAll(tsimpleNameOfGeneratedClass + "$", pm.matchersClassName());
            tsimpleNameOfGeneratedClass = pm.matchersClassName();
        }
        this.simpleNameOfGeneratedClass = tsimpleNameOfGeneratedClass;
        if (!"".equals(pm.matchersPackageName())) {
            toutputClassName = toutputClassName.replaceAll("^" + tpackageName, pm.matchersPackageName());
            tpackageName = pm.matchersPackageName();
        }
        this.fullyQualifiedNameOfGeneratedClass = toutputClassName;
        this.packageNameOfGeneratedClass = tpackageName;
        this.simpleNameOfClassAnnotatedWithProvideMatcher = typeElement.getSimpleName().toString();
        this.methodShortClassName = this.simpleNameOfClassAnnotatedWithProvideMatcher.substring(0, 1).toLowerCase() + this.simpleNameOfClassAnnotatedWithProvideMatcher.substring(1);
        this.hasParent = !this.objectTE.asType().equals(typeElement.getSuperclass());
        this.hasParentInSameRound = isInSameRound.test(typeElement);
        this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher = typeElement.getSuperclass().toString();
        this.typeElementForSuperClassOfClassAnnotatedWithProvideMatcher = (TypeElement)processingEnv.getTypeUtils().asElement(typeElement.getSuperclass());
        if (typeElement.getTypeParameters().size() > 0) {
            this.generic = "<" + typeElement.getTypeParameters().stream().map(t -> t.toString()).collect(Collectors.joining(",")) + ">";
            this.fullGeneric = "<" + typeElement.getTypeParameters().stream().map(t -> t.toString() + " extends " + t.getBounds().stream().map(b -> b.toString()).collect(Collectors.joining("&"))).collect(Collectors.joining(",")) + ">";
        } else {
            this.generic = "";
            this.fullGeneric = "";
        }
        this.paramJavadoc = ProvideMatchersAnnotatedElementMirror.extractParamCommentFromJavadoc(processingEnv.getElementUtils().getDocComment(typeElement));
        this.genericParent = ProvideMatchersAnnotatedElementMirror.getAddParentToGeneric(this.generic);
        this.genericNoParent = ProvideMatchersAnnotatedElementMirror.getAddNoParentToGeneric(this.generic);
        this.fullGenericParent = ProvideMatchersAnnotatedElementMirror.getAddParentToGeneric(this.fullGeneric);
        this.fullGenericNoParent = ProvideMatchersAnnotatedElementMirror.getAddNoParentToGeneric(this.fullGeneric);
        this.defaultReturnMethod = this.simpleNameOfClassAnnotatedWithProvideMatcher + "Matcher" + this.genericParent;
        this.simpleNameOfGeneratedInterfaceMatcher = this.simpleNameOfClassAnnotatedWithProvideMatcher + "Matcher";
        this.simpleNameOfGeneratedImplementationMatcher = this.simpleNameOfClassAnnotatedWithProvideMatcher + "MatcherImpl";
        this.findMirrorForTypeName = findMirrorForTypeName;
        this.genericForChaining = this.genericParent.replaceAll("^<_PARENT", "<" + this.fullyQualifiedNameOfGeneratedClass + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent);
        ProvidesMatchersSubElementVisitor providesMatchersSubElementVisitor = new ProvidesMatchersSubElementVisitor(processingEnv, isInSameRound);
        this.fields = typeElement.getEnclosedElements().stream().map(ie -> ie.accept(providesMatchersSubElementVisitor, this)).filter(Optional::isPresent).map(t -> (FieldDescription)t.get()).collect(Collectors.collectingAndThen(Collectors.groupingBy(t -> t.getFieldName(), Collectors.reducing(null, (v1, v2) -> v1 == null ? v2 : (v1.isIgnore() ? v1 : v2))), c -> c == null ? Collections.emptyList() : c.values().stream().collect(Collectors.toList())));
    }

    public String process() {
        StringBuilder factories = new StringBuilder();
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The class `" + this.fullyQualifiedNameOfGeneratedClass + "` will be generated as a Matchers class.", this.typeElementForClassAnnotatedWithProvideMatcher);
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(this.fullyQualifiedNameOfGeneratedClass, this.typeElementForClassAnnotatedWithProvideMatcher);
            try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                wjfo.println("package " + this.packageNameOfGeneratedClass + ";");
                wjfo.println();
                wjfo.println("/**");
                wjfo.println(" * This class provides matchers for the class {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + "}.");
                wjfo.println(" * ");
                wjfo.println(" * @see " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " The class for which matchers are provided.");
                wjfo.println(" */");
                wjfo.println("@javax.annotation.Generated(value=\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\",comments=" + ProvideMatchersAnnotatedElementMirror.toJavaSyntax(this.comments) + ")");
                wjfo.println("public final class " + this.simpleNameOfGeneratedClass + " {");
                wjfo.println();
                wjfo.println("  private " + this.simpleNameOfGeneratedClass + "() {}");
                wjfo.println();
                this.generateAndExtractFieldAndParentPrivateMatcher(wjfo);
                wjfo.println();
                this.generatePublicInterface(wjfo, this.fields);
                wjfo.println();
                this.generatePrivateImplementation(wjfo, this.fields);
                wjfo.println();
                factories.append(this.generateDSLStarter(wjfo, this.fields));
                wjfo.println("}");
            }
        }
        catch (IOException e1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class", this.typeElementForClassAnnotatedWithProvideMatcher);
        }
        return factories.toString();
    }

    private void generateAndExtractFieldAndParentPrivateMatcher(PrintWriter wjfo) {
        wjfo.println(this.fields.stream().map(f -> f.getMatcherForField("  ")).collect(Collectors.joining("\n")));
        if (this.hasParent) {
            wjfo.println("  private static class SuperClassMatcher" + this.fullGeneric + " extends org.hamcrest.FeatureMatcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + "," + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> {");
            wjfo.println();
            wjfo.println("    public SuperClassMatcher(org.hamcrest.Matcher<? super " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> matcher) {");
            wjfo.println("      super(matcher,\"parent\",\"parent\");");
            wjfo.println("  }");
            wjfo.println();
            wjfo.println("    protected " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + " featureValueOf(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " actual) {");
            wjfo.println("      return actual;");
            wjfo.println("    }");
            wjfo.println();
            wjfo.println("  }");
            wjfo.println();
            wjfo.println();
        }
    }

    private void generatePublicInterface(PrintWriter wjfo, List<FieldDescription> fields) {
        wjfo.println(this.generateJavaDoc("  ", "DSL interface for matcher on {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "} to support the build syntaxic sugar", Optional.empty(), Optional.empty(), Optional.empty(), true, false));
        wjfo.println("  public static interface " + this.simpleNameOfGeneratedInterfaceMatcher + "BuildSyntaxicSugar" + this.fullGeneric + " extends org.hamcrest.Matcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + this.generic + "> {");
        wjfo.println(this.generateJavaDoc("  ", "Method that return the matcher itself.", Optional.of("<b>This method is a syntaxic sugar that end the DSL and make clear that the matcher can't be change anymore.</b>"), Optional.empty(), Optional.of("the matcher"), false, false));
        wjfo.println("    default org.hamcrest.Matcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + this.generic + "> build() {");
        wjfo.println("      return this;");
        wjfo.println("    }");
        wjfo.println("  }");
        wjfo.println(this.generateJavaDoc("  ", "DSL interface for matcher on {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "} to support the end syntaxic sugar", Optional.empty(), Optional.empty(), Optional.empty(), true, true));
        wjfo.println("  public static interface " + this.simpleNameOfGeneratedInterfaceMatcher + "EndSyntaxicSugar" + this.fullGenericParent + " extends org.hamcrest.Matcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + this.generic + "> {");
        wjfo.println(this.generateJavaDoc("  ", "Method that return the parent builder", Optional.of("<b>This method only works in the contexte of a parent builder. If the real type is Void, then nothing will be returned.</b>"), Optional.empty(), Optional.of("the parent builder or null if not applicable"), false, false));
        wjfo.println("    _PARENT end();");
        wjfo.println("  }");
        wjfo.println(this.generateJavaDoc("  ", "DSL interface for matcher on {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.empty(), Optional.empty(), Optional.empty(), true, true));
        wjfo.println("  public static interface " + this.simpleNameOfGeneratedInterfaceMatcher + this.fullGenericParent + " extends org.hamcrest.Matcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + this.generic + ">," + this.simpleNameOfGeneratedInterfaceMatcher + "BuildSyntaxicSugar " + this.generic + "," + this.simpleNameOfGeneratedInterfaceMatcher + "EndSyntaxicSugar " + this.genericParent + " {");
        wjfo.println(fields.stream().filter(FieldDescription::isNotIgnore).map(f -> f.getDslInterface("    ")).collect(Collectors.joining("\n")));
        wjfo.println("  }");
    }

    private void generatePrivateImplementation(PrintWriter wjfo, List<FieldDescription> fields) {
        wjfo.println("  /* package protected */ static class " + this.simpleNameOfGeneratedImplementationMatcher + this.fullGenericParent + " extends org.hamcrest.TypeSafeDiagnosingMatcher<" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + this.generic + "> implements " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericParent + " {");
        fields.stream().filter(FieldDescription::isNotIgnore).map(f -> "    private " + f.getMethodFieldName() + "Matcher " + f.getFieldName() + " = new " + f.getMethodFieldName() + "Matcher(org.hamcrest.Matchers.anything());").forEach(wjfo::println);
        fields.stream().filter(FieldDescription::isIgnore).map(f -> "    private " + f.getMethodFieldName() + "Matcher " + f.getFieldName() + " = new " + f.getMethodFieldName() + "Matcher(org.hamcrest.Matchers.anything(\"This field is ignored \"+" + ProvideMatchersAnnotatedElementMirror.toJavaSyntax(f.getDescriptionForIgnoreIfApplicable()) + "));").forEach(wjfo::println);
        wjfo.println("    private final _PARENT _parentBuilder;");
        if (this.hasParent) {
            wjfo.println("    private SuperClassMatcher _parent;");
            wjfo.println();
            wjfo.println("    public " + this.simpleNameOfGeneratedImplementationMatcher + "(org.hamcrest.Matcher<? super " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> parent) {");
            wjfo.println("      this._parent=new SuperClassMatcher(parent);");
            wjfo.println("      this._parentBuilder=null;");
            wjfo.println("    }");
            wjfo.println();
            wjfo.println();
            wjfo.println("    public " + this.simpleNameOfGeneratedImplementationMatcher + "(org.hamcrest.Matcher<? super " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> parent,_PARENT parentBuilder) {");
            wjfo.println("      this._parent=new SuperClassMatcher(parent);");
            wjfo.println("      this._parentBuilder=parentBuilder;");
            wjfo.println("    }");
            wjfo.println();
        } else {
            wjfo.println();
            wjfo.println("    public " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "MatcherImpl() {");
            wjfo.println("      this._parentBuilder=null;");
            wjfo.println("    }");
            wjfo.println();
            wjfo.println();
            wjfo.println("    public " + this.simpleNameOfGeneratedImplementationMatcher + "(_PARENT parentBuilder) {");
            wjfo.println("      this._parentBuilder=parentBuilder;");
            wjfo.println("    }");
            wjfo.println();
        }
        wjfo.println(fields.stream().filter(FieldDescription::isNotIgnore).map(f -> f.getImplementationInterface("    ")).collect(Collectors.joining("\n")));
        wjfo.println("    @Override");
        wjfo.println("    protected boolean matchesSafely(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " actual, org.hamcrest.Description mismatchDescription) {");
        wjfo.println("      boolean result=true;");
        if (this.hasParent) {
            wjfo.println("      if(!_parent.matches(actual)) {");
            wjfo.println("        mismatchDescription.appendText(\"[\"); _parent.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");");
            wjfo.println("        result=false;");
            wjfo.println("      }");
        }
        for (FieldDescription f2 : fields) {
            wjfo.println("      if(!" + f2.getFieldName() + ".matches(actual)) {");
            wjfo.println("        mismatchDescription.appendText(\"[\"); " + f2.getFieldName() + ".describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");");
            wjfo.println("        result=false;");
            wjfo.println("      }");
        }
        wjfo.println("      return result;");
        wjfo.println("    }");
        wjfo.println();
        wjfo.println("    @Override");
        wjfo.println("    public void describeTo(org.hamcrest.Description description) {");
        wjfo.println("        description.appendText(\"an instance of " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " with\\n\");");
        if (this.hasParent) {
            wjfo.println("        description.appendText(\"[\").appendDescriptionOf(_parent).appendText(\"]\\n\");");
        }
        fields.stream().map(f -> "        description.appendText(\"[\").appendDescriptionOf(" + f.getFieldName() + ").appendText(\"]\\n\");").forEach(wjfo::println);
        wjfo.println("    }");
        wjfo.println();
        wjfo.println("    @Override");
        wjfo.println("    public _PARENT end() {");
        wjfo.println("      return _parentBuilder;");
        wjfo.println("    }");
        wjfo.println("  }");
    }

    private String generateDSLStarter(PrintWriter wjfo, List<FieldDescription> fields) {
        StringBuilder factories = new StringBuilder();
        factories.append(this.generateDefaultDSLStarter(wjfo));
        factories.append(this.generateDefaultForChainingDSLStarter(wjfo));
        if (this.hasParent) {
            factories.append(this.generateParentDSLStarter(wjfo));
        }
        wjfo.println();
        if (!this.hasParent) {
            factories.append(this.generateNoParentDSLStarter(wjfo, fields));
        }
        if (this.hasParent && this.hasParentInSameRound) {
            factories.append(this.generateParentInSameRoundDSLStarter(wjfo, fields));
        }
        return factories.toString();
    }

    private String generateDefaultDSLStarter(PrintWriter wjfo) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        String methodName = this.fullGeneric + " " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "With()";
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.of("The returned builder (which is also a Matcher), at this point accepts any object that is a {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}."), Optional.empty(), Optional.of("the DSL matcher"), true, false));
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + methodName + " {");
        factories.append("  default " + this.fullGeneric + " " + this.fullyQualifiedNameOfGeneratedClass + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "With()" + " {").append("\n");
        factories.append("    return " + this.fullyQualifiedNameOfGeneratedClass + "." + this.methodShortClassName + "With();").append("\n");
        factories.append("  }").append("\n");
        if (this.hasParent) {
            wjfo.println("    return new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "(org.hamcrest.Matchers.anything());");
        } else {
            wjfo.println("    return new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "();");
        }
        wjfo.println("  }");
        return factories.toString();
    }

    private String generateDefaultForChainingDSLStarter(PrintWriter wjfo) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        String methodName = this.fullGenericParent + " " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericParent + " " + this.methodShortClassName + "WithParent(_PARENT parentBuilder)";
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.of("The returned builder (which is also a Matcher), at this point accepts any object that is a {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}."), Optional.of("parentBuilder the parentBuilder."), Optional.of("the DSL matcher"), true, true));
        wjfo.println(javadoc.toString());
        wjfo.println("  public static " + methodName + " {");
        if (this.hasParent) {
            wjfo.println("    return new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericParent + "(org.hamcrest.Matchers.anything(),parentBuilder);");
        } else {
            wjfo.println("    return new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericParent + "(parentBuilder);");
        }
        wjfo.println("  }");
        return factories.toString();
    }

    private String generateParentDSLStarter(PrintWriter wjfo) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.empty(), Optional.of("matcherOnParent the matcher on the parent data."), Optional.of("the DSL matcher"), true, false));
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + this.fullGeneric + " " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "With(org.hamcrest.Matcher<? super " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> matcherOnParent) {");
        wjfo.println("    return new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "(matcherOnParent);");
        wjfo.println("  }");
        factories.append("  default " + this.fullGeneric + " " + this.fullyQualifiedNameOfGeneratedClass + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "With(org.hamcrest.Matcher<? super " + this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher + "> matcherOnParent)" + " {").append("\n");
        factories.append("    return " + this.fullyQualifiedNameOfGeneratedClass + "." + this.methodShortClassName + "With(matcherOnParent);").append("\n");
        factories.append("  }").append("\n");
        return factories.toString();
    }

    private String generateNoParentDSLStarter(PrintWriter wjfo, List<FieldDescription> fields) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.empty(), Optional.of("other the other object to be used as a reference."), Optional.of("the DSL matcher"), true, false));
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + this.fullGeneric + " " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "WithSameValue(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.generic + " other) {");
        wjfo.println("    " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " m=new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "();");
        fields.stream().filter(FieldDescription::isNotIgnore).map(f -> "    " + f.getFieldCopy("m", "other") + ";").forEach(wjfo::println);
        wjfo.println("    return m;");
        wjfo.println("  }");
        factories.append("  default " + this.fullGeneric + " " + this.fullyQualifiedNameOfGeneratedClass + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "WithSameValue(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.generic + " other)" + " {").append("\n");
        factories.append("    return " + this.fullyQualifiedNameOfGeneratedClass + "." + this.methodShortClassName + "WithSameValue(other);").append("\n");
        factories.append("  }").append("\n");
        return factories.toString();
    }

    private String generateParentInSameRoundDSLStarter(PrintWriter wjfo, List<FieldDescription> fields) {
        StringBuilder factories = new StringBuilder();
        ProvideMatchersAnnotatedElementMirror parentMirror = this.findMirrorForTypeName.apply(this.typeElementForSuperClassOfClassAnnotatedWithProvideMatcher.getQualifiedName().toString());
        factories.append(this.generateParentInSameRoundSameValueDSLStarter(wjfo, fields, parentMirror));
        if (this.typeElementForSuperClassOfClassAnnotatedWithProvideMatcher.getTypeParameters().isEmpty()) {
            factories.append(this.generateParentInSameRoundWithChaningDSLStarter(wjfo, parentMirror));
        }
        return factories.toString();
    }

    private String generateParentInSameRoundSameValueDSLStarter(PrintWriter wjfo, List<FieldDescription> fields, ProvideMatchersAnnotatedElementMirror parentMirror) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.empty(), Optional.of("other the other object to be used as a reference."), Optional.of("the DSL matcher"), true, false));
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + this.fullGeneric + " " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "WithSameValue(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.generic + " other) {");
        wjfo.println("    " + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " m=new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "(" + parentMirror.fullyQualifiedNameOfGeneratedClass + "." + parentMirror.methodShortClassName + "WithSameValue(other));");
        fields.stream().filter(FieldDescription::isNotIgnore).map(f -> "    " + f.getFieldCopy("m", "other") + ";").forEach(wjfo::println);
        wjfo.println("    return m;");
        wjfo.println("  }");
        factories.append("  default " + this.fullGeneric + " " + this.fullyQualifiedNameOfGeneratedClass + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.genericNoParent + " " + this.methodShortClassName + "WithSameValue(" + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.generic + " other)" + " {").append("\n");
        factories.append("    return " + this.fullyQualifiedNameOfGeneratedClass + "." + this.methodShortClassName + "WithSameValue(other);").append("\n");
        factories.append("  }").append("\n");
        return factories.toString();
    }

    private String generateParentInSameRoundWithChaningDSLStarter(PrintWriter wjfo, ProvideMatchersAnnotatedElementMirror parentMirror) {
        StringBuilder factories = new StringBuilder();
        StringBuilder javadoc = new StringBuilder();
        javadoc.append(this.generateJavaDoc("  ", "Start a DSL matcher for the {@link " + this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.simpleNameOfClassAnnotatedWithProvideMatcher + "}", Optional.empty(), Optional.empty(), Optional.of("the DSL matcher"), true, false));
        wjfo.println(javadoc.toString());
        factories.append(javadoc.toString());
        wjfo.println("  @org.hamcrest.Factory");
        wjfo.println("  public static " + this.fullGeneric + " " + parentMirror.fullyQualifiedNameOfGeneratedClass + "." + parentMirror.simpleNameOfGeneratedInterfaceMatcher + this.genericForChaining + " " + this.methodShortClassName + "WithParent() {");
        wjfo.println("    " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + " m=new " + this.simpleNameOfGeneratedImplementationMatcher + this.genericNoParent + "(org.hamcrest.Matchers.anything());");
        wjfo.println("    " + parentMirror.fullyQualifiedNameOfGeneratedClass + "." + parentMirror.simpleNameOfGeneratedInterfaceMatcher + " tmp = " + parentMirror.fullyQualifiedNameOfGeneratedClass + "." + parentMirror.methodShortClassName + "WithParent(m);");
        wjfo.println("    m._parent = new SuperClassMatcher(tmp);");
        wjfo.println("    return tmp;");
        wjfo.println("  }");
        factories.append("  default " + this.fullGeneric + " " + parentMirror.fullyQualifiedNameOfGeneratedClass + "." + parentMirror.simpleNameOfGeneratedInterfaceMatcher + this.genericForChaining + " " + this.methodShortClassName + "WithParent()" + " {").append("\n");
        factories.append("    return " + this.fullyQualifiedNameOfGeneratedClass + "." + this.methodShortClassName + "WithParent();").append("\n");
        factories.append("  }").append("\n");
        return factories.toString();
    }

    private String generateJavaDoc(String prefix, String description, Optional<String> moreDetails, Optional<String> param, Optional<String> returnDescription, boolean withParam, boolean withParent) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("/**").append("\n");
        sb.append(prefix).append(" * ").append(description).append(".\n");
        moreDetails.ifPresent(t -> sb.append(prefix).append(" * <p>\n").append(prefix).append(" * ").append((String)t).append("\n"));
        param.ifPresent(t -> sb.append(prefix).append(" * @param ").append((String)t).append("\n"));
        if (withParam) {
            sb.append(prefix).append(this.paramJavadoc.replaceAll("\\R", "\n" + prefix)).append(" * \n");
        }
        if (withParent) {
            sb.append(prefix).append(" * @param <_PARENT> used to reference, if necessary, a parent for this builder. By default Void is used an indicate no parent builder").append("\n");
        }
        returnDescription.ifPresent(t -> sb.append(prefix).append(" * @return ").append((String)t).append("\n"));
        sb.append(prefix).append(" */").append("\n");
        return sb.toString();
    }

    private static String toJavaSyntax(String unformatted) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (char c : unformatted.toCharArray()) {
            sb.append(ProvideMatchersAnnotatedElementMirror.toJavaSyntax(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return "" + ch;
    }

    private static String extractParamCommentFromJavadoc(String docComment) {
        if (docComment == null) {
            return " * \n";
        }
        boolean insideParam = false;
        StringBuilder sb = new StringBuilder();
        sb.append(" * \n");
        for (String line : docComment.split("\\R")) {
            if (insideParam && line.matches("^\\s*@.*$")) {
                insideParam = false;
            }
            if (line.matches("^\\s*@param.*$")) {
                insideParam = true;
            }
            if (!insideParam) continue;
            sb.append(" *" + line).append("\n");
        }
        return sb.toString();
    }

    private static String getAddParentToGeneric(String generic) {
        if ("".equals(generic)) {
            return "<_PARENT>";
        }
        return generic.replaceFirst("<", "<_PARENT,");
    }

    private static String getAddNoParentToGeneric(String generic) {
        if ("".equals(generic)) {
            return "<Void>";
        }
        return generic.replaceFirst("<", "<Void,");
    }

    public String getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() {
        return this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher;
    }

    public String getFullyQualifiedNameOfGeneratedClass() {
        return this.fullyQualifiedNameOfGeneratedClass;
    }

    public String getDefaultReturnMethod() {
        return this.defaultReturnMethod;
    }

    public String getFullGeneric() {
        return this.fullGeneric;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void removeFromIgnoreList(Element e) {
        Arrays.stream(this.elementsWithOtherAnnotation).forEach(t -> t.remove(e));
    }

    public boolean isInsideIgnoreList(Element e) {
        return Arrays.stream(this.elementsWithOtherAnnotation).map(t -> t.contains(e)).filter(t -> t).findAny().orElse(false);
    }

    public TypeElement getTypeElementForClassAnnotatedWithProvideMatcher() {
        return this.typeElementForClassAnnotatedWithProvideMatcher;
    }

    public ProvideMatchersAnnotatedElementMirror findMirrorFor(String name) {
        return this.findMirrorForTypeName.apply(name);
    }

    public String getMethodShortClassName() {
        return this.methodShortClassName;
    }

    public GeneratedMatcher asXml() {
        GeneratedMatcher gm = new GeneratedMatcher();
        gm.setFullyQualifiedNameGeneratedClass(this.fullyQualifiedNameOfGeneratedClass);
        gm.setFullyQualifiedNameInputClass(this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher);
        gm.setSimpleNameGeneratedClass(this.simpleNameOfGeneratedClass);
        gm.setSimpleNameInputClass(this.simpleNameOfClassAnnotatedWithProvideMatcher);
        gm.setDslMethodNameStart(this.methodShortClassName);
        gm.setGeneratedMatcherField(this.fields.stream().map(FieldDescription::asGeneratedMatcherField).collect(Collectors.toList()));
        gm.setMirror(this);
        return gm;
    }
}

