/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.provideprocessor.FieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersAnnotatedElementMirror;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.TypeKindVisitor8;
import javax.tools.Diagnostic;

public class ProvidesMatchersSubElementVisitor
extends SimpleElementVisitor8<Optional<FieldDescription>, ProvideMatchersAnnotatedElementMirror> {
    private final ProcessingEnvironment processingEnv;
    private final Predicate<Element> isInSameRound;
    private final ExtracTypeVisitor extractTypeVisitor = new ExtracTypeVisitor();
    private final ExtractNameVisitor extractNameVisitor = new ExtractNameVisitor();

    public ProvidesMatchersSubElementVisitor(ProcessingEnvironment processingEnv, Predicate<Element> isInSameRound) {
        this.processingEnv = processingEnv;
        this.isInSameRound = isInSameRound;
    }

    @Override
    public Optional<FieldDescription> visitVariable(VariableElement e, ProvideMatchersAnnotatedElementMirror p) {
        if (e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC)) {
            String fieldName = e.getSimpleName().toString();
            String fieldType = this.parseType(e.asType(), false);
            if (fieldType != null) {
                FieldDescription.Type type = this.parseType(e.asType());
                p.removeFromIgnoreList(e);
                return Optional.of(new FieldDescription(p, fieldName, fieldName, fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), fieldType, type, this.isInSameRound.test(this.processingEnv.getTypeUtils().asElement(e.asType())), this.processingEnv, e.getAnnotation(IgnoreInMatcher.class) != null, e, e.asType()));
            }
        }
        if (p.isInsideIgnoreList(e)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "One of the annotation is not supported as this location ; Check that this field is public and not static", e);
            p.removeFromIgnoreList(e);
        }
        return Optional.empty();
    }

    @Override
    public Optional<FieldDescription> visitExecutable(ExecutableElement e, ProvideMatchersAnnotatedElementMirror p) {
        if (e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getParameters().size() == 0 && !e.getModifiers().contains((Object)Modifier.STATIC)) {
            String simpleName = e.getSimpleName().toString();
            if (simpleName.startsWith("get")) {
                return Optional.ofNullable(this.visiteExecutableGet(e, "get", p));
            }
            if (simpleName.startsWith("is")) {
                return Optional.ofNullable(this.visiteExecutableGet(e, "is", p));
            }
        }
        if (p.isInsideIgnoreList(e)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "One of the annotation is not supported as this location ; CHeck that this method is public, doesn't have any parameter and is named isXXX or getXXX", e);
            p.removeFromIgnoreList(e);
        }
        return Optional.empty();
    }

    private FieldDescription visiteExecutableGet(ExecutableElement e, String prefix, ProvideMatchersAnnotatedElementMirror p) {
        String methodName = e.getSimpleName().toString();
        String fieldNameDirect = methodName.replaceFirst(prefix, "");
        String fieldName = fieldNameDirect.substring(0, 1).toLowerCase() + fieldNameDirect.substring(1);
        String fieldType = this.parseType(e.getReturnType(), false);
        if (fieldType != null) {
            FieldDescription.Type type = this.parseType(e.getReturnType());
            p.removeFromIgnoreList(e);
            return new FieldDescription(p, methodName + "()", fieldName, fieldNameDirect, fieldType, type, this.isInSameRound.test(this.processingEnv.getTypeUtils().asElement(e.asType())), this.processingEnv, e.getAnnotation(IgnoreInMatcher.class) != null, e, e.getReturnType());
        }
        return null;
    }

    @Override
    protected Optional<FieldDescription> defaultAction(Element e, ProvideMatchersAnnotatedElementMirror p) {
        return Optional.empty();
    }

    private String parseType(TypeMirror type, boolean asPrimitif) {
        return type.accept(this.extractNameVisitor, asPrimitif);
    }

    private FieldDescription.Type parseType(TypeMirror type) {
        return type.accept(this.extractTypeVisitor, null);
    }

    private final class ExtractNameVisitor
    extends TypeKindVisitor8<String, Boolean> {
        private ExtractNameVisitor() {
        }

        @Override
        public String visitPrimitiveAsBoolean(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "boolean" : "Boolean";
        }

        @Override
        public String visitPrimitiveAsByte(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "byte" : "Byte";
        }

        @Override
        public String visitPrimitiveAsShort(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "short" : "Short";
        }

        @Override
        public String visitPrimitiveAsInt(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "int" : "Integer";
        }

        @Override
        public String visitPrimitiveAsLong(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "long" : "Long";
        }

        @Override
        public String visitPrimitiveAsChar(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "char" : "Character";
        }

        @Override
        public String visitPrimitiveAsFloat(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "float" : "Float";
        }

        @Override
        public String visitPrimitiveAsDouble(PrimitiveType t, Boolean asPrimitif) {
            return asPrimitif != false ? "double" : "Double";
        }

        @Override
        public String visitArray(ArrayType t, Boolean asPrimitif) {
            return ProvidesMatchersSubElementVisitor.this.parseType(t.getComponentType(), true) + "[]";
        }

        @Override
        public String visitDeclared(DeclaredType t, Boolean asPrimitif) {
            return t.toString();
        }

        @Override
        public String visitTypeVariable(TypeVariable t, Boolean asPrimitif) {
            return t.toString();
        }

        @Override
        public String visitUnknown(TypeMirror t, Boolean asPrimitif) {
            ProvidesMatchersSubElementVisitor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element", ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().asElement(t));
            return null;
        }
    }

    private final class ExtracTypeVisitor
    extends TypeKindVisitor8<FieldDescription.Type, Void> {
        private ExtracTypeVisitor() {
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsBoolean(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsByte(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsShort(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsInt(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsLong(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsChar(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsFloat(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitPrimitiveAsDouble(PrimitiveType t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitArray(ArrayType t, Void p) {
            return FieldDescription.Type.ARRAY;
        }

        @Override
        public FieldDescription.Type visitDeclared(DeclaredType t, Void p) {
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.util.Optional").asType()))) {
                return FieldDescription.Type.OPTIONAL;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.util.Set").asType()))) {
                return FieldDescription.Type.SET;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.util.List").asType()))) {
                return FieldDescription.Type.LIST;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.util.Collection").asType()))) {
                return FieldDescription.Type.COLLECTION;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType()))) {
                return FieldDescription.Type.STRING;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.lang.Comparable").asType()))) {
                return FieldDescription.Type.COMPARABLE;
            }
            if (ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().isAssignable(t, ProvidesMatchersSubElementVisitor.this.processingEnv.getTypeUtils().erasure(ProvidesMatchersSubElementVisitor.this.processingEnv.getElementUtils().getTypeElement("java.util.function.Supplier").asType()))) {
                return FieldDescription.Type.SUPPLIER;
            }
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitTypeVariable(TypeVariable t, Void p) {
            return FieldDescription.Type.NA;
        }

        @Override
        public FieldDescription.Type visitUnknown(TypeMirror t, Void p) {
            ProvidesMatchersSubElementVisitor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element");
            return FieldDescription.Type.NA;
        }
    }
}

