/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;

class FactoryAnnotatedElementMirror {
    private final ExecutableElement element;
    private final Optional<String> doc;
    private final String surroundingFullyQualifiedName;
    private final FactoryAnnotationsProcessor factoryAnnotationsProcessor;

    public FactoryAnnotatedElementMirror(FactoryAnnotationsProcessor factoryAnnotationsProcessor, ExecutableElement element) {
        this.element = element;
        this.factoryAnnotationsProcessor = factoryAnnotationsProcessor;
        this.doc = Optional.ofNullable(factoryAnnotationsProcessor.getElementUtils().getDocComment(element));
        this.surroundingFullyQualifiedName = element.getEnclosingElement().asType().toString();
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public String getSurroundingFullyQualifiedName() {
        return this.surroundingFullyQualifiedName;
    }

    public String getSeeValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.factoryAnnotationsProcessor.getElementUtils().getPackageOf(this.element.getEnclosingElement()).getQualifiedName()).append(".").append(this.element.getEnclosingElement().getSimpleName().toString()).append("#").append(this.element.getSimpleName().toString()).append("(");
        sb.append(this.element.getParameters().stream().map(ve -> {
            Element e = this.factoryAnnotationsProcessor.getTypeUtils().asElement(ve.asType());
            if (e == null) {
                return this.factoryAnnotationsProcessor.getTypeUtils().erasure(ve.asType()).toString();
            }
            if (ve.asType().getKind() == TypeKind.TYPEVAR) {
                return this.factoryAnnotationsProcessor.getTypeUtils().erasure(ve.asType()).toString();
            }
            PackageElement pe = this.factoryAnnotationsProcessor.getElementUtils().getPackageOf(e);
            return pe.toString() + "." + this.factoryAnnotationsProcessor.getTypeUtils().asElement(ve.asType()).getSimpleName();
        }).collect(Collectors.joining(",")));
        sb.append(")");
        String result = sb.toString();
        if (this.element.isVarArgs()) {
            result = result.replaceAll("\\[\\](\\s[0-9a-zA-Z_]*$)??", "...");
        }
        return result;
    }

    public String generateFactory() {
        StringBuilder sb = new StringBuilder();
        sb.append("  // " + this.element.getSimpleName()).append("\n");
        sb.append("  /**\n   * " + this.doc.map(t -> t.replaceAll("\n", "\n   * ").replaceAll("  * $", "\n")).orElse("No javadoc found from the source method.")).append("\n");
        sb.append("   * @see " + this.getSeeValue() + "\n   */").append("\n");
        sb.append("  default ");
        if (!this.element.getTypeParameters().isEmpty()) {
            sb.append("<");
            sb.append(this.element.getTypeParameters().stream().map(ve -> ve.getSimpleName().toString() + (ve.getBounds().isEmpty() ? "" : " extends " + ve.getBounds().stream().map(b -> b.toString()).collect(Collectors.joining("&")))).collect(Collectors.joining(",")));
            sb.append("> ");
        }
        sb.append(this.element.getReturnType().toString());
        sb.append(" ");
        sb.append(this.element.getSimpleName().toString());
        sb.append("(");
        String param = this.element.getParameters().stream().map(ve -> ve.asType().toString() + " " + ve.getSimpleName().toString()).collect(Collectors.joining(","));
        sb.append(this.element.isVarArgs() ? param.replaceAll("\\[\\](\\s[0-9a-zA-Z_]*$)??", "...") : param);
        sb.append(") {").append("\n");
        if (TypeKind.VOID != this.element.getReturnType().getKind()) {
            sb.append("    return ");
        } else {
            sb.append("    ");
        }
        sb.append(this.factoryAnnotationsProcessor.getElementUtils().getPackageOf(this.element.getEnclosingElement()).getQualifiedName().toString());
        sb.append(".");
        sb.append(this.element.getEnclosingElement().getSimpleName().toString());
        sb.append(".");
        sb.append(this.element.getSimpleName().toString());
        sb.append("(");
        sb.append(this.element.getParameters().stream().map(ve -> ve.getSimpleName().toString()).collect(Collectors.joining(",")));
        sb.append(");").append("\n");
        sb.append("  }").append("\n");
        sb.append("\n");
        return sb.toString();
    }
}

