/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryElementVisitor;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryGroup;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.hamcrest.Factory;

@SupportedAnnotationTypes(value={"org.hamcrest.Factory"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor.targets"})
public class FactoryAnnotationsProcessor
extends AbstractProcessor
implements ProcessingEnvironment {
    private List<FactoryGroup> build;
    private TypeElement factoryAnnotationTE;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String targets = processingEnv.getOptions().get(FactoryAnnotationsProcessor.class.getName() + ".targets");
        if (targets == null || targets.trim().equals("")) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The parameter `" + FactoryAnnotationsProcessor.class.getName() + ".targets` is missing, please use it.");
            this.build = Collections.emptyList();
        } else {
            this.build = Arrays.stream(targets.split("\\s*;\\s*")).map(e -> new FactoryGroup(this, (String)e)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        this.factoryAnnotationTE = processingEnv.getElementUtils().getTypeElement("org.hamcrest.Factory");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.build.isEmpty()) {
            return false;
        }
        if (!roundEnv.processingOver()) {
            this.processFactoryAnnotation(roundEnv);
        } else {
            this.processGenerationOfFinalClasses();
        }
        return true;
    }

    public void processGenerationOfFinalClasses() {
        this.build.forEach(FactoryGroup::processGenerateOneFactoryInterface);
    }

    public void processFactoryAnnotation(RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Factory.class);
        FactoryElementVisitor factoryElementVisitor = new FactoryElementVisitor();
        elements.stream().filter(e -> roundEnv.getRootElements().contains(e.getEnclosingElement())).forEach(e -> e.accept(factoryElementVisitor, this).map(ee -> new FactoryAnnotatedElementMirror(this, (ExecutableElement)ee)).ifPresent(faem -> this.build.stream().filter(f -> f.isAccepted((FactoryAnnotatedElementMirror)faem)).forEach(f -> f.addMethod((FactoryAnnotatedElementMirror)faem))));
    }

    public AnnotationMirror getFactoryAnnotation(Element e) {
        return this.getElementUtils().getAllAnnotationMirrors(e).stream().filter(a -> a.getAnnotationType().equals(this.factoryAnnotationTE.asType())).findAny().orElse(null);
    }

    @Override
    public Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public Filer getFiler() {
        return this.processingEnv.getFiler();
    }

    @Override
    public Locale getLocale() {
        return this.processingEnv.getLocale();
    }

    @Override
    public Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processingEnv.getOptions();
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.processingEnv.getSourceVersion();
    }

    @Override
    public Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }
}

