/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.common.CommonConstants;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

class FactoryGroup {
    private final String[] acceptingRegex;
    private final String fullyQualifiedTargetName;
    private final List<FactoryAnnotatedElementMirror> method = new ArrayList<FactoryAnnotatedElementMirror>();
    private final FactoryAnnotationsProcessor parent;

    public FactoryGroup(FactoryAnnotationsProcessor parent, String definition) {
        this.parent = parent;
        String[] split = definition.split("\\s*:\\s*");
        this.acceptingRegex = split[0].split("\\s*,\\s*");
        this.fullyQualifiedTargetName = split[1];
    }

    public String[] getAcceptingRegex() {
        return this.acceptingRegex;
    }

    public String getFullyQualifiedTargetName() {
        return this.fullyQualifiedTargetName;
    }

    public void addMethod(FactoryAnnotatedElementMirror faem) {
        this.method.add(faem);
    }

    public boolean isAccepted(FactoryAnnotatedElementMirror faem) {
        return Arrays.stream(this.acceptingRegex).map(a -> faem.getSurroundingFullyQualifiedName().matches((String)a)).findAny().orElse(false);
    }

    public void processGenerateOneFactoryInterface() {
        try {
            JavaFileObject jfo = this.parent.getFiler().createSourceFile(this.fullyQualifiedTargetName, (Element[])this.method.stream().map(e -> e.getElement()).toArray(ExecutableElement[]::new));
            try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                String pName = this.fullyQualifiedTargetName.replaceAll("\\.[^.]+$", "");
                String cName = this.fullyQualifiedTargetName.substring(this.fullyQualifiedTargetName.lastIndexOf(46) + 1);
                wjfo.println("package " + pName + ";");
                wjfo.println();
                wjfo.println(CommonConstants.DEFAULT_JAVADOC_FOR_FACTORY);
                wjfo.println("@javax.annotation.Generated(value=\"" + FactoryAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\")");
                wjfo.println("public interface " + cName + " {");
                wjfo.println();
                wjfo.println("  /**");
                wjfo.println("   * Use this static field to access all the DSL syntax, without be required to implements this interface.");
                wjfo.println("   */");
                wjfo.println("  public static final " + cName + " DSL = new " + cName + "() {};");
                wjfo.println();
                this.method.stream().map(FactoryAnnotatedElementMirror::generateFactory).forEach(wjfo::println);
                wjfo.println("}");
            }
        }
        catch (IOException e2) {
            this.parent.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + this.fullyQualifiedTargetName + "`, because of " + e2.getMessage());
        }
    }
}

