/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.AddToMatcher;
import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatcherField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.TypeKindVisitor8;
import javax.tools.Diagnostic;

public class FieldDescription {
    private static final String SEE_TEXT_FOR_IS_MATCHER = "org.hamcrest.Matchers#is(java.lang.Object)";
    private static final String SEE_TEXT_FOR_HAMCREST_MATCHER = "org.hamcrest.Matchers The main class from hamcrest that provides default matchers.";
    private final String fieldAccessor;
    private final String fieldName;
    private final String methodFieldName;
    private final String fieldType;
    private final String fullyQualifiedNameMatcherInSameRound;
    private final Type type;
    private final List<Function<String, String>> implGenerator;
    private final List<Function<String, String>> dslGenerator;
    private final ProcessingEnvironment processingEnv;
    private final ProvidesMatchersAnnotatedElementMirror containingElementMirror;
    private final boolean ignore;
    private final Element fieldElement;
    private final String generic;
    private final String defaultReturnMethod;

    public static final String computeGenericInformation(TypeMirror fieldTypeMirror) {
        if (fieldTypeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)fieldTypeMirror;
            return dt.getTypeArguments().stream().map(Object::toString).collect(Collectors.joining(","));
        }
        return "";
    }

    public static final String computeFullyQualifiedNameMatcherInSameRound(ProcessingEnvironment processingEnv, boolean isInSameRound, String fieldType) {
        TypeElement typeElement;
        if (isInSameRound && (typeElement = processingEnv.getElementUtils().getTypeElement(fieldType)) != null) {
            String simpleName = typeElement.getSimpleName().toString() + "Matchers";
            String packageName = processingEnv.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
            String fullyQualifiedNameMatcher = typeElement.getQualifiedName().toString() + "Matchers";
            ProvideMatchers pm = typeElement.getAnnotation(ProvideMatchers.class);
            if (!"".equals(pm.matchersClassName())) {
                fullyQualifiedNameMatcher = fullyQualifiedNameMatcher.replaceAll(simpleName + "$", pm.matchersClassName());
                simpleName = pm.matchersClassName();
            }
            if (!"".equals(pm.matchersPackageName())) {
                fullyQualifiedNameMatcher = fullyQualifiedNameMatcher.replaceAll("^" + packageName, pm.matchersPackageName());
                packageName = pm.matchersPackageName();
            }
            return fullyQualifiedNameMatcher;
        }
        return null;
    }

    public FieldDescription(ProvidesMatchersAnnotatedElementMirror containingElementMirror, String fieldAccessor, String fieldName, String fieldType, boolean isInSameRound, ProcessingEnvironment processingEnv, Element fieldElement, TypeMirror fieldTypeMirror) {
        this.containingElementMirror = containingElementMirror;
        this.fieldAccessor = fieldAccessor;
        this.fieldName = fieldName;
        this.methodFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        this.fieldType = fieldType;
        this.type = (Type)((Object)new ExtracTypeVisitor().visit(fieldTypeMirror, processingEnv));
        this.processingEnv = processingEnv;
        this.ignore = fieldElement.getAnnotation(IgnoreInMatcher.class) != null;
        this.fieldElement = fieldElement;
        this.defaultReturnMethod = containingElementMirror.getDefaultReturnMethod();
        this.generic = FieldDescription.computeGenericInformation(fieldTypeMirror);
        this.fullyQualifiedNameMatcherInSameRound = FieldDescription.computeFullyQualifiedNameMatcherInSameRound(processingEnv, isInSameRound, fieldType);
        ArrayList<Function<String, String>> tmp1 = new ArrayList<Function<String, String>>();
        ArrayList<Function<String, String>> tmp2 = new ArrayList<Function<String, String>>();
        tmp1.add(this::getImplementationForDefault);
        tmp2.add(this::getDslForDefault);
        if (this.fullyQualifiedNameMatcherInSameRound != null && processingEnv.getElementUtils().getTypeElement(fieldType).getTypeParameters().isEmpty()) {
            tmp1.add(this::getImplementationForDefaultChaining);
            tmp2.add(this::getDslForDefaultChaining);
        }
        switch (this.type) {
            case ARRAY: {
                tmp2.add(this::getDslForArray);
                break;
            }
            case OPTIONAL: {
                tmp1.add(this::getImplementationForOptional);
                tmp2.add(this::getDslForOptional);
                break;
            }
            case COMPARABLE: {
                tmp2.add(this::getDslForComparable);
                break;
            }
            case STRING: {
                tmp2.add(this::getDslForComparable);
                tmp2.add(this::getDslForString);
                break;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                tmp2.add(this::getDslForIterable);
                tmp2.add(this::getDslForCollection);
                break;
            }
            case SUPPLIER: {
                tmp2.add(this::getDslForSupplier);
                break;
            }
        }
        AddToMatcher[] addToMatchers = (AddToMatcher[])fieldElement.getAnnotationsByType(AddToMatcher.class);
        tmp1.addAll(Arrays.stream(addToMatchers).map(this::generateFunctionForImplementation).filter(t -> t != null).collect(Collectors.toList()));
        tmp2.addAll(Arrays.stream(addToMatchers).map(this::generateFunctionForDSL).filter(t -> t != null).collect(Collectors.toList()));
        this.implGenerator = Collections.unmodifiableList(tmp1);
        this.dslGenerator = Collections.unmodifiableList(tmp2);
    }

    public Function<String, String> generateFunctionForDSL(AddToMatcher a) {
        return prefix -> this.buildDsl((String)prefix, this.getJavaDocFor(Optional.empty(), Optional.empty(), Optional.empty()), this.generateDeclaration(a.suffix(), a.argument()));
    }

    public Function<String, String> generateFunctionForImplementation(AddToMatcher a) {
        return prefix -> this.buildImplementation((String)prefix, this.generateDeclaration(a.suffix(), a.argument()), Arrays.stream(a.body()).map(l -> prefix + l).collect(Collectors.joining("\n")) + "\n" + prefix + "return this;");
    }

    public String getJavaDocFor(Optional<String> addToDescription, Optional<String> param, Optional<String> see) {
        String linkToAccessor = "{@link " + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + "#" + this.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append("/**").append("\n");
        sb.append(" * Add a validation on the field `").append(this.fieldName).append("`");
        addToDescription.ifPresent(t -> sb.append(" ").append((String)t));
        sb.append(".").append("\n");
        sb.append(" * <p>").append("\n");
        sb.append(" *").append("\n");
        sb.append(" * <i>").append(linkToAccessor).append("</i>").append("\n");
        sb.append(" * <p>").append("\n");
        sb.append(" * <b>In case method specifing a matcher on a fields are used several times, only the last setted matcher will be used.</b> ").append("\n");
        sb.append(" * When several control must be done on a single field, hamcrest itself provides a way to combine several matchers (See for instance {@link org.hamcrest.Matchers#both(org.hamcrest.Matcher)}.").append("\n");
        sb.append(" *").append("\n");
        param.ifPresent(t -> Arrays.stream(t.split("\n")).forEach(l -> sb.append(" * @param ").append((String)l).append(".").append("\n")));
        sb.append(" * @return the DSL to continue the construction of the matcher.").append("\n");
        see.ifPresent(t -> sb.append(" * @see ").append((String)t).append("\n"));
        sb.append(" */");
        return sb.toString();
    }

    public String buildImplementation(String prefix, String declaration, String body) {
        return prefix + "@Override" + "\n" + prefix + "public " + declaration + " {\n" + prefix + "  " + body.replaceAll("\\R", "\n" + prefix + "  ") + "\n" + prefix + "}" + "\n";
    }

    public String buildDsl(String prefix, String javadoc, String declaration) {
        return prefix + javadoc.replaceAll("\\R", "\n" + prefix) + "\n" + prefix + declaration + ";\n";
    }

    public String buildDefaultDsl(String prefix, String javadoc, String declaration, String innerMatcher) {
        return prefix + javadoc.replaceAll("\\R", "\n" + prefix) + "\n" + prefix + "default " + declaration + "{\n" + prefix + prefix + "return " + this.fieldName + "(" + innerMatcher + ");\n" + prefix + "}";
    }

    public String generateDeclaration(String postFix, String arguments) {
        return this.defaultReturnMethod + " " + this.fieldName + postFix + "(" + arguments + ")";
    }

    public String getImplementationForDefault(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("", "org.hamcrest.Matcher<? super " + this.fieldType + "> matcher"), this.fieldName + "= new " + this.methodFieldName + "Matcher(matcher);\nreturn this;"));
        return sb.toString();
    }

    public String getImplementationForDefaultChaining(String prefix) {
        TypeElement targetElement = this.processingEnv.getElementUtils().getTypeElement(this.fieldType);
        String name = targetElement.getSimpleName().toString();
        String lname = name.substring(0, 1).toLowerCase() + name.substring(1);
        return this.buildImplementation(prefix, this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher" + "<" + this.defaultReturnMethod + "> " + this.fieldName + "With()", this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher tmp = " + this.fullyQualifiedNameMatcherInSameRound + "." + lname + "WithParent(this);\n" + this.fieldName + "(tmp);\nreturn tmp;");
    }

    public String getImplementationForOptional(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("IsPresent", ""), this.fieldName + " = " + this.methodFieldName + "Matcher.isPresent();\nreturn this;"));
        sb.append(this.buildImplementation(prefix, this.generateDeclaration("IsNotPresent", ""), this.fieldName + " = " + this.methodFieldName + "Matcher.isNotPresent();\nreturn this;"));
        return sb.toString();
    }

    public String getImplementationInterface(String prefix) {
        return this.implGenerator.stream().map(g -> (String)g.apply(prefix)).collect(Collectors.joining("\n"));
    }

    public String getDslForSupplier(String prefix) {
        return this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of(" Validate that the result of the supplier is accepted by another matcher (the result of the execution must be stable)"), Optional.of("matcherOnResult a Matcher on result of the supplier execution"), Optional.empty()), this.generateDeclaration("SupplierResult", "org.hamcrest.Matcher<? super " + this.generic + "> matcherOnResult"), "new " + this.methodFieldName + "MatcherSupplier(matcherOnResult)");
    }

    public String getDslForDefault(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.empty(), Optional.of("matcher a Matcher on the field"), Optional.of(SEE_TEXT_FOR_HAMCREST_MATCHER)), this.generateDeclaration("", "org.hamcrest.Matcher<? super " + this.fieldType + "> matcher")));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.empty(), Optional.of("value an expected value for the field, which will be compared using the is matcher"), Optional.of(SEE_TEXT_FOR_IS_MATCHER)), this.generateDeclaration("", this.fieldType + " value"), "org.hamcrest.Matchers.is(value)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("by converting the received field before validat it"), Optional.of("converter a function to convert the field\nmatcher a matcher on the resulting\n<_TARGETFIELD> The type which this field must be converter"), Optional.empty()), "<_TARGETFIELD> " + this.generateDeclaration("As", "java.util.function.Function<" + this.fieldType + ",_TARGETFIELD> converter,org.hamcrest.Matcher<? super _TARGETFIELD> matcher"), "asFeatureMatcher(\" <field is converted> \",converter,matcher)"));
        return sb.toString();
    }

    public String getDslForDefaultChaining(String prefix) {
        TypeElement targetElement = this.processingEnv.getElementUtils().getTypeElement(this.fieldType);
        String name = targetElement.getSimpleName().toString();
        return this.buildDsl(prefix, this.getJavaDocFor(Optional.of("by starting a matcher for this field"), Optional.empty(), Optional.empty()), this.fullyQualifiedNameMatcherInSameRound + "." + name + "Matcher" + "<" + this.defaultReturnMethod + "> " + this.fieldName + "With()");
    }

    public String getDslForString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the string contains another one"), Optional.of("other the string is contains in the other one"), Optional.of("org.hamcrest.Matchers#containsString(java.lang.String)")), this.generateDeclaration("ContainsString", "String other"), "org.hamcrest.Matchers.containsString(other)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the string starts with another one"), Optional.of("other the string to use to compare"), Optional.of("org.hamcrest.Matchers#startsWith(java.lang.String)")), this.generateDeclaration("StartsWith", "String other"), "org.hamcrest.Matchers.startsWith(other)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the string ends with another one"), Optional.of("other the string to use to compare"), Optional.of("org.hamcrest.Matchers#endsWith(java.lang.String)")), this.generateDeclaration("EndsWith", "String other"), "org.hamcrest.Matchers.endsWith(other)"));
        return sb.toString();
    }

    public String getDslForIterable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmptyIterable", ""), "(org.hamcrest.Matcher)org.hamcrest.Matchers.emptyIterable()"));
        if (!"".equals(this.generic)) {
            sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements"), Optional.of("elements the elements"), Optional.of("org.hamcrest.Matchers#contains(java.lang.Object[])")), this.generateDeclaration("Contains", this.generic + "... elements"), "org.hamcrest.Matchers.contains(elements)"));
            sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using matchers"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#contains(org.hamcrest.Matcher[])")), this.generateDeclaration("Contains", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements"), "org.hamcrest.Matchers.contains(matchersOnElements)"));
            sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements in any order"), Optional.of("elements the elements"), Optional.of("org.hamcrest.Matchers#containsInAnyOrder(java.lang.Object[])")), this.generateDeclaration("ContainsInAnyOrder", this.generic + "... elements"), "org.hamcrest.Matchers.containsInAnyOrder(elements)"));
            sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using matchers in any order"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#containsInAnyOrder(org.hamcrest.Matcher[])")), this.generateDeclaration("ContainsInAnyOrder", "org.hamcrest.Matcher<" + this.generic + ">... matchersOnElements"), "org.hamcrest.Matchers.containsInAnyOrder(matchersOnElements)"));
            sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the iterable contains the received elements, using list of matcher"), Optional.of("matchersOnElements the matchers on the elements"), Optional.of("org.hamcrest.Matchers#contains(java.util.List)")), this.generateDeclaration("Contains", "java.util.List<org.hamcrest.Matcher<? super " + this.generic + ">> matchersOnElements"), "org.hamcrest.Matchers.contains(matchersOnElements)"));
        }
        return sb.toString();
    }

    public String getDslForArray(String prefix) {
        return this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the array is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmpty", ""), "(org.hamcrest.Matcher)org.hamcrest.Matchers.emptyArray()");
    }

    public String getDslForCollection(String prefix) {
        return this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that the collection is empty"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsEmpty", ""), "(org.hamcrest.Matcher)org.hamcrest.Matchers.empty()");
    }

    public String getDslForOptional(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("with a present optional"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsPresent", "")));
        sb.append(this.buildDsl(prefix, this.getJavaDocFor(Optional.of("with a not present optional"), Optional.empty(), Optional.empty()), this.generateDeclaration("IsNotPresent", "")));
        return sb.toString();
    }

    public String getDslForComparable(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that this field is equals to another one, using the compareTo method"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#comparesEqualTo(java.lang.Comparable)")), this.generateDeclaration("ComparesEqualTo", this.fieldType + " value"), "org.hamcrest.Matchers.comparesEqualTo(value)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that this field is less than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#lessThan(java.lang.Comparable)")), this.generateDeclaration("LessThan", this.fieldType + " value"), "org.hamcrest.Matchers.lessThan(value)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that this field is less or equal than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#lessThanOrEqualTo(java.lang.Comparable)")), this.generateDeclaration("LessThanOrEqualTo", this.fieldType + " value"), "org.hamcrest.Matchers.lessThanOrEqualTo(value)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that this field is greater than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#greaterThan(java.lang.Comparable)")), this.generateDeclaration("GreaterThan", this.fieldType + " value"), "org.hamcrest.Matchers.greaterThan(value)"));
        sb.append(this.buildDefaultDsl(prefix, this.getJavaDocFor(Optional.of("that this field is greater or equal than another value"), Optional.of("value the value to compare with"), Optional.of("org.hamcrest.Matchers#greaterThanOrEqualTo(java.lang.Comparable)")), this.generateDeclaration("GreaterThanOrEqualTo", this.fieldType + " value"), "org.hamcrest.Matchers.greaterThanOrEqualTo(value)"));
        return sb.toString();
    }

    public String getDslInterface(String prefix) {
        return this.dslGenerator.stream().map(g -> (String)g.apply(prefix)).collect(Collectors.joining("\n"));
    }

    public String getMatcherForField(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("private static class " + this.methodFieldName + "Matcher" + this.containingElementMirror.getFullGeneric() + " extends org.hamcrest.FeatureMatcher<" + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + this.containingElementMirror.getGeneric() + "," + this.fieldType + "> {").append("\n");
        sb.append(prefix).append("  public " + this.methodFieldName + "Matcher(org.hamcrest.Matcher<? super " + this.fieldType + "> matcher) {").append("\n");
        sb.append(prefix).append("    super(matcher,\"" + this.fieldName + "\",\"" + this.fieldName + "\");").append("\n");
        sb.append(prefix).append("  }").append("\n");
        switch (this.type) {
            case OPTIONAL: {
                sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isPresent() {").append("\n");
                sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is present\"){").append("\n");
                sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return o.isPresent();}").append("\n");
                sb.append(prefix).append("    });").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("  public static " + this.methodFieldName + "Matcher isNotPresent() {").append("\n");
                sb.append(prefix).append("    return new " + this.methodFieldName + "Matcher(new org.hamcrest.CustomTypeSafeMatcher<" + this.fieldType + ">(\"optional is not present\"){").append("\n");
                sb.append(prefix).append("      public boolean matchesSafely(" + this.fieldType + " o) {return !o.isPresent();}").append("\n");
                sb.append(prefix).append("    });").append("\n");
                sb.append(prefix).append("  }").append("\n");
                break;
            }
        }
        sb.append(prefix).append("  protected " + this.fieldType + " featureValueOf(" + this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher() + this.containingElementMirror.getGeneric() + " actual) {").append("\n");
        sb.append(prefix).append("    return actual." + this.fieldAccessor + ";").append("\n");
        sb.append(prefix).append("  }").append("\n");
        sb.append(prefix).append("}").append("\n");
        switch (this.type) {
            case SUPPLIER: {
                sb.append(prefix).append("private static class " + this.methodFieldName + "MatcherSupplier" + this.containingElementMirror.getFullGeneric() + " extends org.hamcrest.FeatureMatcher<java.util.function.Supplier<" + this.generic + ">," + this.generic + "> {").append("\n");
                sb.append(prefix).append("  public " + this.methodFieldName + "MatcherSupplier(org.hamcrest.Matcher<? super " + this.generic + "> matcher) {").append("\n");
                sb.append(prefix).append("    super(matcher,\"with supplier result\",\"with supplier result\");").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("  protected " + this.generic + " featureValueOf(java.util.function.Supplier<" + this.generic + "> actual) {").append("\n");
                sb.append(prefix).append("    return actual.get();").append("\n");
                sb.append(prefix).append("  }").append("\n");
                sb.append(prefix).append("}").append("\n");
                break;
            }
        }
        return sb.toString();
    }

    public String getFieldCopyDefault(String lhs, String rhs) {
        return lhs + "." + this.fieldName + "(org.hamcrest.Matchers.is(" + rhs + "." + this.fieldAccessor + "))";
    }

    public String getSameValueMatcherFor(String target, TypeElement targetElement) {
        String name = targetElement.getSimpleName().toString();
        String lname = name.substring(0, 1).toLowerCase() + name.substring(1);
        return this.fullyQualifiedNameMatcherInSameRound + "." + lname + "WithSameValue(" + target + ")";
    }

    public String getFieldCopySameRound(String lhs, String rhs, TypeElement targetElement) {
        return lhs + "." + this.fieldName + "(" + rhs + "." + this.fieldAccessor + "==null?org.hamcrest.Matchers.nullValue():" + this.getSameValueMatcherFor(rhs + "." + this.fieldAccessor, targetElement) + ")";
    }

    public String generateMatcherBuilderReferenceFor(String generic) {
        ProvidesMatchersAnnotatedElementMirror target = this.containingElementMirror.findMirrorFor(generic);
        if (target != null) {
            return target.getFullyQualifiedNameOfGeneratedClass() + "::" + target.getMethodShortClassName() + "WithSameValue";
        }
        return "org.hamcrest.Matchers::is";
    }

    public String getFieldCopyForList(String lhs, String rhs) {
        return "if(" + rhs + "." + this.fieldAccessor + "==null) {" + lhs + "." + this.fieldName + "(org.hamcrest.Matchers.nullValue()); } else if (" + rhs + "." + this.fieldAccessor + ".isEmpty()) {" + lhs + "." + this.fieldName + "IsEmptyIterable(); } else {" + lhs + "." + this.fieldName + "Contains(" + rhs + "." + this.fieldAccessor + ".stream().map(" + this.generateMatcherBuilderReferenceFor(this.generic) + ").collect(java.util.stream.Collectors.toList())); }";
    }

    public String getFieldCopy(String lhs, String rhs) {
        if (!(this.type != Type.LIST && this.type != Type.SET && this.type != Type.COLLECTION || "".equals(this.generic))) {
            return this.getFieldCopyForList(lhs, rhs);
        }
        if (this.fullyQualifiedNameMatcherInSameRound != null && this.processingEnv.getElementUtils().getTypeElement(this.fieldType).getTypeParameters().isEmpty()) {
            return this.getFieldCopySameRound(lhs, rhs, this.processingEnv.getElementUtils().getTypeElement(this.fieldType));
        }
        return this.getFieldCopyDefault(lhs, rhs);
    }

    public String asMatchesSafely(String prefix) {
        return prefix + "if(!" + this.fieldName + ".matches(actual)) {\n" + prefix + "  mismatchDescription.appendText(\"[\"); " + this.fieldName + ".describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");\n" + prefix + "  result=false;\n" + prefix + "}";
    }

    public String asDescribeTo(String prefix) {
        return prefix + ("description.appendText(\"[\").appendDescriptionOf(" + this.fieldName + ").appendText(\"]\\n\");");
    }

    public String asMatcherField() {
        return "private " + this.methodFieldName + "Matcher " + this.fieldName + " = new " + this.methodFieldName + "Matcher(org.hamcrest.Matchers.anything(" + (this.ignore ? "\"This field is ignored \"+" + CommonUtils.toJavaSyntax(this.getDescriptionForIgnoreIfApplicable()) : "") + "));";
    }

    public String getFieldAccessor() {
        return this.fieldAccessor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isNotIgnore() {
        return !this.ignore;
    }

    public String getDescriptionForIgnoreIfApplicable() {
        return Optional.ofNullable(this.fieldElement.getAnnotation(IgnoreInMatcher.class)).map(i -> i.comments()).orElse("");
    }

    public GeneratedMatcherField asGeneratedMatcherField() {
        GeneratedMatcherField gmf = new GeneratedMatcherField();
        gmf.setFieldIsIgnored(this.ignore);
        gmf.setFieldName(this.fieldName);
        gmf.setFieldCategory(this.type.name());
        gmf.setFieldAccessor(this.fieldAccessor);
        gmf.setGenericDetails(this.generic);
        return gmf;
    }

    private static final class ExtracTypeVisitor
    extends TypeKindVisitor8<Type, ProcessingEnvironment> {
        private ExtracTypeVisitor() {
        }

        @Override
        public Type visitPrimitiveAsBoolean(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsByte(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsShort(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsInt(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsLong(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsChar(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsFloat(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitPrimitiveAsDouble(PrimitiveType t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitArray(ArrayType t, ProcessingEnvironment processingEnv) {
            return Type.ARRAY;
        }

        @Override
        public Type visitDeclared(DeclaredType t, ProcessingEnvironment processingEnv) {
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Optional").asType()))) {
                return Type.OPTIONAL;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Set").asType()))) {
                return Type.SET;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.List").asType()))) {
                return Type.LIST;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Collection").asType()))) {
                return Type.COLLECTION;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.lang.String").asType()))) {
                return Type.STRING;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.lang.Comparable").asType()))) {
                return Type.COMPARABLE;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.function.Supplier").asType()))) {
                return Type.SUPPLIER;
            }
            return Type.NA;
        }

        @Override
        public Type visitTypeVariable(TypeVariable t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitUnknown(TypeMirror t, ProcessingEnvironment processingEnv) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element");
            return Type.NA;
        }
    }

    public static enum Type {
        NA,
        ARRAY,
        COLLECTION,
        LIST,
        SET,
        OPTIONAL,
        COMPARABLE,
        STRING,
        SUPPLIER;

    }
}

