/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.AddToMatcher;
import ch.powerunit.extensions.matchers.AddToMatchers;
import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.common.CommonConstants;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatchers;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

@SupportedAnnotationTypes(value={"ch.powerunit.extensions.matchers.ProvideMatchers", "ch.powerunit.extensions.matchers.IgnoreInMatcher", "ch.powerunit.extensions.matchers.AddToMatcher", "ch.powerunit.extensions.matchers.AddToMatchers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor.factory"})
public class ProvidesMatchersAnnotationsProcessor
extends AbstractProcessor {
    private String factory = null;
    private List<String> factories = new ArrayList<String>();
    private GeneratedMatchers allGeneratedMatchers = new GeneratedMatchers();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.factory = processingEnv.getOptions().get(ProvidesMatchersAnnotationsProcessor.class.getName() + ".factory");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement provideMatchersTE = this.processingEnv.getElementUtils().getTypeElement("ch.powerunit.extensions.matchers.ProvideMatchers");
        if (!roundEnv.processingOver()) {
            this.processAnnotatedElements(roundEnv, provideMatchersTE);
        } else {
            this.processReport();
            if (this.factory != null) {
                this.processFactory();
            }
        }
        return true;
    }

    private void processReport() {
        try {
            FileObject jfo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "META-INF/" + this.getClass().getName() + "/matchers.xml", this.allGeneratedMatchers.getGeneratedMatcher().stream().map(g -> g.getMirror().getTypeElementForClassAnnotatedWithProvideMatcher()).collect(Collectors.toList()).toArray(new Element[0]));
            try (OutputStream os = jfo.openOutputStream();){
                Marshaller m = JAXBContext.newInstance((Class[])new Class[]{GeneratedMatchers.class}).createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)this.allGeneratedMatchers, os);
            }
        }
        catch (IOException | JAXBException e1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unable to create the file containing meta data about this generation, because of " + e1.getMessage());
        }
    }

    private void processFactory() {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "The interface `" + this.factory + "` will be generated as a factory interface.");
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(this.factory, this.allGeneratedMatchers.getGeneratedMatcher().stream().map(g -> g.getMirror().getTypeElementForClassAnnotatedWithProvideMatcher()).collect(Collectors.toList()).toArray(new Element[0]));
            try (PrintWriter wjfo = new PrintWriter(jfo.openWriter());){
                wjfo.println("package " + this.factory.replaceAll("\\.[^.]+$", "") + ";");
                wjfo.println();
                wjfo.println(CommonConstants.DEFAULT_JAVADOC_FOR_FACTORY);
                wjfo.println("@javax.annotation.Generated(value=\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\")");
                String cName = this.factory.replaceAll("^([^.]+\\.)*", "");
                wjfo.println("public interface " + cName + " {");
                wjfo.println();
                wjfo.println("  /**");
                wjfo.println("   * Use this static field to access all the DSL syntax, without be required to implements this interface.");
                wjfo.println("   */");
                wjfo.println("  public static final " + cName + " DSL = new " + cName + "() {};");
                wjfo.println();
                this.factories.stream().forEach(wjfo::println);
                wjfo.println("}");
            }
        }
        catch (IOException e1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + this.factory + "`, because of " + e1.getMessage());
        }
    }

    private void processAnnotatedElements(RoundEnvironment roundEnv, TypeElement provideMatchersTE) {
        Set<? extends Element> elementsWithPM = roundEnv.getElementsAnnotatedWith(ProvideMatchers.class);
        Set<Element> elementsWithIgnore = roundEnv.getElementsAnnotatedWith(IgnoreInMatcher.class);
        Set<Element> elementsWithAddToMatcher = roundEnv.getElementsAnnotatedWith(AddToMatcher.class);
        Set<Element> elementsWithAddToMatchers = roundEnv.getElementsAnnotatedWith(AddToMatchers.class);
        ProvidesMatchersElementVisitor providesMatchersElementVisitor = new ProvidesMatchersElementVisitor(this, this.processingEnv, provideMatchersTE);
        HashMap alias = new HashMap();
        elementsWithPM.stream().filter(e -> roundEnv.getRootElements().contains(e)).map(e -> e.accept(providesMatchersElementVisitor, null)).filter(Optional::isPresent).map(t -> new ProvidesMatchersAnnotatedElementMirror((TypeElement)t.get(), this.processingEnv, this.isInSameRound(elementsWithPM, this.processingEnv.getTypeUtils()), n -> (ProvidesMatchersAnnotatedElementMirror)alias.get(n), elementsWithIgnore, elementsWithAddToMatcher, elementsWithAddToMatchers)).forEach(a -> alias.put(a.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher(), a));
        this.factories.addAll(alias.values().stream().map(ProvidesMatchersAnnotatedElementMirror::process).collect(Collectors.toList()));
        this.allGeneratedMatchers.getGeneratedMatcher().addAll(alias.values().stream().map(ProvidesMatchersAnnotatedElementMirror::asXml).collect(Collectors.toList()));
        this.doWarningForElement(elementsWithIgnore, IgnoreInMatcher.class);
        this.doWarningForElement(elementsWithAddToMatcher, AddToMatcher.class);
        this.doWarningForElement(elementsWithAddToMatchers, AddToMatchers.class);
    }

    private void doWarningForElement(Set<Element> elements, Class aa) {
        elements.stream().forEach(e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Annotation @" + aa.getName() + " not supported at this location ; The surrounding class is not annotated with @ProvideMatchers", (Element)e, e.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().equals(this.processingEnv.getElementUtils().getTypeElement(aa.getName().toString()).asType())).findAny().orElse(null)));
    }

    private Predicate<Element> isInSameRound(Set<? extends Element> elements, Types typesUtils) {
        return t -> t == null ? false : elements.stream().filter(e -> typesUtils.isSameType(e.asType(), t.asType())).findAny().isPresent();
    }

    public AnnotationMirror getProvideMatchersAnnotation(TypeElement provideMatchersTE, Collection<? extends AnnotationMirror> annotations) {
        return annotations.stream().filter(a -> a.getAnnotationType().equals(provideMatchersTE.asType())).findAny().orElse(null);
    }
}

