/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

class ProvidesMatchersElementVisitor
extends SimpleElementVisitor8<Optional<TypeElement>, Void> {
    private final ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor;
    private final ProcessingEnvironment processingEnv;
    private final TypeElement provideMatchersTE;

    public ProvidesMatchersElementVisitor(ProvidesMatchersAnnotationsProcessor providesMatchersAnnotationsProcessor, ProcessingEnvironment processingEnv, TypeElement provideMatchersTE) {
        this.providesMatchersAnnotationsProcessor = providesMatchersAnnotationsProcessor;
        this.processingEnv = processingEnv;
        this.provideMatchersTE = provideMatchersTE;
    }

    @Override
    public Optional<TypeElement> visitType(TypeElement e, Void p) {
        switch (e.getKind()) {
            case ENUM: {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an enum, which is not supported", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.processingEnv.getElementUtils().getAllAnnotationMirrors(e)));
                return Optional.empty();
            }
            case INTERFACE: {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an interface, which is not supported", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.processingEnv.getElementUtils().getAllAnnotationMirrors(e)));
                return Optional.empty();
            }
        }
        return Optional.of(e);
    }

    @Override
    protected Optional<TypeElement> defaultAction(Element e, Void p) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an unsupported element", e, this.providesMatchersAnnotationsProcessor.getProvideMatchersAnnotation(this.provideMatchersTE, this.processingEnv.getElementUtils().getAllAnnotationMirrors(e)));
        return Optional.empty();
    }
}

