/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class FieldDescriptionMirror {
    private final String fieldName;
    private final String fieldType;
    private final TypeElement fieldTypeAsTypeElement;
    private final Element fieldElement;

    public FieldDescriptionMirror(ProvidesMatchersAnnotatedElementData containingElementMirror, String fieldName, String fieldType, Element fieldElement) {
        ProcessingEnvironment processingEnv = containingElementMirror.getRoundMirror().getProcessingEnv();
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldTypeAsTypeElement = processingEnv.getElementUtils().getTypeElement(fieldType);
        this.fieldElement = fieldElement;
    }

    public String getFieldAccessor() {
        return this.fieldElement.getSimpleName().toString() + (this.fieldElement instanceof ExecutableElement ? "()" : "");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMethodFieldName() {
        return this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public Element getFieldElement() {
        return this.fieldElement;
    }

    public TypeElement getFieldTypeAsTypeElement() {
        return this.fieldTypeAsTypeElement;
    }

    public String computeFullyQualifiedNameMatcherInSameRound(RoundMirror roundMirror) {
        ProcessingEnvironment processingEnv = roundMirror.getProcessingEnv();
        if (roundMirror.isInSameRound(processingEnv.getTypeUtils().asElement(this.fieldElement.asType())) && this.fieldTypeAsTypeElement != null) {
            return new ProvideMatchersMirror(processingEnv, this.fieldTypeAsTypeElement).getFullyQualifiedNameOfGeneratedClass();
        }
        return null;
    }
}

