/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import java.util.Arrays;
import java.util.stream.Collectors;

public class CommonUtils {
    private CommonUtils() {
    }

    public static String toJavaSyntax(String unformatted) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (char c : unformatted.toCharArray()) {
            sb.append(CommonUtils.toJavaSyntax(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return "" + ch;
    }

    public static String addPrefix(String prefix, String input) {
        return "\n" + Arrays.stream(input.split("\\R")).map(l -> prefix + l).collect(Collectors.joining("\n")) + "\n";
    }
}

