/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.common.FactoryHelper;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;

class FactoryGroup {
    private final String[] acceptingRegex;
    private final String fullyQualifiedTargetName;
    private final List<FactoryAnnotatedElementMirror> method = new ArrayList<FactoryAnnotatedElementMirror>();
    private final FactoryAnnotationsProcessor parent;

    public FactoryGroup(FactoryAnnotationsProcessor parent, String definition) {
        this.parent = parent;
        String[] split = definition.split("\\s*:\\s*");
        this.acceptingRegex = split[0].split("\\s*,\\s*");
        this.fullyQualifiedTargetName = split[1];
    }

    public String[] getAcceptingRegex() {
        return this.acceptingRegex;
    }

    public String getFullyQualifiedTargetName() {
        return this.fullyQualifiedTargetName;
    }

    public void addMethod(FactoryAnnotatedElementMirror faem) {
        this.method.add(faem);
    }

    public boolean isAccepted(FactoryAnnotatedElementMirror faem) {
        return Arrays.stream(this.acceptingRegex).anyMatch(a -> faem.getSurroundingFullyQualifiedName().matches((String)a));
    }

    public void processGenerateOneFactoryInterface() {
        FileObjectHelper.processFileWithIOException(() -> this.parent.getFiler().createSourceFile(this.fullyQualifiedTargetName, (Element[])this.method.stream().map(e -> e.getElement()).toArray(ExecutableElement[]::new)), jfo -> new PrintWriter(jfo.openWriter()), wjfo -> {
            String pName = this.fullyQualifiedTargetName.replaceAll("\\.[^.]+$", "");
            String cName = this.fullyQualifiedTargetName.substring(this.fullyQualifiedTargetName.lastIndexOf(46) + 1);
            FactoryHelper.generateFactoryClass(wjfo, FactoryAnnotationsProcessor.class, pName, cName, () -> this.method.stream().map(FactoryAnnotatedElementMirror::generateFactory));
        }, e -> this.parent.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + this.fullyQualifiedTargetName + "`, because of " + e.getMessage()));
    }
}

