/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.provideprocessor.DSLMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractDSLExtensionSupplier {
    protected final String targetName;
    protected final String returnType;
    protected final String methodName;
    protected final String targetMethodName;

    public AbstractDSLExtensionSupplier(String targetName, String returnType, String methodName, String targetMethodName) {
        this.targetName = targetName;
        this.returnType = returnType;
        this.methodName = methodName;
        this.targetMethodName = targetMethodName;
    }

    public abstract Collection<Supplier<DSLMethod>> asSuppliers();

    public String[][] getSeveralParameter(boolean lastIsVarargs, String ... name) {
        List tmp = Arrays.stream(name).map(this::getOneParameter).collect(Collectors.toList());
        if (lastIsVarargs) {
            String[] stringArray = (String[])tmp.get(name.length - 1);
            stringArray[0] = stringArray[0] + "...";
        }
        return (String[][])tmp.toArray((T[])new String[0][0]);
    }

    public String[] getOneParameter(String name) {
        return new String[]{this.targetName, name};
    }

    public String getSeveralWith(String ... name) {
        return Arrays.stream(name).map(this::getOneWith).collect(Collectors.joining(","));
    }

    public String getOneWith(String name) {
        return this.targetMethodName + "(" + name + ")";
    }

    public DSLMethod generateSimpleDSLMethodFor(String[] javadoc, String containerMatcher, String ... parameters) {
        return new DSLMethod(javadoc, this.returnType + " " + this.methodName, this.getSeveralParameter(false, parameters), "return " + containerMatcher + "(" + this.getSeveralWith(parameters) + ");");
    }
}

