/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DSLMethod {
    public static final Pattern DECLARATION_PARSER = Pattern.compile("^\\s*.*\\s+([0-9A-Za-z_]+)\\s*$");
    private final String javadoc;
    private final String fullDeclaration;
    private final String implementation;
    private final String fullMethodName;

    private static String cleanJavadoc(String[] javadoc) {
        return "/**\n" + Arrays.stream(javadoc).map(s -> " * " + s).collect(Collectors.joining("\n")) + "\n */\n";
    }

    public DSLMethod(String[] javadoc, String declaration, String[] arguments, String implementation) {
        this(DSLMethod.cleanJavadoc(javadoc), declaration, (String[][])new String[][]{arguments}, new String[]{implementation});
    }

    public DSLMethod(String[] javadoc, String declaration, String[][] arguments, String implementation) {
        this(DSLMethod.cleanJavadoc(javadoc), declaration, arguments, new String[]{implementation});
    }

    public DSLMethod(String[] javadoc, String declaration, String[][] arguments, String[] implementation) {
        this(DSLMethod.cleanJavadoc(javadoc), declaration, arguments, implementation);
    }

    public DSLMethod(String javadoc, String declaration, String implementation) {
        this(javadoc, declaration, (String[][])new String[0][], new String[]{implementation});
    }

    public DSLMethod(String javadoc, String declaration, String[] implementation) {
        this(javadoc, declaration, (String[][])new String[0][], implementation);
    }

    public DSLMethod(String javadoc, String declaration, String[] arguments, String implementation) {
        this(javadoc, declaration, (String[][])new String[][]{arguments}, new String[]{implementation});
    }

    public DSLMethod(String javadoc, String declaration, String[] arguments, String[] implementation) {
        this(javadoc, declaration, (String[][])new String[][]{arguments}, implementation);
    }

    public DSLMethod(String javadoc, String declaration, String[][] arguments, String[] implementation) {
        String realArguments = Arrays.stream(arguments).map(a -> a[0] + " " + a[1]).collect(Collectors.joining(","));
        String realArgumentsName = Arrays.stream(arguments).map(a -> a[1]).collect(Collectors.joining(","));
        Matcher m = DECLARATION_PARSER.matcher(declaration);
        if (!m.matches()) {
            throw new IllegalArgumentException("Unable to parse the received declaration");
        }
        this.javadoc = javadoc;
        this.implementation = Arrays.stream(implementation).map(s -> "  " + s).collect(Collectors.joining("\n")) + "\n";
        this.fullDeclaration = declaration + "(" + realArguments + ")";
        this.fullMethodName = m.group(1) + "(" + realArgumentsName + ")";
    }

    public String asStaticImplementation() {
        return this.javadoc + "@org.hamcrest.Factory\npublic static " + this.fullDeclaration + " {\n" + this.implementation + "}\n";
    }

    public String asDefaultReference(String target) {
        return this.javadoc + "default " + this.fullDeclaration + " {\n  return " + target + "." + this.fullMethodName + ";\n}\n";
    }
}

