/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementJavadocMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public abstract class ProvidesMatchersAnnotatedElementGenericMirror
extends ProvidesMatchersAnnotatedElementJavadocMirror {
    protected final String generic;
    protected final String fullGeneric;
    protected final String simpleNameOfGeneratedInterfaceMatcher;
    protected final String genericForChaining;

    public ProvidesMatchersAnnotatedElementGenericMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
        this.generic = ProvidesMatchersAnnotatedElementGenericMirror.parseGeneric(typeElement);
        this.fullGeneric = ProvidesMatchersAnnotatedElementGenericMirror.parseFullGeneric(typeElement);
        this.simpleNameOfGeneratedInterfaceMatcher = this.simpleNameOfClassAnnotatedWithProvideMatcher + "Matcher";
        this.genericForChaining = this.getGenericParent().replaceAll("^<_PARENT", "<" + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.simpleNameOfGeneratedInterfaceMatcher + this.getGenericNoParent());
    }

    private static String parseFullGeneric(TypeElement typeElement) {
        return typeElement.getTypeParameters().stream().map(t -> t.toString() + " extends " + t.getBounds().stream().map(b -> b.toString()).collect(Collectors.joining("&"))).collect(Collectors.collectingAndThen(Collectors.joining(","), r -> r.isEmpty() ? "" : "<" + r + ">"));
    }

    private static String parseGeneric(TypeElement typeElement) {
        return typeElement.getTypeParameters().stream().map(t -> t.toString()).collect(Collectors.collectingAndThen(Collectors.joining(","), r -> r.isEmpty() ? "" : "<" + r + ">"));
    }

    public String getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() {
        return this.simpleNameOfGeneratedInterfaceMatcher + " " + this.getGenericParent();
    }

    public String getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() {
        return this.simpleNameOfGeneratedInterfaceMatcher + " " + this.getGenericNoParent();
    }

    public String getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() {
        return this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher + " " + this.generic;
    }

    public static String getAddParentToGeneric(String generic) {
        if ("".equals(generic)) {
            return "<_PARENT>";
        }
        return generic.replaceFirst("<", "<_PARENT,");
    }

    public static String getAddNoParentToGeneric(String generic) {
        if ("".equals(generic)) {
            return "<Void>";
        }
        return generic.replaceFirst("<", "<Void,");
    }

    public String getFullGeneric() {
        return this.fullGeneric;
    }

    public String getGeneric() {
        return this.generic;
    }

    public String getGenericParent() {
        return ProvidesMatchersAnnotatedElementGenericMirror.getAddParentToGeneric(this.generic);
    }

    public String getGenericNoParent() {
        return ProvidesMatchersAnnotatedElementGenericMirror.getAddNoParentToGeneric(this.generic);
    }

    public String getFullGenericParent() {
        return ProvidesMatchersAnnotatedElementGenericMirror.getAddParentToGeneric(this.fullGeneric);
    }
}

