/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.FactoryHelper;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatchers;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

@SupportedAnnotationTypes(value={"ch.powerunit.extensions.matchers.ProvideMatchers", "ch.powerunit.extensions.matchers.IgnoreInMatcher", "ch.powerunit.extensions.matchers.AddToMatcher", "ch.powerunit.extensions.matchers.AddToMatchers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor.factory"})
public class ProvidesMatchersAnnotationsProcessor
extends AbstractProcessor {
    private String factory = null;
    private List<String> factories = new ArrayList<String>();
    private GeneratedMatchers allGeneratedMatchers = new GeneratedMatchers();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.factory = processingEnv.getOptions().get(ProvidesMatchersAnnotationsProcessor.class.getName() + ".factory");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processRound(roundEnv);
        } else {
            this.processFinalRound();
        }
        return true;
    }

    private void processRound(RoundEnvironment roundEnv) {
        Collection<ProvidesMatchersAnnotatedElementMirror> alias = new RoundMirror(roundEnv, this.processingEnv).parse();
        this.factories.addAll(alias.stream().collect(Collectors.toMap(ProvideMatchersMirror::getFullyQualifiedNameOfGeneratedClass, ProvidesMatchersAnnotatedElementMirror::process)).entrySet().stream().map(e -> ((Collection)e.getValue()).stream().map(m -> CommonUtils.addPrefix("  ", m.asDefaultReference((String)e.getKey()))).collect(Collectors.joining("\n"))).collect(Collectors.toList()));
        this.allGeneratedMatchers.getGeneratedMatcher().addAll(alias.stream().map(ProvidesMatchersAnnotatedElementMirror::asXml).collect(Collectors.toList()));
    }

    private void processFinalRound() {
        this.processReport();
        if (this.factory != null) {
            this.processFactory();
        }
    }

    private void processReport() {
        FileObjectHelper.processFileWithIOException(() -> this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "META-INF/" + this.getClass().getName() + "/matchers.xml", this.allGeneratedMatchers.listElements()), FileObject::openOutputStream, os -> {
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{GeneratedMatchers.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)this.allGeneratedMatchers, os);
        }, e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unable to create the file containing meta data about this generation, because of " + e.getMessage()));
    }

    private void processFactory() {
        FileObjectHelper.processFileWithIOException(() -> this.processingEnv.getFiler().createSourceFile(this.factory, this.allGeneratedMatchers.listElements()), jfo -> new PrintWriter(jfo.openWriter()), wjfo -> FactoryHelper.generateFactoryClass(wjfo, ProvidesMatchersAnnotationsProcessor.class, this.factory.replaceAll("\\.[^.]+$", ""), this.factory.replaceAll("^([^.]+\\.)*", ""), () -> this.factories.stream()), e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class `" + this.factory + "`, because of " + e.getMessage()));
    }

    public AnnotationMirror getProvideMatchersAnnotation(TypeElement provideMatchersTE, Collection<? extends AnnotationMirror> annotations) {
        return annotations.stream().filter(a -> a.getAnnotationType().equals(provideMatchersTE.asType())).findAny().orElse(null);
    }
}

