/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirrorSupport;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

class ProvidesMatchersElementVisitor
extends SimpleElementVisitor8<Optional<TypeElement>, Void>
implements RoundMirrorSupport {
    private final RoundMirror roundMirror;

    public ProvidesMatchersElementVisitor(RoundMirror roundMirror) {
        this.roundMirror = roundMirror;
    }

    @Override
    public Optional<TypeElement> visitType(TypeElement e, Void p) {
        switch (e.getKind()) {
            case ENUM: {
                this.warningForType(e, "enum");
                return Optional.empty();
            }
            case INTERFACE: {
                this.warningForType(e, "interface");
                return Optional.empty();
            }
        }
        return Optional.of(e);
    }

    @Override
    protected Optional<TypeElement> defaultAction(Element e, Void p) {
        this.warningForType(e, "unexpected element");
        return Optional.empty();
    }

    private void warningForType(Element e, String type) {
        this.roundMirror.getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The annotation `ProvideMatchers` is used on an " + type + ", which is not supported", e, this.roundMirror.getProvideMatchersAnnotation(e));
    }

    @Override
    public RoundMirror getRoundMirror() {
        return this.roundMirror;
    }
}

