/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.provideprocessor.NameExtractorVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementFieldMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionProvider;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;

public class ProvidesMatchersSubElementVisitor
extends SimpleElementVisitor8<Optional<AbstractFieldDescription>, ProvidesMatchersAnnotatedElementFieldMatcherMirror> {
    private final Function<Element, Boolean> removeFromIgnoreList;
    private final NameExtractorVisitor extractNameVisitor;
    private final ProcessingEnvironment processingEnv;

    public ProvidesMatchersSubElementVisitor(RoundMirror roundMirror) {
        this.processingEnv = roundMirror.getProcessingEnv();
        this.removeFromIgnoreList = roundMirror::removeFromIgnoreList;
        this.extractNameVisitor = new NameExtractorVisitor(this.processingEnv);
    }

    public Optional<AbstractFieldDescription> removeIfNeededAndThenReturn(Optional<AbstractFieldDescription> fieldDescription) {
        fieldDescription.ifPresent(f -> this.removeFromIgnoreList.apply(f.getFieldElement()));
        return fieldDescription;
    }

    @Override
    public Optional<AbstractFieldDescription> visitVariable(VariableElement e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        if (e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC)) {
            String fieldName = e.getSimpleName().toString();
            return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, fieldName);
        }
        this.generateIfNeededWarningForNotSupportedElementAndRemoveIt("Check that this field is public and not static", e);
        return Optional.empty();
    }

    @Override
    public Optional<AbstractFieldDescription> visitExecutable(ExecutableElement e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        String simpleName;
        if (e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getParameters().size() == 0 && !e.getModifiers().contains((Object)Modifier.STATIC) && (simpleName = e.getSimpleName().toString()).matches("^((get)|(is)).*")) {
            return this.visiteExecutableGet(e, "^(get)|(is)", p);
        }
        this.generateIfNeededWarningForNotSupportedElementAndRemoveIt("Check that this method is public, doesn't have any parameter and is named isXXX or getXXX", e);
        return Optional.empty();
    }

    private void generateIfNeededWarningForNotSupportedElementAndRemoveIt(String description, Element e) {
        if (this.removeFromIgnoreList.apply(e).booleanValue()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "One of the annotation is not supported as this location ; " + description, e);
        }
    }

    private Optional<AbstractFieldDescription> visiteExecutableGet(ExecutableElement e, String prefix, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        String methodName = e.getSimpleName().toString();
        String fieldNameDirect = methodName.replaceFirst(prefix, "");
        String fieldName = fieldNameDirect.substring(0, 1).toLowerCase() + fieldNameDirect.substring(1);
        return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, fieldName);
    }

    public Optional<AbstractFieldDescription> createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(Element e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p, String fieldName) {
        return this.removeIfNeededAndThenReturn((e instanceof ExecutableElement ? ((ExecutableElement)e).getReturnType() : e.asType()).accept(this.extractNameVisitor, false).map(f -> FieldDescriptionProvider.of(() -> p, new FieldDescriptionMirror(() -> p, fieldName, (String)f, e))));
    }

    @Override
    protected Optional<AbstractFieldDescription> defaultAction(Element e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        return Optional.empty();
    }
}

