/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.AddToMatcher;
import ch.powerunit.extensions.matchers.AddToMatchers;
import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.common.AbstractRoundMirrorReferenceToProcessingEnv;
import ch.powerunit.extensions.matchers.provideprocessor.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.beanmatchers.DefaultBeanMatchersAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.hamcrestdate.LocalDateMatchersAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.hamcrestdate.LocalDateTimeMatchersAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.hamcrestdate.LocalTimeMatchersAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.hamcrestdate.ZonedDateTimeMatchersAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.hamcrestutility.CollectionHamcrestUtilityAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.extension.spotify.JsonStringSpotifyAutomatedExtension;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDSLMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class RoundMirror
extends AbstractRoundMirrorReferenceToProcessingEnv {
    private final Collection<AutomatedExtension> AUTOMATED_EXTENSIONS;
    private final Set<? extends Element> elementsWithPM;
    private final Map<Class<?>, Set<? extends Element>> elementsWithOtherAnnotations;
    private final Map<String, ProvidesMatchersAnnotatedElementMirror> alias = new HashMap<String, ProvidesMatchersAnnotatedElementMirror>();

    public RoundMirror(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        super(roundEnv, processingEnv);
        this.elementsWithOtherAnnotations = new HashMap();
        this.elementsWithPM = roundEnv.getElementsAnnotatedWith(ProvideMatchers.class);
        this.elementsWithOtherAnnotations.put(IgnoreInMatcher.class, new HashSet<Element>(roundEnv.getElementsAnnotatedWith(IgnoreInMatcher.class)));
        this.elementsWithOtherAnnotations.put(AddToMatcher.class, new HashSet<Element>(roundEnv.getElementsAnnotatedWith(AddToMatcher.class)));
        this.elementsWithOtherAnnotations.put(AddToMatchers.class, new HashSet<Element>(roundEnv.getElementsAnnotatedWith(AddToMatchers.class)));
        this.AUTOMATED_EXTENSIONS = this.getDefaultExtension().stream().filter(AutomatedExtension::isPresent).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private final List<AutomatedExtension> getDefaultExtension() {
        return Arrays.asList(new LocalDateMatchersAutomatedExtension(this), new LocalDateTimeMatchersAutomatedExtension(this), new LocalTimeMatchersAutomatedExtension(this), new ZonedDateTimeMatchersAutomatedExtension(this), new CollectionHamcrestUtilityAutomatedExtension(this), new JsonStringSpotifyAutomatedExtension(this), new DefaultBeanMatchersAutomatedExtension(this));
    }

    public Collection<ProvidesMatchersAnnotatedElementMirror> parse() {
        ProvidesMatchersElementVisitor providesMatchersElementVisitor = new ProvidesMatchersElementVisitor(this);
        this.elementsWithPM.stream().filter(e -> this.roundEnv.getRootElements().contains(e)).map(e -> e.accept(providesMatchersElementVisitor, null)).filter(Optional::isPresent).map(t -> new ProvidesMatchersAnnotatedElementMirror((TypeElement)t.get(), this)).forEach(a -> this.alias.put(a.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher(), (ProvidesMatchersAnnotatedElementMirror)a));
        this.doWarningforAllElements();
        return this.alias.values();
    }

    private void doWarningforAllElements() {
        this.elementsWithOtherAnnotations.entrySet().stream().forEach(e -> this.doWarningForElement((Set)e.getValue(), (Class)e.getKey()));
    }

    private void doWarningForElement(Set<? extends Element> elements, Class<?> aa) {
        elements.stream().forEach(e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Annotation @" + aa.getName() + " not supported at this location ; The surrounding class is not annotated with @ProvideMatchers", (Element)e, this.findAnnotationMirrorFor((Element)e, aa)));
    }

    private AnnotationMirror findAnnotationMirrorFor(Element e, Class<?> aa) {
        String aaName = aa.getName().toString();
        return e.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().equals(this.processingEnv.getElementUtils().getTypeElement(aaName).asType())).findAny().orElse(null);
    }

    public boolean removeFromIgnoreList(Element e) {
        return this.elementsWithOtherAnnotations.values().stream().map(t -> t.remove(e)).filter(t -> t).findAny().orElse(false);
    }

    public ProvidesMatchersAnnotatedElementMirror getByName(String name) {
        return this.alias.get(name);
    }

    public boolean isInSameRound(Element t) {
        if (t == null) {
            return false;
        }
        TypeMirror tm = t.asType();
        return this.elementsWithPM.stream().filter(e -> this.processingEnv.getTypeUtils().isSameType(e.asType(), tm)).findAny().isPresent();
    }

    public AnnotationMirror getProvideMatchersAnnotation(Element e) {
        TypeMirror pmtm = this.processingEnv.getElementUtils().getTypeElement("ch.powerunit.extensions.matchers.ProvideMatchers").asType();
        return this.getProcessingEnv().getElementUtils().getAllAnnotationMirrors(e).stream().filter(a -> a.getAnnotationType().equals(pmtm)).findAny().orElse(null);
    }

    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData target) {
        return this.AUTOMATED_EXTENSIONS.stream().map(ae -> ae.accept(target)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<FieldDSLMethod> getFieldDSLMethodFor(AbstractFieldDescription target) {
        return this.AUTOMATED_EXTENSIONS.stream().map(ae -> ae.accept(target)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

