/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.ComplementaryExpositionMethod;
import ch.powerunit.extensions.matchers.provideprocessor.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AbstractDSLExtensionSupplier;
import ch.powerunit.extensions.matchers.provideprocessor.extension.DSLExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class AnyOfExtension
implements DSLExtension {
    public static final String ANYOF_MATCHER = "org.hamcrest.Matchers.anyOf";
    private static final String JAVADOC_DESCRIPTION = "Generate a anyOf matcher for this Object, which provide a simple way to valid that something is one of the many supplied instance.";

    @Override
    public ComplementaryExpositionMethod supportedEnum() {
        return ComplementaryExpositionMethod.ANY_OF;
    }

    @Override
    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData element) {
        String targetName = element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric();
        String returnType = element.getFullGeneric() + " org.hamcrest.Matcher<" + targetName + ">";
        String methodName = element.generateDSLMethodName("anyOf");
        String targetMethodName = element.generateDSLWithSameValueMethodName();
        return new AnyOfSupplier(targetName, returnType, methodName, targetMethodName).asSuppliers();
    }

    public class AnyOfSupplier
    extends AbstractDSLExtensionSupplier {
        public AnyOfSupplier(String targetName, String returnType, String methodName, String targetMethodName) {
            super(targetName, returnType, methodName, targetMethodName);
        }

        @Override
        public Collection<Supplier<DSLMethod>> asSuppliers() {
            return Arrays.asList(this::generateAnyOf);
        }

        public DSLMethod generateAnyOf() {
            return new DSLMethod(new String[]{AnyOfExtension.JAVADOC_DESCRIPTION, "@param items the items to be matched", "@return the Matcher."}, this.returnType + " " + this.methodName, this.getSeveralParameter(true, "items"), "return org.hamcrest.Matchers.anyOf(java.util.Arrays.stream(items).map(v->" + this.targetMethodName + "(v)).collect(java.util.stream.Collectors.toList()).toArray(new org.hamcrest.Matcher[0]));");
        }
    }
}

