/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.ComplementaryExpositionMethod;
import ch.powerunit.extensions.matchers.provideprocessor.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AbstractDSLExtensionSupplier;
import ch.powerunit.extensions.matchers.provideprocessor.extension.DSLExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class HasItemsExtension
implements DSLExtension {
    public static final String CONTAINS_MATCHER = "org.hamcrest.Matchers.hasItems";
    private static final String JAVADOC_DESCRIPTION = "Generate a hasItems matcher for this Object.";

    @Override
    public ComplementaryExpositionMethod supportedEnum() {
        return ComplementaryExpositionMethod.HAS_ITEMS;
    }

    @Override
    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData element) {
        String targetName = element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric();
        String returnType = element.getFullGeneric() + " org.hamcrest.Matcher<java.lang.Iterable<" + targetName + ">>";
        String methodName = element.generateDSLMethodName("hasItems");
        String targetMethodName = element.generateDSLWithSameValueMethodName();
        return new HasItemSupplier(targetName, returnType, methodName, targetMethodName).asSuppliers();
    }

    public class HasItemSupplier
    extends AbstractDSLExtensionSupplier {
        public HasItemSupplier(String targetName, String returnType, String methodName, String targetMethodName) {
            super(targetName, returnType, methodName, targetMethodName);
        }

        @Override
        public Collection<Supplier<DSLMethod>> asSuppliers() {
            return Arrays.asList(this::generateContainsN);
        }

        public DSLMethod generateContainsN() {
            return new DSLMethod(new String[]{HasItemsExtension.JAVADOC_DESCRIPTION, "@param item the item to be matched", "@return the Matcher."}, this.returnType + " " + this.methodName, this.getSeveralParameter(true, "item"), "return org.hamcrest.Matchers.hasItems(java.util.Arrays.stream(item).map(v->" + this.targetMethodName + "(v)).collect(java.util.stream.Collectors.toList()).toArray(new org.hamcrest.Matcher[0]));");
        }
    }
}

