/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.fields.lang.BuilderDeclaration;
import ch.powerunit.extensions.matchers.provideprocessor.fields.lang.BuilderImplementation;
import ch.powerunit.extensions.matchers.provideprocessor.fields.lang.BuilderJavadoc;
import java.util.Arrays;
import java.util.Optional;

public class FieldDSLMethodBuilder {
    private static final String MATCHERS = "org.hamcrest.Matchers";

    public static BuilderDeclaration of(AbstractFieldDescription fieldDescription) {
        return new Builder(fieldDescription);
    }

    public static String getJavaDocFor(AbstractFieldDescription fieldDescription, Optional<String> addToDescription, Optional<String> param, Optional<String> see) {
        String linkToAccessor = "{@link " + fieldDescription.getFullyQualifiedNameEnclosingClassOfField() + "#" + fieldDescription.getFieldAccessor() + " This field is accessed by using this approach}.";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * Add a validation on the field `").append(fieldDescription.getFieldName()).append("`");
        addToDescription.ifPresent(t -> sb.append(" ").append((String)t));
        sb.append(".\n * <p>").append("\n *\n * <i>").append(linkToAccessor).append("</i>\n * <p>\n");
        sb.append(" * <b>In case method specifing a matcher on a fields are used several times, only the last setted matcher will be used.</b> \n");
        sb.append(" * When several control must be done on a single field, hamcrest itself provides a way to combine several matchers (See for instance {@link org.hamcrest.Matchers#both(org.hamcrest.Matcher)}.\n");
        sb.append(" *\n");
        param.ifPresent(t -> Arrays.stream(t.split("\n")).forEach(l -> sb.append(" * @param ").append((String)l).append(".\n")));
        sb.append(" * @return the DSL to continue the construction of the matcher.\n");
        see.ifPresent(t -> sb.append(" * @see ").append((String)t).append("\n"));
        sb.append(" */");
        return sb.toString();
    }

    public static String buildImplementation(String declaration, String body) {
        return String.format("@Override\npublic %1$s {\n  %2$s\n}\n", declaration, body.replaceAll("\\R", "\n  "));
    }

    public static String buildDsl(String javadoc, String declaration) {
        return String.format("%1$s\n%2$s;\n", javadoc.replaceAll("\\R", "\n"), declaration);
    }

    public static String buildDefaultDsl(AbstractFieldDescription fieldDescription, String javadoc, String declaration, String innerMatcher) {
        return String.format("%1$s\ndefault %2$s{\n  return %3$s(%4$s);\n}", javadoc.replaceAll("\\R", "\n"), declaration, fieldDescription.getFieldName(), innerMatcher);
    }

    public static class Builder
    implements BuilderDeclaration,
    BuilderJavadoc,
    BuilderImplementation {
        private final AbstractFieldDescription fieldDescription;
        private String declaration;
        private String javadoc;

        private Builder(AbstractFieldDescription fieldDescription) {
            this.fieldDescription = fieldDescription;
        }

        @Override
        public BuilderImplementation withJavaDoc(Optional<String> addToDescription, Optional<String> param, Optional<String> see) {
            this.javadoc = FieldDSLMethodBuilder.getJavaDocFor(this.fieldDescription, addToDescription, param, see);
            return this;
        }

        @Override
        public FieldDSLMethod havingDefault(String innerMatcher) {
            return new FieldDSLMethod(FieldDSLMethodBuilder.buildDefaultDsl(this.fieldDescription, this.javadoc, this.declaration, innerMatcher), "");
        }

        @Override
        public FieldDSLMethod havingImplementation(String body) {
            return new FieldDSLMethod(FieldDSLMethodBuilder.buildDsl(this.javadoc, this.declaration), FieldDSLMethodBuilder.buildImplementation(this.declaration, body));
        }

        @Override
        public BuilderJavadoc withExplicitDeclaration(String declaration) {
            this.declaration = declaration;
            return this;
        }

        @Override
        public BuilderJavadoc withGenericDeclaration(String generic, String postFix, String arguments) {
            this.declaration = generic + " " + String.format("%1$s %2$s%3$s(%4$s)", this.fieldDescription.getDefaultReturnMethod(), this.fieldDescription.getFieldName(), postFix, arguments);
            return this;
        }

        @Override
        public FieldDSLMethod withExplicitDeclarationJavadocAndImplementation(String declaration, String addToDescription, String body) {
            return this.withExplicitDeclaration(declaration).withJavaDoc(addToDescription).havingImplementation(body);
        }

        @Override
        public FieldDSLMethod withJavaDocAndDefault(String addToDescription, String innerMatcher) {
            return this.withJavaDoc(addToDescription).havingDefault(innerMatcher);
        }

        @Override
        public FieldDSLMethod withSuffixDeclarationJavadocAndDefault(String declaration, String addToDescription, String innerMatcher) {
            return this.withSuffixDeclaration(declaration).withJavaDocAndDefault(addToDescription, innerMatcher);
        }
    }
}

