/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.IgnoreInMatcher;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.ArrayFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.CollectionFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.ComparableFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.DefaultFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.IgoreFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.OptionalFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.StringFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.SupplierFieldDescription;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.TypeKindVisitor8;
import javax.tools.Diagnostic;

public final class FieldDescriptionProvider {
    private FieldDescriptionProvider() {
    }

    public static AbstractFieldDescription of(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        Element te = mirror.getFieldElement();
        ProcessingEnvironment processingEnv = containingElementMirror.getRoundMirror().getProcessingEnv();
        Type type = (Type)((Object)new ExtracTypeVisitor().visit(te instanceof ExecutableElement ? ((ExecutableElement)te).getReturnType() : te.asType(), processingEnv));
        if (te.getAnnotation(IgnoreInMatcher.class) != null) {
            return new IgoreFieldDescription(containingElementMirror, mirror);
        }
        switch (type) {
            case ARRAY: {
                return new ArrayFieldDescription(containingElementMirror, mirror);
            }
            case COLLECTION: 
            case SET: 
            case LIST: {
                return new CollectionFieldDescription(containingElementMirror, mirror);
            }
            case COMPARABLE: {
                return new ComparableFieldDescription(containingElementMirror, mirror);
            }
            case OPTIONAL: {
                return new OptionalFieldDescription(containingElementMirror, mirror);
            }
            case STRING: {
                return new StringFieldDescription(containingElementMirror, mirror);
            }
            case SUPPLIER: {
                return new SupplierFieldDescription(containingElementMirror, mirror);
            }
        }
        return new DefaultFieldDescription(containingElementMirror, mirror);
    }

    public static final class ExtracTypeVisitor
    extends TypeKindVisitor8<Type, ProcessingEnvironment> {
        @Override
        protected Type defaultAction(TypeMirror t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitArray(ArrayType t, ProcessingEnvironment processingEnv) {
            return Type.ARRAY;
        }

        @Override
        public Type visitDeclared(DeclaredType t, ProcessingEnvironment processingEnv) {
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Optional").asType()))) {
                return Type.OPTIONAL;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Set").asType()))) {
                return Type.SET;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.List").asType()))) {
                return Type.LIST;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.Collection").asType()))) {
                return Type.COLLECTION;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.lang.String").asType()))) {
                return Type.STRING;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.lang.Comparable").asType()))) {
                return Type.COMPARABLE;
            }
            if (processingEnv.getTypeUtils().isAssignable(t, processingEnv.getTypeUtils().erasure(processingEnv.getElementUtils().getTypeElement("java.util.function.Supplier").asType()))) {
                return Type.SUPPLIER;
            }
            return Type.NA;
        }

        @Override
        public Type visitTypeVariable(TypeVariable t, ProcessingEnvironment processingEnv) {
            return Type.NA;
        }

        @Override
        public Type visitUnknown(TypeMirror t, ProcessingEnvironment processingEnv) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element");
            return Type.NA;
        }
    }

    public static enum Type {
        NA,
        ARRAY,
        COLLECTION,
        LIST,
        SET,
        OPTIONAL,
        COMPARABLE,
        STRING,
        SUPPLIER;

    }
}

