/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.factoryprocessor;

import ch.powerunit.extensions.matchers.factoryprocessor.FactoryAnnotationsProcessor;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

class FactoryAnnotatedElementMirror {
    private static final String VAR_ARG_REGEX = "\\[\\](\\s[0-9a-zA-Z_]*$)??";
    private final ExecutableElement element;
    private final Optional<String> doc;
    private final String surroundingFullyQualifiedName;
    private final ProcessingEnvironment processingEnv;

    public FactoryAnnotatedElementMirror(FactoryAnnotationsProcessor factoryAnnotationsProcessor, ExecutableElement element) {
        this.element = element;
        this.processingEnv = factoryAnnotationsProcessor;
        this.doc = Optional.ofNullable(this.processingEnv.getElementUtils().getDocComment(element));
        this.surroundingFullyQualifiedName = element.getEnclosingElement().asType().toString();
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public String getSurroundingFullyQualifiedName() {
        return this.surroundingFullyQualifiedName;
    }

    public String getSeeValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.processingEnv.getElementUtils().getPackageOf(this.element.getEnclosingElement()).getQualifiedName()).append(".").append(this.element.getEnclosingElement().getSimpleName().toString()).append("#").append(this.element.getSimpleName().toString()).append("(");
        sb.append(this.element.getParameters().stream().map(this::convertParameterForSee).collect(Collectors.joining(",")));
        sb.append(")");
        String result = sb.toString();
        if (this.element.isVarArgs()) {
            result = result.replaceAll(VAR_ARG_REGEX, "...");
        }
        return result;
    }

    public String getParam() {
        String param = this.element.getParameters().stream().map(ve -> ve.asType().toString() + " " + ve.getSimpleName().toString()).collect(Collectors.joining(","));
        return this.element.isVarArgs() ? param.replaceAll(VAR_ARG_REGEX, "...") : param;
    }

    private String convertParameterForSee(VariableElement ve) {
        Element e = this.processingEnv.getTypeUtils().asElement(ve.asType());
        if (e == null || ve.asType().getKind() == TypeKind.TYPEVAR) {
            return this.processingEnv.getTypeUtils().erasure(ve.asType()).toString();
        }
        return this.processingEnv.getElementUtils().getPackageOf(e).toString() + "." + this.processingEnv.getTypeUtils().asElement(ve.asType()).getSimpleName();
    }

    private String getJavadoc() {
        return "  /**\n   * " + this.doc.map(t -> t.replaceAll("\n", "\n   * ").replaceAll("  * $", "\n")).orElse("No javadoc found from the source method.") + ("\n   * @see " + this.getSeeValue() + "\n   */") + "\n";
    }

    private String getGeneric() {
        if (!this.element.getTypeParameters().isEmpty()) {
            return "<" + this.element.getTypeParameters().stream().map(ve -> ve.getSimpleName().toString() + (ve.getBounds().isEmpty() ? "" : " extends " + ve.getBounds().stream().map(Object::toString).collect(Collectors.joining("&")))).collect(Collectors.joining(",")) + "> ";
        }
        return "";
    }

    private String getDeclaration() {
        return String.format("%1$s%2$s %3$s(%4$s)", this.getGeneric(), this.element.getReturnType(), this.element.getSimpleName(), this.getParam());
    }

    public String generateFactory() {
        return this.getJavadoc() + "  default " + this.getDeclaration() + " {\n" + (TypeKind.VOID != this.element.getReturnType().getKind() ? "    return " : "    ") + this.processingEnv.getElementUtils().getPackageOf(this.element.getEnclosingElement()).getQualifiedName().toString() + "." + this.element.getEnclosingElement().getSimpleName().toString() + "." + this.element.getSimpleName().toString() + "(" + this.element.getParameters().stream().map(ve -> ve.getSimpleName().toString()).collect(Collectors.joining(",")) + ");\n  }\n\n";
    }
}

