/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

public class CommonUtils {
    private CommonUtils() {
    }

    public static String toJavaSyntax(String unformatted) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (char c : unformatted.toCharArray()) {
            sb.append(CommonUtils.toJavaSyntax(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return "" + ch;
    }

    public static String addPrefix(String prefix, String input) {
        return "\n" + Arrays.stream(input.split("\\R")).map(l -> prefix + l).collect(Collectors.joining("\n")) + "\n";
    }

    public static void traceErrorAndDump(Messager messager, Filer filer, Exception e, Element te) {
        FileObjectHelper.processFileWithIOException(() -> filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "dump" + System.currentTimeMillis() + "txt", te), s -> new PrintStream(s.openOutputStream()), s -> e.printStackTrace((PrintStream)s), e2 -> messager.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the dump of the error because of " + e2 + " during handling of " + e, te));
        messager.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class because of " + e, te);
    }
}

