/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import java.io.Closeable;
import java.util.function.Consumer;
import javax.tools.FileObject;

public final class FileObjectHelper {
    private FileObjectHelper() {
    }

    public static <T extends FileObject, S extends Closeable> boolean processFileWithIOException(SupplierWithException<T> generateFileObject, FunctionWithException<T, S> openStream, ConsumerWithException<S> actions, Consumer<Exception> exceptionHandler) {
        try (Closeable wjfo = (Closeable)openStream.apply(generateFileObject.get());){
            actions.accept(wjfo);
        }
        catch (Exception e) {
            exceptionHandler.accept(e);
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface SupplierWithException<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<S> {
        public void accept(S var1) throws Exception;
    }
}

