/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.provideprocessor.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.xml.GeneratedMatcher;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public class ProvidesMatchersAnnotatedElementMirror
extends ProvidesMatchersAnnotatedElementMatcherMirror {
    private final Collection<Supplier<DSLMethod>> dslProvider;

    public ProvidesMatchersAnnotatedElementMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
        boolean hasParentInSameRound = roundMirror.isInSameRound(typeElement);
        ArrayList<Supplier> tmp = new ArrayList<Supplier>(Arrays.asList(this::generateDefaultDSLStarter, this::generateDefaultForChainingDSLStarter));
        if (this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher.isPresent()) {
            tmp.add(this::generateParentDSLStarter);
            if (hasParentInSameRound) {
                tmp.add(this::generateParentValueDSLStarter);
                if (((TypeElement)roundMirror.getProcessingEnv().getTypeUtils().asElement(this.typeElementForClassAnnotatedWithProvideMatcher.getSuperclass())).getTypeParameters().isEmpty()) {
                    tmp.add(this::generateParentInSameRoundWithChaningDSLStarter);
                }
            }
        } else {
            tmp.add(this::generateNoParentValueDSLStarter);
        }
        tmp.addAll(Optional.ofNullable(this.getDSLExtension()).orElseGet(Collections::emptyList).stream().map(t -> t.getDSLMethodFor(() -> this)).flatMap(Collection::stream).collect(Collectors.toList()));
        tmp.addAll(roundMirror.getDSLMethodFor(() -> this));
        this.dslProvider = Collections.unmodifiableList(tmp);
    }

    public Collection<DSLMethod> process() {
        RoundMirror rm = this.roundMirror;
        TypeElement te = this.typeElementForClassAnnotatedWithProvideMatcher;
        ArrayList<DSLMethod> results = new ArrayList<DSLMethod>();
        FileObjectHelper.processFileWithIOException(() -> rm.getProcessingEnv().getFiler().createSourceFile(this.getFullyQualifiedNameOfGeneratedClass(), te), jfo -> new PrintWriter(jfo.openWriter()), wjfo -> {
            wjfo.println("package " + this.getPackageNameOfGeneratedClass() + ";");
            wjfo.println();
            wjfo.println("// Generated by version " + this.getClass().getPackage().getImplementationVersion());
            wjfo.println(this.generateMainJavaDoc());
            wjfo.println("@javax.annotation.Generated(value=\"" + ProvidesMatchersAnnotationsProcessor.class.getName() + "\",date=\"" + Instant.now().toString() + "\",comments=" + CommonUtils.toJavaSyntax(this.getComments()) + ")");
            wjfo.println("public final class " + this.getSimpleNameOfGeneratedClass() + " {");
            wjfo.println();
            wjfo.println("  private " + this.getSimpleNameOfGeneratedClass() + "() {}");
            wjfo.println();
            wjfo.println(this.generateMatchers());
            wjfo.println();
            wjfo.println(this.generatePublicInterface());
            wjfo.println();
            wjfo.println(this.generatePrivateImplementation());
            wjfo.println();
            Collection<DSLMethod> tmp = this.generateDSLStarter();
            tmp.stream().map(m -> CommonUtils.addPrefix("  ", m.asStaticImplementation())).forEach(wjfo::println);
            wjfo.println("}");
            results.addAll(tmp);
        }, e -> CommonUtils.traceErrorAndDump(this.getProcessingEnv().getMessager(), this.getProcessingEnv().getFiler(), e, te));
        return results;
    }

    public String generateMainJavaDoc() {
        return String.format("/**\n* This class provides matchers for the class {@link %1$s}.\n * \n * @see %1$s The class for which matchers are provided.\n */\n", this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher);
    }

    public Collection<DSLMethod> generateDSLStarter() {
        return this.dslProvider.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getDefaultStarterBody(boolean withParentBuilder) {
        String targetImpl = withParentBuilder ? this.getSimpleNameOfGeneratedImplementationMatcherWithGenericParent() : this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        boolean withSuper = this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher.isPresent();
        if (withParentBuilder) {
            return withSuper ? "return new " + targetImpl + "(org.hamcrest.Matchers.anything(),parentBuilder);" : "return new " + targetImpl + "(parentBuilder);";
        }
        return withSuper ? "return new " + targetImpl + "(org.hamcrest.Matchers.anything());" : "return new " + targetImpl + "();";
    }

    public DSLMethod generateDefaultDSLStarter() {
        return new DSLMethod(this.generateDefaultJavaDoc(Optional.of("The returned builder (which is also a Matcher), at this point accepts any object that is a " + this.getDefaultLinkForAnnotatedClass() + "."), Optional.empty(), Optional.of("the DSL matcher"), true, false), this.fullGeneric + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + this.methodShortClassName + "With", this.getDefaultStarterBody(false));
    }

    public DSLMethod generateDefaultForChainingDSLStarter() {
        return new DSLMethod(this.generateDefaultJavaDoc(Optional.of("The returned builder (which is also a Matcher), at this point accepts any object that is a " + this.getDefaultLinkForAnnotatedClass() + "."), Optional.of("parentBuilder the parentBuilder."), Optional.of("the DSL matcher"), true, true), this.getFullGenericParent() + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() + " " + this.methodShortClassName + "WithParent", new String[]{"_PARENT", "parentBuilder"}, this.getDefaultStarterBody(true));
    }

    public DSLMethod generateParentDSLStarter() {
        String mscn = this.methodShortClassName;
        String fqngc = this.getFullyQualifiedNameOfGeneratedClass();
        return new DSLMethod(this.generateDefaultJavaDoc(Optional.empty(), Optional.of("matcherOnParent the matcher on the parent data."), Optional.of("the DSL matcher"), true, false), this.fullGeneric + " " + fqngc + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + mscn + "With", new String[]{"org.hamcrest.Matcher<? super " + (String)this.fullyQualifiedNameOfSuperClassOfClassAnnotatedWithProvideMatcher.get() + ">", "matcherOnParent"}, "return " + fqngc + "." + mscn + "With(matcherOnParent);");
    }

    public DSLMethod generatParentValueDSLStarter(String argumentForParentBuilder) {
        String genericNoParent = this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent();
        String javadoc = this.generateDefaultJavaDoc(Optional.empty(), Optional.of("other the other object to be used as a reference."), Optional.of("the DSL matcher"), true, false);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(genericNoParent + " m=new " + this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent() + "(" + argumentForParentBuilder + ");");
        lines.addAll(this.fields.stream().map(f -> "    " + f.getFieldCopy("m", "other") + ";").collect(Collectors.toList()));
        lines.add("return m;");
        return new DSLMethod(javadoc, this.fullGeneric + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + genericNoParent + " " + this.methodShortClassName + "WithSameValue", new String[]{this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other"}, lines.toArray(new String[0]));
    }

    public DSLMethod generateNoParentValueDSLStarter() {
        return this.generatParentValueDSLStarter("");
    }

    public Optional<ProvidesMatchersAnnotatedElementMirror> getParentMirror() {
        RoundMirror rm = this.roundMirror;
        return Optional.ofNullable(rm.getByName(((TypeElement)rm.getProcessingEnv().getTypeUtils().asElement(this.typeElementForClassAnnotatedWithProvideMatcher.getSuperclass())).getQualifiedName().toString()));
    }

    public DSLMethod generateParentValueDSLStarter() {
        return this.getParentMirror().map(parentMirror -> this.generatParentValueDSLStarter(parentMirror.getFullyQualifiedNameOfGeneratedClass() + "." + parentMirror.methodShortClassName + "WithSameValue(other)")).orElse(null);
    }

    public DSLMethod generateParentInSameRoundWithChaningDSLStarter() {
        String implGenericNoParent = this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        return this.getParentMirror().map(parentMirror -> {
            String pmfqngc = parentMirror.getFullyQualifiedNameOfGeneratedClass();
            return new DSLMethod(this.generateDefaultJavaDoc(Optional.empty(), Optional.empty(), Optional.of("the DSL matcher"), true, false), this.fullGeneric + " " + pmfqngc + "." + parentMirror.simpleNameOfGeneratedInterfaceMatcher + this.genericForChaining + " " + this.methodShortClassName + "WithParent", new String[]{implGenericNoParent + " m=new " + implGenericNoParent + "(org.hamcrest.Matchers.anything());", pmfqngc + "." + parentMirror.simpleNameOfGeneratedInterfaceMatcher + " tmp = " + pmfqngc + "." + parentMirror.methodShortClassName + "WithParent(m);", "m._parent = new SuperClassMatcher(tmp);", "return tmp;"});
        }).orElse(null);
    }

    public GeneratedMatcher asXml() {
        GeneratedMatcher gm = new GeneratedMatcher();
        gm.setFullyQualifiedNameGeneratedClass(this.getFullyQualifiedNameOfGeneratedClass());
        gm.setFullyQualifiedNameInputClass(this.fullyQualifiedNameOfClassAnnotatedWithProvideMatcher);
        gm.setSimpleNameGeneratedClass(this.getSimpleNameOfGeneratedClass());
        gm.setSimpleNameInputClass(this.simpleNameOfClassAnnotatedWithProvideMatcher);
        gm.setDslMethodNameStart(this.methodShortClassName);
        gm.setGeneratedMatcherField(this.fields.stream().map(FieldDescriptionMetaData::asGeneratedMatcherField).collect(Collectors.toList()));
        gm.setMirror(this);
        return gm;
    }
}

