/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.AbstractTypeKindVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

final class NameExtractorVisitor
extends AbstractTypeKindVisitor<Optional<String>, Boolean, RoundMirror> {
    public NameExtractorVisitor(RoundMirror support) {
        super(support);
    }

    @Override
    public Optional<String> visitPrimitiveAsBoolean(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "boolean" : "Boolean");
    }

    @Override
    public Optional<String> visitPrimitiveAsByte(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "byte" : "Byte");
    }

    @Override
    public Optional<String> visitPrimitiveAsShort(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "short" : "Short");
    }

    @Override
    public Optional<String> visitPrimitiveAsInt(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "int" : "Integer");
    }

    @Override
    public Optional<String> visitPrimitiveAsLong(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "long" : "Long");
    }

    @Override
    public Optional<String> visitPrimitiveAsChar(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "char" : "Character");
    }

    @Override
    public Optional<String> visitPrimitiveAsFloat(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "float" : "Float");
    }

    @Override
    public Optional<String> visitPrimitiveAsDouble(PrimitiveType t, Boolean asPrimitif) {
        return Optional.of(asPrimitif != false ? "double" : "Double");
    }

    @Override
    public Optional<String> visitArray(ArrayType t, Boolean asPrimitif) {
        return t.getComponentType().accept(this, true).map(r -> r + "[]");
    }

    @Override
    public Optional<String> visitDeclared(DeclaredType t, Boolean asPrimitif) {
        return Optional.of(t.toString());
    }

    @Override
    public Optional<String> visitTypeVariable(TypeVariable t, Boolean asPrimitif) {
        return Optional.of(t.toString());
    }

    @Override
    public Optional<String> visitUnknown(TypeMirror t, Boolean asPrimitif) {
        ProcessingEnvironment processingEnv = this.getProcessingEnv();
        processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Unsupported type element", processingEnv.getTypeUtils().asElement(t));
        return Optional.empty();
    }
}

