/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.ProvideMatchers;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvideMatchersAnnotationMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.extension.DSLExtension;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ProvideMatchersMirror
extends ProvideMatchersAnnotationMirror
implements Matchable {
    private static final String DEFAULT_PARAM_PARENT = " * @param <_PARENT> used to reference, if necessary, a parent for this builder. By default Void is used an indicate no parent builder.\n";
    public static final String JAVADOC_WARNING_SYNTAXIC_SUGAR_NO_CHANGE_ANYMORE = "<b>This method is a syntaxic sugar that end the DSL and make clear that the matcher can't be change anymore.</b>";
    public static final String JAVADOC_WARNING_PARENT_MAY_BE_VOID = "<b>This method only works in the context of a parent builder. If the real type is Void, then nothing will be returned.</b>";
    protected final String simpleNameOfGeneratedClass;
    protected final String packageNameOfGeneratedClass;
    protected final String simpleNameOfGeneratedInterfaceMatcher;
    protected final String methodShortClassName;

    public ProvideMatchersMirror(RoundMirror roundMirror, TypeElement annotatedElement) {
        super(roundMirror, annotatedElement);
        this.simpleNameOfGeneratedClass = this.generateSimpleNameOfGeneratedClass(annotatedElement);
        this.packageNameOfGeneratedClass = this.generatePackageNameOfGeneratedClass(annotatedElement, this.getProcessingEnv().getElementUtils());
        this.simpleNameOfGeneratedInterfaceMatcher = this.getSimpleNameOfClassAnnotated() + "Matcher";
        String simplename = this.getSimpleNameOfClassAnnotated();
        this.methodShortClassName = CommonUtils.asStandardMethodName(simplename);
    }

    private String generateSimpleNameOfGeneratedClass(TypeElement annotatedElement) {
        ProvideMatchers pm = this.realAnnotation;
        if ("".equals(pm.matchersClassName())) {
            return this.getSimpleName(annotatedElement) + "Matchers";
        }
        return pm.matchersClassName();
    }

    private String generatePackageNameOfGeneratedClass(TypeElement annotatedElement, Elements elements) {
        ProvideMatchers pm = this.realAnnotation;
        if ("".equals(pm.matchersPackageName())) {
            return this.getQualifiedName(elements.getPackageOf(annotatedElement));
        }
        return pm.matchersPackageName();
    }

    @Override
    public String getMethodShortClassName() {
        return this.methodShortClassName;
    }

    public final String getSimpleNameOfGeneratedClass() {
        return this.simpleNameOfGeneratedClass;
    }

    @Override
    public final String getFullyQualifiedNameOfGeneratedClass() {
        return this.packageNameOfGeneratedClass + "." + this.simpleNameOfGeneratedClass;
    }

    public final String getPackageNameOfGeneratedClass() {
        return this.packageNameOfGeneratedClass;
    }

    public final Collection<DSLExtension> getDSLExtension() {
        return DSLExtension.EXTENSION.stream().filter(e -> e.accept(this.moreMethod())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private Function<String, String> asJavadocFormat(String prefix) {
        return t -> String.format("%1$s%2$s\n", prefix, t);
    }

    private String paramToJavadoc(Optional<String> param) {
        return param.map(this.asJavadocFormat(" * @param ")).orElse("");
    }

    protected String generateJavaDocWithoutParamNeitherParent(String description, String moreDetails, Optional<String> param, Optional<String> returnDescription) {
        return String.format("/**\n * %1$s.\n * <p>\n * %2$s\n%3$s%4$s */\n", description, moreDetails, this.paramToJavadoc(param), returnDescription.map(this.asJavadocFormat(" * @return ")).orElse(""));
    }

    protected String generateDefaultJavaDoc() {
        return String.format("/**\n * %1$s.\n%2$s * \n%3$s * \n */\n", this.getDefaultDescriptionForDsl(), this.getParamComment(), DEFAULT_PARAM_PARENT);
    }

    protected String generateDefaultJavaDoc(Optional<String> moreDetails, Optional<String> param, String returnDescription, boolean withParent) {
        return String.format("/**\n * %1$s.\n%2$s%3$s%4$s * \n%5$s * @return %6$s\n */\n", this.getDefaultDescriptionForDsl(), moreDetails.map(this.asJavadocFormat(" * <p>\n * ")).orElse(""), this.paramToJavadoc(param), this.getParamComment(), withParent ? DEFAULT_PARAM_PARENT : "", returnDescription);
    }

    protected String generateJavaDoc(String description, boolean withParent) {
        return String.format("/**\n * %1$s.\n%2$s * \n%3$s */\n", description, this.getParamComment(), withParent ? DEFAULT_PARAM_PARENT : "");
    }

    public String generateMainJavaDoc() {
        return String.format("/**\n* This class provides matchers for the class {@link %1$s}.\n * \n * @see %1$s The class for which matchers are provided.\n */\n", this.getFullyQualifiedNameOfClassAnnotated());
    }

    private String getDefaultDescriptionForDsl() {
        return "Start a DSL matcher for the " + this.getDefaultLinkForAnnotatedClass();
    }

    public Optional<Matchable> getParentMirror() {
        RoundMirror rm = (RoundMirror)this.getRoundMirror();
        return Optional.ofNullable(rm.getByName(this.getQualifiedName((TypeElement)rm.getTypeUtils().asElement(((TypeElement)this.element).getSuperclass()))));
    }

    @Override
    public boolean hasWithSameValue() {
        return !this.hasSuperClass() || this.getParentMirror().isPresent() || this.allowWeakWithSameValue;
    }

    @Override
    public String getSimpleNameOfGeneratedInterfaceMatcher() {
        return this.simpleNameOfGeneratedInterfaceMatcher;
    }
}

