/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.ListJoining;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementGeneralMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersSubElementVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.IgnoreFieldDescription;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public abstract class ProvidesMatchersAnnotatedElementFieldMatcherMirror
extends ProvidesMatchersAnnotatedElementGeneralMirror {
    private static final Comparator<AbstractFieldDescription> COMPARING_FIELD_BY_NAME = Comparator.comparing(FieldDescriptionMetaData::getFieldName);
    private static final String DEFAULT_FEATUREMATCHER_FORCONVERTER = "\n  private static <_TARGET,_SOURCE> org.hamcrest.Matcher<_SOURCE> asFeatureMatcher(\n      String msg,\n      java.util.function.Function<_SOURCE,_TARGET> converter,\n      org.hamcrest.Matcher<? super _TARGET> matcher) {\n   return new org.hamcrest.FeatureMatcher<_SOURCE,_TARGET>(matcher, msg, msg) {\n     protected _TARGET featureValueOf(_SOURCE actual) {\n      return converter.apply(actual);\n    }};\n  }\n\n";
    protected final List<AbstractFieldDescription> fields;
    private final String fieldsMatcher;

    private static AbstractFieldDescription reduceByOrderingOnIgnoreFieldDescription(AbstractFieldDescription l, AbstractFieldDescription r) {
        return Optional.ofNullable(l).filter(c -> c instanceof IgnoreFieldDescription).orElse(r);
    }

    private List<AbstractFieldDescription> generateFields(TypeElement typeElement, ProvidesMatchersSubElementVisitor providesMatchersSubElementVisitor) {
        return typeElement.getEnclosedElements().stream().map(ie -> ie.accept(providesMatchersSubElementVisitor, this)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.collectingAndThen(Collectors.groupingBy(FieldDescriptionMetaData::getFieldName, Collectors.reducing(ProvidesMatchersAnnotatedElementFieldMatcherMirror::reduceByOrderingOnIgnoreFieldDescription)), Map::values)).stream().filter(Optional::isPresent).map(Optional::get).sorted(COMPARING_FIELD_BY_NAME).collect(Collectors.toList());
    }

    public ProvidesMatchersAnnotatedElementFieldMatcherMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
        this.fields = this.generateFields(typeElement, new ProvidesMatchersSubElementVisitor(roundMirror));
        this.fieldsMatcher = this.fields.stream().map(FieldDescriptionMetaData::getMatcherForField).map(f -> CommonUtils.addPrefix("  ", f)).collect(Collectors.joining("\n")) + "\n";
    }

    public String generateMatchers() {
        return DEFAULT_FEATUREMATCHER_FORCONVERTER + this.fieldsMatcher + this.fullyQualifiedNameOfSuperClassOfClassAnnotated.map(this::generateParentMatcher).orElse("");
    }

    public String generateParentMatcher(String parent) {
        return String.format("  private static class SuperClassMatcher%1$s extends org.hamcrest.FeatureMatcher<%2$s,%3$s> {\n\n    public SuperClassMatcher(org.hamcrest.Matcher<? super %3$s> matcher) {\n      super(matcher,\"parent\",\"parent\");\n  }\n\n\n    protected %3$s featureValueOf(%2$s actual) {\n      return actual;\n    }\n\n  }\n\n\n", this.fullGeneric, this.getFullyQualifiedNameOfClassAnnotated(), parent);
    }

    public String generateMetadata() {
        return "\n\n  // ---------------------------------------------------------------------------\n  // METADATA\n\n  /**\n   * Metadata regarding this matcher.\n   */\n  public static final Metadata METADATA = new Metadata();\n\n   public static final class FieldMetadata {\n    public final String NAME, TYPE, ACCESSOR, STEREOTYPE;\n    public final boolean IGNORED;\n    private FieldMetadata(String name, String type, String accessor,String stereotype, boolean ignored) {\n      NAME=name; TYPE=type; ACCESSOR=accessor; STEREOTYPE=stereotype; IGNORED=ignored;\n    }\n  }\n\n  public static final class Metadata {\n\n    private Metadata() {}\n\n    public final String ANNOTATION_PROCESSOR_VERSION = \"" + this.getAnnotationProcessorVersion() + "\";\n\n    public final long COMPATIBILITY = " + this.getCompatibility() + ";\n\n    public final String SOURCE_CLASS_NAME = \"" + this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + "\";\n\n    public final Class<" + this.getFullyQualifiedNameOfClassAnnotated() + "> SOURCE_CLASS = " + this.getFullyQualifiedNameOfClassAnnotated() + ".class;\n\n    public final String SOURCE_PARENT_CLASS_NAME = " + this.fullyQualifiedNameOfSuperClassOfClassAnnotated.map(CommonUtils::toJavaSyntax).orElse("null") + ";\n\n    public final FieldMetadata[] FIELDS = new FieldMetadata[]{ " + ListJoining.joinWithMapperAndDelimiter(f -> f.generateMetadata("FieldMetadata"), ", ").asString(this.fields) + " };\n\n  }\n";
    }
}

