/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementFieldMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMetaData;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public abstract class ProvidesMatchersAnnotatedElementMatcherMirror
extends ProvidesMatchersAnnotatedElementFieldMatcherMirror {
    private static final String PRIVATE_IMPLEMENTATION_END = "\n\n    @Override\n    public _PARENT end() {\n      return _parentBuilder;\n    }\n\n\n";
    private static final String NEXTMATCHERS_DESCRIBETO = "      for(org.hamcrest.Matcher nMatcher : nextMatchers) {\n        description.appendText(\"[object itself \").appendDescriptionOf(nMatcher).appendText(\"]\\n\");\n      }\n    }\n";
    private static final String PARENT_DESCRIBETO = "      description.appendText(\"[\").appendDescriptionOf(_parent).appendText(\"]\\n\");\n";
    private static final String PARENT_VALIDATION = "      if(!_parent.matches(actual)) {\n        mismatchDescription.appendText(\"[\"); _parent.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");\n        result=false;\n      }\n";
    private static final String NEXTMATCHERS_VALIDATION = "      for(org.hamcrest.Matcher nMatcher : nextMatchers) {\n        if(!nMatcher.matches(actual)) {\n          mismatchDescription.appendText(\"[object itself \"); nMatcher.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");\n        result=false;\n        }\n      }\n      return result;\n    }\n\n";
    private static final String JAVADOC_ANDWITHAS = "    /**\n     * Add a matcher on the object itself and not on a specific field, but convert the object before passing it to the matcher.\n     * <p>\n     * <i>This method, when used more than once, just add more matcher to the list.</i>\n     * @param converter the function to convert the object.\n     * @param otherMatcher the matcher on the converter object itself.\n     * @param <_TARGETOBJECT> the type of the target object\n     * @return the DSL to continue\n     */\n";
    private static final String JAVADOC_ANDWITH = "    /**\n     * Add a matcher on the object itself and not on a specific field.\n     * <p>\n     * <i>This method, when used more than once, just add more matcher to the list.</i>\n     * @param otherMatcher the matcher on the object itself.\n     * @return the DSL to continue\n     */\n";
    private final String dslInterfaceDescription = "DSL interface for matcher on " + this.getDefaultLinkForAnnotatedClass();

    public ProvidesMatchersAnnotatedElementMatcherMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
    }

    public String generatePublicInterface() {
        return this.generateMainBuildPublicInterface() + this.generateMainParentPublicInterface() + this.generateExposedPublicInterface();
    }

    private String generateExposedPublicInterface() {
        String simpleName = this.simpleNameOfGeneratedInterfaceMatcher;
        return CommonUtils.addPrefix("  ", this.generateDefaultJavaDoc()) + "\n" + "  public static interface " + simpleName + this.getFullGenericParent() + " extends org.hamcrest.Matcher<" + this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + ">," + simpleName + "BuildSyntaxicSugar " + this.generic + "," + simpleName + "EndSyntaxicSugar " + this.getGenericParent() + " {\n" + this.fields.stream().map(AbstractFieldDescription::getDslInterface).map(s -> CommonUtils.addPrefix("    ", s)).collect(Collectors.joining("\n")) + "\n\n" + this.generateAsPublicInterface() + "  }\n";
    }

    private String generateAsPublicInterface() {
        String fully = this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric();
        String otherMatcher = "org.hamcrest.Matcher<? super " + fully + "> otherMatcher";
        String interfaceWithGeneric = this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent();
        StringBuilder sb = new StringBuilder(JAVADOC_ANDWITH).append("    ").append(interfaceWithGeneric).append(" andWith(").append(otherMatcher).append(");\n\n");
        sb.append(JAVADOC_ANDWITHAS).append(String.format("    default <_TARGETOBJECT> %1$s andWithAs(java.util.function.Function<%2$s,_TARGETOBJECT> converter,org.hamcrest.Matcher<? super _TARGETOBJECT> otherMatcher) {\n      return andWith(asFeatureMatcher(\" <object is converted> \",converter,otherMatcher));\n    }\n\n", interfaceWithGeneric, fully));
        sb.append(CommonUtils.addPrefix("  ", this.generateJavaDocWithoutParamNeitherParent("Method that return the matcher itself and accept one single Matcher on the object itself.", "<b>This method is a syntaxic sugar that end the DSL and make clear that the matcher can't be change anymore.</b>", Optional.of("otherMatcher the matcher on the object itself."), Optional.of("the matcher")))).append(String.format("\n    default org.hamcrest.Matcher<%1$s> buildWith(%2$s) {\n      return andWith(otherMatcher);\n    }\n\n", fully, otherMatcher));
        sb.append(CommonUtils.addPrefix("  ", this.generateJavaDocWithoutParamNeitherParent("Method that return the parent builder and accept one single Matcher on the object itself.", "<b>This method only works in the context of a parent builder. If the real type is Void, then nothing will be returned.</b>", Optional.of("otherMatcher the matcher on the object itself."), Optional.of("the parent builder or null if not applicable")))).append(String.format("    default _PARENT endWith(%1$s){\n      return andWith(otherMatcher).end();\n    }\n", otherMatcher));
        return sb.toString();
    }

    private String generateMainParentPublicInterface() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommonUtils.addPrefix("  ", this.generateJavaDoc(this.dslInterfaceDescription + " to support the end syntaxic sugar", true))).append("\n");
        sb.append("  public static interface " + this.simpleNameOfGeneratedInterfaceMatcher + "EndSyntaxicSugar" + this.getFullGenericParent() + " extends org.hamcrest.Matcher<" + this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + "> {\n");
        sb.append(CommonUtils.addPrefix("  ", this.generateJavaDocWithoutParamNeitherParent("Method that return the parent builder", "<b>This method only works in the context of a parent builder. If the real type is Void, then nothing will be returned.</b>", Optional.empty(), Optional.of("the parent builder or null if not applicable")))).append("\n    _PARENT end();\n  }\n");
        return sb.toString();
    }

    private String generateMainBuildPublicInterface() {
        String fullyWithGeneric = this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric();
        return CommonUtils.addPrefix("  ", this.generateJavaDoc(this.dslInterfaceDescription + " to support the build syntaxic sugar", false)) + "\n  public static interface " + this.simpleNameOfGeneratedInterfaceMatcher + "BuildSyntaxicSugar" + this.fullGeneric + " extends org.hamcrest.Matcher<" + fullyWithGeneric + "> {\n" + CommonUtils.addPrefix("  ", this.generateJavaDocWithoutParamNeitherParent("Method that return the matcher itself.", "<b>This method is a syntaxic sugar that end the DSL and make clear that the matcher can't be change anymore.</b>", Optional.empty(), Optional.of("the matcher"))) + "\n    default org.hamcrest.Matcher<" + fullyWithGeneric + "> build() {\n      return this;\n    }\n  }\n";
    }

    public String generatePrivateImplementationConstructor(String argument, String ... body) {
        return String.format("    public %1$s(%2$s) {\n%3$s\n    }", this.getSimpleNameOfGeneratedImplementationMatcher(), argument, Arrays.stream(body).map(l -> "      " + l).collect(Collectors.joining("\n")));
    }

    protected String generatePrivateImplementation() {
        return "  /* package protected */ static class " + this.getSimpleNameOfGeneratedImplementationMatcher() + this.getFullGenericParent() + " extends org.hamcrest.TypeSafeDiagnosingMatcher<" + this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + "> implements " + (this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() + " {\n    ") + this.fields.stream().map(FieldDescriptionMetaData::asMatcherField).collect(Collectors.joining("\n    ")) + "\n    private final _PARENT _parentBuilder;\n\n    private final java.util.List<org.hamcrest.Matcher> nextMatchers = new java.util.ArrayList<>();\n" + this.generateParentEntry() + this.fields.stream().map(AbstractFieldDescription::getImplementationInterface).map(s -> CommonUtils.addPrefix("    ", s)).collect(Collectors.joining("\n")) + "\n" + this.generatePrivateImplementationForMatchersSafely() + "\n" + this.generatedPrivateImplementationForDescribeTo() + PRIVATE_IMPLEMENTATION_END + this.generatePrivateImplementationForAndWith() + "\n  }\n";
    }

    private String generateParentEntry() {
        return this.fullyQualifiedNameOfSuperClassOfClassAnnotated.map(p -> "    private SuperClassMatcher _parent;\n\n" + this.generatePrivateImplementationConstructor("org.hamcrest.Matcher<? super " + p + "> parent", "this._parent=new SuperClassMatcher(parent);", "this._parentBuilder=null;") + "\n\n" + this.generatePrivateImplementationConstructor("org.hamcrest.Matcher<? super " + p + "> parent,_PARENT parentBuilder", "this._parent=new SuperClassMatcher(parent);", "this._parentBuilder=parentBuilder;") + "\n\n").orElseGet(() -> this.generatePrivateImplementationConstructor("", "this._parentBuilder=null;") + "\n\n" + this.generatePrivateImplementationConstructor("_PARENT parentBuilder", "this._parentBuilder=parentBuilder;") + "\n\n");
    }

    private String generatePrivateImplementationForMatchersSafely() {
        StringBuilder sb = new StringBuilder(String.format("    @Override\n    protected boolean matchesSafely(%1$s actual, org.hamcrest.Description mismatchDescription) {\n      boolean result=true;\n", this.getFullyQualifiedNameOfClassAnnotated()));
        if (this.hasSuperClass()) {
            sb.append(PARENT_VALIDATION);
        }
        this.fields.stream().map(f -> CommonUtils.addPrefix("      ", f.asMatchesSafely() + "\n")).forEach(sb::append);
        sb.append(NEXTMATCHERS_VALIDATION);
        return sb.toString();
    }

    private String generatedPrivateImplementationForDescribeTo() {
        StringBuilder sb = new StringBuilder(String.format("    @Override\n    public void describeTo(org.hamcrest.Description description) {\n      description.appendText(\"an instance of %1$s with\\n\");\n", this.getFullyQualifiedNameOfClassAnnotated()));
        if (this.hasSuperClass()) {
            sb.append(PARENT_DESCRIBETO);
        }
        this.fields.stream().map(f -> CommonUtils.addPrefix("      ", f.asDescribeTo() + "\n")).forEach(sb::append);
        sb.append(NEXTMATCHERS_DESCRIBETO);
        return sb.toString();
    }

    private String generatePrivateImplementationForAndWith() {
        return String.format("    @Override\n    public %1$s andWith(org.hamcrest.Matcher<? super %2$s> otherMatcher) {\n      nextMatchers.add(java.util.Objects.requireNonNull(otherMatcher,\"A matcher is expected\"));\n      return this;\n    }\n", this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent(), this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric());
    }
}

