/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotationsProcessor;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ProvidesMatchersAnnotatedElementMirror
extends ProvidesMatchersAnnotatedElementMatcherMirror {
    private final Collection<Supplier<DSLMethod>> dslProvider;

    public ProvidesMatchersAnnotatedElementMirror(TypeElement typeElement, RoundMirror roundMirror) {
        super(typeElement, roundMirror);
        ArrayList<Supplier> tmp = new ArrayList<Supplier>(Arrays.asList(this::generateDefaultDSLStarter, this::generateDefaultForChainingDSLStarter));
        if (this.hasSuperClass()) {
            tmp.add(this::generateParentDSLStarter);
            tmp.add(this::generateParentValueDSLStarter);
            if (((TypeElement)roundMirror.getTypeUtils().asElement(((TypeElement)this.element).getSuperclass())).getTypeParameters().isEmpty()) {
                tmp.add(this::generateParentInSameRoundWithChaningDSLStarter);
            }
        } else {
            tmp.add(() -> this.generatParentValueDSLStarter(""));
        }
        tmp.addAll(Optional.ofNullable(this.getDSLExtension()).orElseGet(Collections::emptyList).stream().map(t -> t.getDSLMethodFor(() -> this)).flatMap(Collection::stream).collect(Collectors.toList()));
        tmp.addAll(roundMirror.getDSLMethodFor(() -> this));
        this.dslProvider = Collections.unmodifiableList(tmp);
    }

    public Collection<DSLMethod> process() {
        Element te = this.element;
        String simpleName = this.getSimpleNameOfGeneratedClass();
        return FileObjectHelper.processFileWithIOExceptionAndResult(() -> this.getFiler().createSourceFile(this.getFullyQualifiedNameOfGeneratedClass(), te), jfo -> new PrintWriter(jfo.openWriter()), wjfo -> {
            wjfo.println("package " + this.getPackageNameOfGeneratedClass() + ";\n");
            wjfo.println(this.generateMainJavaDoc());
            wjfo.println(CommonUtils.generateGeneratedAnnotation(ProvidesMatchersAnnotationsProcessor.class, this.comments()));
            wjfo.println("public final class " + simpleName + " {\n");
            wjfo.println("  private " + simpleName + "() {}\n");
            wjfo.println(this.generateMatchers());
            wjfo.println();
            wjfo.println(this.generatePublicInterface());
            wjfo.println();
            wjfo.println(this.generatePrivateImplementation());
            wjfo.println();
            Collection<DSLMethod> tmp = this.generateDSLStarter();
            tmp.stream().map(m -> CommonUtils.addPrefix("  ", m.asStaticImplementation())).forEach(wjfo::println);
            wjfo.println();
            wjfo.println(this.generateMetadata());
            wjfo.println("}");
            return tmp;
        }, e -> CommonUtils.traceErrorAndDump(this, e, te));
    }

    public Collection<DSLMethod> generateDSLStarter() {
        return this.dslProvider.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getDefaultStarterBody(boolean withParentBuilder) {
        String targetImpl = withParentBuilder ? this.getSimpleNameOfGeneratedImplementationMatcherWithGenericParent() : this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        boolean withSuper = this.hasSuperClass();
        if (withParentBuilder) {
            return withSuper ? "return new " + targetImpl + "(org.hamcrest.Matchers.anything(),parentBuilder);" : "return new " + targetImpl + "(parentBuilder);";
        }
        return withSuper ? "return new " + targetImpl + "(org.hamcrest.Matchers.anything());" : "return new " + targetImpl + "();";
    }

    public String generateDefaultJavaDocWithDSLStarter(Optional<String> param, String returnDescription, boolean withParent) {
        return this.generateDefaultJavaDoc(Optional.of(this.getJavadocForDSLStarter()), param, returnDescription, withParent);
    }

    public String generateDefaultJavaDocWithoutDSLStarter(Optional<String> param, String returnDescription, boolean withParent) {
        return this.generateDefaultJavaDoc(Optional.empty(), param, returnDescription, withParent);
    }

    public DSLMethod generateDefaultDSLStarter() {
        return DSLMethod.of(this.fullGeneric + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + this.methodShortClassName + "With").withImplementation(this.getDefaultStarterBody(false)).withJavadoc(this.generateDefaultJavaDocWithDSLStarter(Optional.empty(), "the DSL matcher", false));
    }

    private String getJavadocForDSLStarter() {
        return "The returned builder (which is also a Matcher), at this point accepts any object that is a " + this.getDefaultLinkForAnnotatedClass() + ".";
    }

    public DSLMethod generateDefaultForChainingDSLStarter() {
        return DSLMethod.of(this.getFullGenericParent() + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericParent() + " " + this.getMethodNameDSLWithParent()).withOneArgument("_PARENT", "parentBuilder").withImplementation(this.getDefaultStarterBody(true)).withJavadoc(this.generateDefaultJavaDocWithDSLStarter(Optional.of("parentBuilder the parentBuilder."), "the DSL matcher", true));
    }

    public DSLMethod generateParentDSLStarter() {
        String mscn = this.methodShortClassName;
        String fqngc = this.getFullyQualifiedNameOfGeneratedClass();
        return DSLMethod.of(this.fullGeneric + " " + fqngc + "." + this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent() + " " + mscn + "With").withOneArgument("org.hamcrest.Matcher<? super " + (String)this.fullyQualifiedNameOfSuperClassOfClassAnnotated.get() + ">", "matcherOnParent").withImplementation("return new " + this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent() + "(matcherOnParent);").withJavadoc(this.generateDefaultJavaDocWithoutDSLStarter(Optional.of("matcherOnParent the matcher on the parent data."), "the DSL matcher", false));
    }

    public DSLMethod generatParentValueDSLStarter(String argumentForParentBuilder) {
        String genericNoParent = this.getSimpleNameOfGeneratedInterfaceMatcherWithGenericNoParent();
        String javadoc = this.generateDefaultJavaDocWithoutDSLStarter(Optional.of("other the other object to be used as a reference."), "the DSL matcher", false);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(genericNoParent + " m=new " + this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent() + "(" + argumentForParentBuilder + ");");
        lines.addAll(this.fields.stream().map(f -> f.getFieldCopy("m", "other") + ";").collect(Collectors.toList()));
        lines.add("return m;");
        return DSLMethod.of(this.fullGeneric + " " + this.getFullyQualifiedNameOfGeneratedClass() + "." + genericNoParent + " " + this.getMethodNameDSLWithSameValue()).withOneArgument(this.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), "other").withImplementation(lines).withJavadoc(javadoc);
    }

    public DSLMethod generateParentValueDSLStarterWeak() {
        if (this.realAnnotation.allowWeakWithSameValue()) {
            Optional<AnnotationMirror> am = this.getAnnotationMirror();
            Optional<AnnotationValue> av = am.map(a -> a.getElementValues().entrySet().stream().filter(kv -> ((ExecutableElement)kv.getKey()).getSimpleName().toString().equals("allowWeakWithSameValue")).map(Map.Entry::getValue).findAny().orElse(null));
            this.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "This class use the option allowWeakWithSameValue and a weak WithSameValue is detected. The generated WithSameValue DSL may not be able to fully control all the field of this class", this.element, am.orElse(null), av.orElse(null));
            return this.generatParentValueDSLStarter("org.hamcrest.Matchers.anything()");
        }
        return null;
    }

    public DSLMethod generateParentValueDSLStarter() {
        return this.getParentMirror().map(parentMirror -> this.generatParentValueDSLStarter(parentMirror.getWithSameValue(false) + "(other)")).orElse(this.generateParentValueDSLStarterWeak());
    }

    public DSLMethod generateParentInSameRoundWithChaningDSLStarter() {
        String implGenericNoParent = this.getSimpleNameOfGeneratedImplementationMatcherWithGenericNoParent();
        return this.getParentMirror().map(parentMirror -> {
            String pmfqngc = parentMirror.getFullyQualifiedNameOfGeneratedClass();
            String parentSimpleName = parentMirror.getSimpleNameOfGeneratedInterfaceMatcher();
            return DSLMethod.of(this.fullGeneric + " " + pmfqngc + "." + parentSimpleName + this.genericForChaining + " " + this.getMethodNameDSLWithParent()).withImplementation(implGenericNoParent + " m=new " + implGenericNoParent + "(org.hamcrest.Matchers.anything());", pmfqngc + "." + parentSimpleName + " tmp = " + pmfqngc + "." + parentMirror.getMethodNameDSLWithParent() + "(m);", "m._parent = new SuperClassMatcher(tmp);", "return tmp;").withJavadoc(this.generateDefaultJavaDoc(Optional.empty(), Optional.empty(), "the DSL matcher", false));
        }).orElse(null);
    }
}

