/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor;

import ch.powerunit.extensions.matchers.common.AbstractSimpleElementVisitor;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.NameExtractorVisitor;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementFieldMatcherMirror;
import ch.powerunit.extensions.matchers.provideprocessor.RoundMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionProvider;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class ProvidesMatchersSubElementVisitor
extends AbstractSimpleElementVisitor<Optional<AbstractFieldDescription>, ProvidesMatchersAnnotatedElementFieldMatcherMirror, RoundMirror> {
    private final Function<Element, Boolean> removeFromIgnoreList = roundMirror::removeFromIgnoreList;
    private final NameExtractorVisitor extractNameVisitor;

    public ProvidesMatchersSubElementVisitor(RoundMirror roundMirror) {
        super(roundMirror);
        this.extractNameVisitor = new NameExtractorVisitor(roundMirror);
    }

    public Optional<AbstractFieldDescription> removeIfNeededAndThenReturn(Optional<AbstractFieldDescription> fieldDescription) {
        fieldDescription.map(FieldDescriptionMetaData::getFieldElement).ifPresent(this.removeFromIgnoreList::apply);
        return fieldDescription;
    }

    @Override
    public Optional<AbstractFieldDescription> visitVariable(VariableElement e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        if (this.isPublic(e) && !this.isStatic(e)) {
            String fieldName = this.getSimpleName(e);
            return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, fieldName);
        }
        this.generateIfNeededErrorForNotSupportedElementAndRemoveIt("Check that this field is public and not static", e);
        return Optional.empty();
    }

    @Override
    public Optional<AbstractFieldDescription> visitExecutable(ExecutableElement e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        String simpleName;
        if (this.isPublic(e) && e.getParameters().size() == 0 && !this.isStatic(e) && (simpleName = this.getSimpleName(e)).matches("^((get)|(is)).*")) {
            return this.visiteExecutableGet(e, "^(get)|(is)", p);
        }
        this.generateIfNeededErrorForNotSupportedElementAndRemoveIt("Check that this method is public, doesn't have any parameter and is named isXXX or getXXX", e);
        return Optional.empty();
    }

    private void generateIfNeededErrorForNotSupportedElementAndRemoveIt(String description, Element e) {
        if (this.removeFromIgnoreList.apply(e).booleanValue()) {
            this.getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "One of the annotation is not supported as this location ; " + description + ". Since version 0.2.0 of powerunit-extension-matchers this is considered as an error.", e);
        }
    }

    private Optional<AbstractFieldDescription> visiteExecutableGet(ExecutableElement e, String prefix, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        String methodName = this.getSimpleName(e);
        String fieldNameDirect = methodName.replaceFirst(prefix, "");
        String fieldName = CommonUtils.asStandardMethodName(fieldNameDirect);
        return this.createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(e, p, fieldName);
    }

    public Optional<AbstractFieldDescription> createFieldDescriptionIfApplicableAndRemoveElementFromListWhenApplicable(Element e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p, String fieldName) {
        return this.removeIfNeededAndThenReturn((e instanceof ExecutableElement ? ((ExecutableElement)e).getReturnType() : e.asType()).accept(this.extractNameVisitor, false).map(f -> FieldDescriptionProvider.of(() -> p, new FieldDescriptionMirror(() -> p, fieldName, (String)f, e))));
    }

    @Override
    protected Optional<AbstractFieldDescription> defaultAction(Element e, ProvidesMatchersAnnotatedElementFieldMatcherMirror p) {
        return Optional.empty();
    }
}

