/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.dsl;

import ch.powerunit.extensions.matchers.common.ListJoining;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.lang.DSLMethodArgument;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.lang.DSLMethodImplementation;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.lang.DSLMethodJavadoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DSLMethod {
    public static final Pattern DECLARATION_PARSER = Pattern.compile("^\\s*.*\\s+([0-9A-Za-z_]+)\\s*$");
    private static final ListJoining<String[]> ARGUMENTS_JOIN = ListJoining.joinWithMapper(a -> a[0] + " " + a[1]).withCommaDelimiter().withPrefixAndSuffix("(", ")");
    private static final ListJoining<String[]> ARGUMENTNAMES_JOIN = ListJoining.joinWithMapper(a -> a[1]).withCommaDelimiter().withPrefixAndSuffix("(", ")");
    private static final ListJoining<String> IMPLEMENTATION_JOIN = ListJoining.joinWithMapper(s -> "  " + s).withDelimiter("\n").withPrefixAndSuffix("", "\n");
    private final String implementation;
    private final String defaultReference;

    public static DSLMethodArgument of(String declaration) {
        return new Builder(declaration);
    }

    public DSLMethod(String javadoc, String declaration, String[][] arguments, String[] implementation) {
        Matcher m = DECLARATION_PARSER.matcher(declaration);
        if (!m.matches()) {
            throw new IllegalArgumentException("Unable to parse the received declaration");
        }
        String implementations = IMPLEMENTATION_JOIN.asString((String[])implementation);
        String fullDeclaration = declaration + ARGUMENTS_JOIN.asString((E[])arguments);
        String fullMethodName = m.group(1) + ARGUMENTNAMES_JOIN.asString((E[])arguments);
        this.implementation = javadoc + "public static " + fullDeclaration + " {\n" + implementations + "}\n";
        this.defaultReference = javadoc + "default " + fullDeclaration + " {\n  return %1$s." + fullMethodName + ";\n}\n";
    }

    public String asStaticImplementation() {
        return this.implementation;
    }

    public String asDefaultReference(String target) {
        return String.format(this.defaultReference, target);
    }

    private static class Builder
    implements DSLMethodArgument,
    DSLMethodImplementation,
    DSLMethodJavadoc {
        private final String declaration;
        private final List<String[]> arguments = new ArrayList<String[]>();
        private String[] implementation;

        public Builder(String declaration) {
            this.declaration = declaration;
        }

        @Override
        public DSLMethod withJavadoc(String javadoc) {
            return new DSLMethod(javadoc, this.declaration, (String[][])this.arguments.toArray((T[])new String[0][]), this.implementation);
        }

        @Override
        public DSLMethodJavadoc withImplementation(String ... implementation) {
            this.implementation = implementation;
            return this;
        }

        @Override
        public DSLMethodArgument addOneArgument(String type, String name) {
            this.arguments.add(new String[]{Objects.requireNonNull(type, "type can't be null"), Objects.requireNonNull(name, "name can't be null")});
            return this;
        }
    }
}

