/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.ComplementaryExpositionMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AbstractDSLExtensionSupplier;
import ch.powerunit.extensions.matchers.provideprocessor.extension.DSLExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class AnyOfExtension
implements DSLExtension {
    public static final String ANYOF_MATCHER = "org.hamcrest.Matchers.anyOf";
    private static final String JAVADOC_DESCRIPTION = "Generate a anyOf matcher for this Object, which provide a simple way to valid that something is one of the many supplied instance.";

    @Override
    public ComplementaryExpositionMethod supportedEnum() {
        return ComplementaryExpositionMethod.ANY_OF;
    }

    @Override
    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData element) {
        String methodName = element.generateDSLMethodName("anyOf");
        return new AnyOfSupplier(element, methodName).asSuppliers();
    }

    public class AnyOfSupplier
    extends AbstractDSLExtensionSupplier {
        protected final ProvidesMatchersAnnotatedElementData element;

        public AnyOfSupplier(ProvidesMatchersAnnotatedElementData element, String methodName) {
            super(element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric(), element.getFullGeneric() + " org.hamcrest.Matcher<" + element.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcherWithGeneric() + ">", methodName, element.generateDSLWithSameValueMethodName());
            this.element = element;
        }

        @Override
        public Collection<Supplier<DSLMethod>> asSuppliers() {
            return Arrays.asList(this::generateAnyOf);
        }

        public String innerMatcher() {
            return "org.hamcrest.Matchers.anyOf(java.util.Arrays.stream(items).map(v->" + this.targetMethodName + "(v)).collect(java.util.stream.Collectors.toList()).toArray(new org.hamcrest.Matcher[0]))";
        }

        public DSLMethod generateAnyOf() {
            if (this.element.hasWithSameValue()) {
                return DSLMethod.of(this.returnType + " " + this.methodName).withArguments(this.getSeveralParameter(true, "items")).withImplementation("return " + this.innerMatcher() + ";").withJavadoc(AnyOfExtension.JAVADOC_DESCRIPTION, "@param items the items to be matched", "@return the Matcher.");
            }
            this.element.printWarningMessage("Unable to apply the " + AnyOfExtension.this.supportedEnum().name() + " extension ; The target class doesn't support the WithSameValue() matcher");
            return null;
        }
    }
}

