/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.extension;

import ch.powerunit.extensions.matchers.ComplementaryExpositionMethod;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.dsl.DSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.extension.AnyOfExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class NoneOfExtension
extends AnyOfExtension {
    public static final String NOT_MATCHER = "org.hamcrest.Matchers.not";
    private static final String JAVADOC_DESCRIPTION = "Generate a notOf matcher for this Object, which provide a simple way to valid that something is none of the many supplied instance.";

    @Override
    public ComplementaryExpositionMethod supportedEnum() {
        return ComplementaryExpositionMethod.NONE_OF;
    }

    @Override
    public Collection<Supplier<DSLMethod>> getDSLMethodFor(ProvidesMatchersAnnotatedElementData element) {
        String methodName = element.generateDSLMethodName("noneOf");
        return new NoneOfSupplier(element, methodName).asSuppliers();
    }

    public class NoneOfSupplier
    extends AnyOfExtension.AnyOfSupplier {
        public NoneOfSupplier(ProvidesMatchersAnnotatedElementData element, String methodName) {
            super(element, methodName);
        }

        @Override
        public Collection<Supplier<DSLMethod>> asSuppliers() {
            return Arrays.asList(this::generateNoneOf);
        }

        public DSLMethod generateNoneOf() {
            if (this.element.hasWithSameValue()) {
                return DSLMethod.of(this.returnType + " " + this.methodName).withArguments(this.getSeveralParameter(true, "items")).withImplementation("return org.hamcrest.Matchers.not(" + this.innerMatcher() + ");").withJavadoc(NoneOfExtension.JAVADOC_DESCRIPTION, "@param items the items to be not matched", "@return the Matcher.");
            }
            this.element.printWarningMessage("Unable to apply the " + NoneOfExtension.this.supportedEnum().name() + " extension ; The target class doesn't support the WithSameValue() matcher");
            return null;
        }
    }
}

