/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.DefaultFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class CollectionFieldDescription
extends DefaultFieldDescription {
    private static final String DEFAULT_JAVADOC_MATCHER_ON_ELEMENTS = "matchersOnElements the matchers on the elements";

    public CollectionFieldDescription(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        super(containingElementMirror, mirror);
    }

    @Override
    protected Collection<FieldDSLMethod> getSpecificFieldDslMethodFor() {
        ArrayList<FieldDSLMethod> tmp = new ArrayList<FieldDSLMethod>(this.getFieldDslMethodForIterableAndComparable());
        if (!"".equals(this.generic)) {
            tmp.addAll(this.getDslForIterableWithGeneric());
        }
        return tmp;
    }

    public List<FieldDSLMethod> getFieldDslMethodForIterableAndComparable() {
        return Arrays.asList(this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsEmptyIterable", "that the iterable is empty", "(org.hamcrest.Matcher)org.hamcrest.Matchers.emptyIterable()"), this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsEmpty", "that the collection is empty", "(org.hamcrest.Matcher)org.hamcrest.Matchers.empty()"));
    }

    public List<FieldDSLMethod> getDslForIterableWithGeneric() {
        String tgeneric = this.generic;
        String genericmatcher = "org.hamcrest.Matcher<" + tgeneric + ">";
        return Arrays.asList(this.getDslMethodBuilder().withDeclaration("Contains", tgeneric + "... elements").withJavaDoc("that the iterable contains the received elements", "elements the elements", "org.hamcrest.Matchers#contains(java.lang.Object[])").havingDefault("org.hamcrest.Matchers.contains(elements)"), this.getDslMethodBuilder().withDeclaration("Contains", genericmatcher + "... matchersOnElements").withJavaDoc("that the iterable contains the received elements, using matchers", DEFAULT_JAVADOC_MATCHER_ON_ELEMENTS, "org.hamcrest.Matchers#contains(org.hamcrest.Matcher[])").havingDefault("org.hamcrest.Matchers.contains(matchersOnElements)"), this.getDslMethodBuilder().withDeclaration("ContainsInAnyOrder", tgeneric + "... elements").withJavaDoc("that the iterable contains the received elements in any order", "elements the elements", "org.hamcrest.Matchers#containsInAnyOrder(java.lang.Object[])").havingDefault("org.hamcrest.Matchers.containsInAnyOrder(elements)"), this.getDslMethodBuilder().withDeclaration("ContainsInAnyOrder", genericmatcher + "... matchersOnElements").withJavaDoc("that the iterable contains the received elements, using matchers in any order", DEFAULT_JAVADOC_MATCHER_ON_ELEMENTS, "org.hamcrest.Matchers#containsInAnyOrder(org.hamcrest.Matcher[])").havingDefault("org.hamcrest.Matchers.containsInAnyOrder(matchersOnElements)"), this.getDslMethodBuilder().withDeclaration("Contains", "java.util.List<org.hamcrest.Matcher<? super " + tgeneric + ">> matchersOnElements").withJavaDoc("that the iterable contains the received elements, using list of matcher", DEFAULT_JAVADOC_MATCHER_ON_ELEMENTS, "org.hamcrest.Matchers#contains(java.util.List)").havingDefault("org.hamcrest.Matchers.contains(matchersOnElements)"));
    }

    @Override
    public String getFieldCopy(String lhs, String rhs) {
        if (!"".equals(this.generic)) {
            return this.getFieldCopyForList(lhs, rhs);
        }
        return super.getFieldCopy(lhs, rhs);
    }

    public String getFieldCopyForList(String lhs, String rhs) {
        String fieldAccessor = this.getFieldAccessor();
        String fieldName = this.getFieldName();
        return "if(" + rhs + "." + fieldAccessor + "==null) {" + lhs + "." + fieldName + "(" + "org.hamcrest.Matchers" + ".nullValue()); } else if (" + rhs + "." + fieldAccessor + ".isEmpty()) {" + lhs + "." + fieldName + "IsEmptyIterable(); } else {" + lhs + "." + fieldName + "Contains(" + rhs + "." + fieldAccessor + ".stream().map(" + this.generateMatcherBuilderReferenceFor(this.generic) + ").collect(java.util.stream.Collectors.toList())); }";
    }

    public String generateMatcherBuilderReferenceFor(String generic) {
        return Optional.ofNullable(this.getByName(generic)).filter(Matchable::hasWithSameValue).map(t -> t.getWithSameValue(true)).orElse("org.hamcrest.Matchers::is");
    }
}

