/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.common.CommonUtils;
import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.AbstractFieldDescriptionContainerMetaData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import ch.powerunit.extensions.matchers.provideprocessor.fields.IgnoreFieldDescription;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class FieldDescriptionMetaData
extends AbstractFieldDescriptionContainerMetaData {
    public static final String SEE_TEXT_FOR_IS_MATCHER = "org.hamcrest.Matchers#is(java.lang.Object)";
    public static final String SEE_TEXT_FOR_HAMCREST_MATCHER = "org.hamcrest.Matchers The main class from hamcrest that provides default matchers.";
    public static final String MATCHERS = "org.hamcrest.Matchers";
    public static final String MAIN_FIELD_COPY = "%1$s.%2$s(%3$s)";
    public static final String IS_MATCHER = "(org.hamcrest.Matcher)org.hamcrest.Matchers.is((java.lang.Object)%1$s.%2$s)";
    protected final String generic;
    protected final String defaultReturnMethod;
    protected final FieldDescriptionMirror mirror;

    public static final String computeGenericInformation(TypeMirror fieldTypeMirror) {
        if (fieldTypeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)fieldTypeMirror;
            return dt.getTypeArguments().stream().map(Object::toString).collect(Collectors.joining(","));
        }
        return "";
    }

    public FieldDescriptionMetaData(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        super(containingElementMirror);
        this.mirror = mirror;
        TypeMirror fieldTypeMirror = mirror.getFieldTypeMirror();
        this.defaultReturnMethod = containingElementMirror.getDefaultReturnMethod();
        this.generic = FieldDescriptionMetaData.computeGenericInformation(fieldTypeMirror);
    }

    public String getMatcherForField() {
        return String.format("private static class %1$sMatcher%2$s extends org.hamcrest.FeatureMatcher<%3$s%4$s,%5$s> {\n  public %1$sMatcher(org.hamcrest.Matcher<? super %5$s> matcher) {\n    super(matcher,\"%6$s\",\"%6$s\");\n  }\n  protected %5$s featureValueOf(%3$s%4$s actual) {\n    return actual.%7$s;\n  }\n}\n", this.mirror.getMethodFieldName(), this.containingElementMirror.getFullGeneric(), this.getFullyQualifiedNameEnclosingClassOfField(), this.containingElementMirror.getGeneric(), this.getFieldType(), this.getFieldName(), this.getFieldAccessor());
    }

    public String generateBaseFieldCopy(String lhs, String innerMatcher) {
        return String.format(MAIN_FIELD_COPY, lhs, this.getFieldName(), innerMatcher);
    }

    public String getFieldCopyDefault(String lhs, String rhs) {
        return this.generateBaseFieldCopy(lhs, String.format(IS_MATCHER, rhs, this.getFieldAccessor()));
    }

    public String getFieldCopySameRound(String lhs, String rhs, Matchable target) {
        String fieldAccessor = this.getFieldAccessor();
        return this.generateBaseFieldCopy(lhs, rhs + "." + fieldAccessor + "==null?" + MATCHERS + ".nullValue():" + target.getWithSameValue(false) + "(" + rhs + "." + fieldAccessor + ")");
    }

    public String getFieldCopy(String lhs, String rhs) {
        return this.mirror.getMatchable(this.containingElementMirror.getRoundMirror()).filter(a -> this.mirror.getFieldTypeAsTypeElement().getTypeParameters().isEmpty()).filter(Matchable::hasWithSameValue).map(p -> this.getFieldCopySameRound(lhs, rhs, (Matchable)p)).orElse(this.getFieldCopyDefault(lhs, rhs));
    }

    public String asMatchesSafely() {
        return String.format("if(!%1$s.matches(actual)) {\n  mismatchDescription.appendText(\"[\"); %1$s.describeMismatch(actual,mismatchDescription); mismatchDescription.appendText(\"]\\n\");\n  result=false;\n}", this.getFieldName());
    }

    public String asDescribeTo() {
        return "description.appendText(\"[\").appendDescriptionOf(" + this.getFieldName() + ").appendText(\"]\\n\");";
    }

    public String asMatcherField() {
        return String.format("private %1$sMatcher %2$s = new %1$sMatcher(%3$s.anything(%4$s));", this.mirror.getMethodFieldName(), this.getFieldName(), MATCHERS, "");
    }

    public String getFullyQualifiedNameEnclosingClassOfField() {
        return this.containingElementMirror.getFullyQualifiedNameOfClassAnnotatedWithProvideMatcher();
    }

    public String getDefaultReturnMethod() {
        return this.defaultReturnMethod;
    }

    public String getFieldAccessor() {
        return this.mirror.getFieldAccessor();
    }

    public String getFieldName() {
        return this.mirror.getFieldName();
    }

    public String getFieldType() {
        return this.mirror.getFieldType();
    }

    public Element getFieldElement() {
        return this.mirror.getFieldElement();
    }

    public FieldDescriptionMirror getMirror() {
        return this.mirror;
    }

    public String getGeneric() {
        return this.generic;
    }

    public String generateMetadata(String className) {
        return "new " + className + "(" + CommonUtils.toJavaSyntax(this.getFieldName()) + "," + CommonUtils.toJavaSyntax(this.getFieldType()) + "," + CommonUtils.toJavaSyntax(this.getFieldAccessor()) + "," + CommonUtils.toJavaSyntax(this.getClass().getSimpleName()) + "," + Boolean.toString(this instanceof IgnoreFieldDescription) + ")";
    }
}

