/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.provideprocessor.fields;

import ch.powerunit.extensions.matchers.provideprocessor.Matchable;
import ch.powerunit.extensions.matchers.provideprocessor.ProvidesMatchersAnnotatedElementData;
import ch.powerunit.extensions.matchers.provideprocessor.fields.DefaultFieldDescription;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDSLMethod;
import ch.powerunit.extensions.matchers.provideprocessor.fields.FieldDescriptionMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.type.DeclaredType;

public class MapFieldDescription
extends DefaultFieldDescription {
    private static final String EMPTY_MATCHER = "new org.hamcrest.CustomTypeSafeMatcher<%1$s>(\"map is empty\"){ public boolean matchesSafely(%1$s o) {return o.isEmpty();}}";
    private static final String SIZE_MATCHER = "new org.hamcrest.CustomTypeSafeMatcher<%1$s>(\"map size is \"+other.size()){ public boolean matchesSafely(%1$s o) {return o.size()==other.size();} protected void describeMismatchSafely(%1$s item, org.hamcrest.Description mismatchDescription) {mismatchDescription.appendText(\" was size=\").appendValue(item.size());}}";

    public MapFieldDescription(ProvidesMatchersAnnotatedElementData containingElementMirror, FieldDescriptionMirror mirror) {
        super(containingElementMirror, mirror);
    }

    @Override
    protected Collection<FieldDSLMethod> getSpecificFieldDslMethodFor() {
        String fieldType = this.getFieldType();
        String emptyMatcher = String.format(EMPTY_MATCHER, fieldType);
        ArrayList<FieldDSLMethod> tmp = new ArrayList<FieldDSLMethod>();
        tmp.add(this.getDslMethodBuilder().withSuffixDeclarationJavadocAndDefault("IsEmpty", "the map is empty", emptyMatcher));
        if (!"".equals(this.generic)) {
            Object[] matchers = Optional.of(this.mirror.getFieldTypeMirror()).filter(m -> m instanceof DeclaredType).map(DeclaredType.class::cast).filter(m -> m.getTypeArguments().size() == 2).map(m -> m.getTypeArguments().stream().map(Object::toString).map(o -> Optional.ofNullable(this.getByName((String)o)).filter(Matchable::hasWithSameValue).map(t -> t.getWithSameValue(false)).orElse("org.hamcrest.Matchers.is")).toArray()).orElse(new String[]{"org.hamcrest.Matchers.is", "org.hamcrest.Matchers.is"});
            tmp.add(this.generateHasSameValue(fieldType, matchers[0].toString(), matchers[1].toString()));
        }
        return tmp;
    }

    private FieldDSLMethod generateHasSameValue(String fieldType, String keyMatcher, String keyValue) {
        String sizeMatcher = String.format(SIZE_MATCHER, fieldType);
        return this.getDslMethodBuilder().withDeclaration("HasSameValues", fieldType + " other").withJavaDoc("verify that the value from the other map are exactly the once inside this map", "other the other map").havingDefault("org.hamcrest.Matchers.both(" + sizeMatcher + ").and(" + "org.hamcrest.Matchers" + ".allOf(other.entrySet().stream().map(kv->" + "org.hamcrest.Matchers" + ".hasEntry(" + keyMatcher + "(kv.getKey())," + keyValue + "(kv.getValue()))).collect(java.util.stream.Collectors.toList())))");
    }

    @Override
    public String getMatcherForField() {
        String matcher = super.getMatcherForField();
        if (!"".equals(this.generic)) {
            String localGeneric = this.generic.contains("?") ? "" : "<" + this.generic + ">";
            matcher = matcher + "\n" + String.format("private static class %1$sMatcherSameValue%2$s extends org.hamcrest.FeatureMatcher<%3$s,%4$s> {\n  public %1$sMatcherSameValue(org.hamcrest.Matcher<? super %4$s> matcher) {\n    super(matcher,\"%5$s\",\"%5$s\");\n  }\n  protected %4$s featureValueOf(%3$s actual) {\n    return (java.util.Set)actual.entrySet();\n  }\n}\n", this.mirror.getMethodFieldName(), this.containingElementMirror.getFullGeneric(), this.getFieldType(), "java.util.Set<java.util.Map.Entry" + localGeneric + ">", " [entries of] ");
        }
        return matcher;
    }

    @Override
    public String getFieldCopy(String lhs, String rhs) {
        if (!"".equals(this.generic)) {
            String fieldAccessor = this.getFieldAccessor();
            String fieldName = this.getFieldName();
            return "if(" + rhs + "." + fieldAccessor + "==null) {" + lhs + "." + fieldName + "(" + "org.hamcrest.Matchers" + ".nullValue()); } else {" + lhs + "." + fieldName + "HasSameValues(" + rhs + "." + fieldAccessor + ");}";
        }
        return super.getFieldCopy(lhs, rhs);
    }
}

