/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import ch.powerunit.extensions.matchers.common.FileObjectHelper;
import ch.powerunit.extensions.matchers.common.ListJoining;
import ch.powerunit.extensions.matchers.common.ProcessingEnvironmentHelper;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

public class CommonUtils {
    private CommonUtils() {
    }

    public static String toJavaSyntax(String unformatted) {
        return unformatted.chars().mapToObj(CommonUtils::toJavaSyntax).collect(Collectors.joining("", "\"", "\""));
    }

    private static String toJavaSyntax(int ch) {
        switch (ch) {
            case 34: {
                return "\\\"";
            }
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
        }
        return String.valueOf(Character.toChars(ch));
    }

    public static String addPrefix(String prefix, String input) {
        return ListJoining.accepting(String.class).withMapper(l -> prefix + l).withDelimiter("\n").withPrefixAndSuffix("\n", "\n").asString((String[])input.split("\\R"));
    }

    public static String generateGeneratedAnnotation(Class<?> generatedBy, String comments) {
        return "@javax.annotation.Generated(\n   value=\"" + generatedBy.getName() + "\",\n   date=\"" + Instant.now().toString() + "\"" + Optional.ofNullable(comments).map(c -> ",\n   comments=" + CommonUtils.toJavaSyntax(c)).orElse("") + ")";
    }

    public static void traceErrorAndDump(ProcessingEnvironmentHelper environment, Exception e, Element te) {
        Messager messager = environment.getMessager();
        FileObjectHelper.processFileWithIOException(() -> environment.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "dump" + System.currentTimeMillis() + "txt", te), s -> new PrintStream(s.openOutputStream()), e::printStackTrace, e2 -> messager.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the dump of the error because of " + e2 + " during handling of " + e, te));
        messager.printMessage(Diagnostic.Kind.ERROR, "Unable to create the file containing the target class because of " + e, te);
    }

    public static String asStandardMethodName(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }
}

