/*
 * Decompiled with CFR 0.152.
 */
package ch.powerunit.extensions.matchers.common;

import ch.powerunit.extensions.matchers.common.CommonConstants;
import ch.powerunit.extensions.matchers.common.CommonUtils;
import java.io.PrintWriter;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;

public final class FactoryHelper {
    private FactoryHelper() {
    }

    public static void generateFactoryClass(PrintWriter wjfo, Class<? extends AbstractProcessor> processor, String packageName, String className, Supplier<Stream<String>> bodyProvider) {
        wjfo.println("package " + packageName + ";");
        wjfo.println();
        wjfo.println(CommonConstants.DEFAULT_JAVADOC_FOR_FACTORY);
        wjfo.println(CommonUtils.generateGeneratedAnnotation(processor, null));
        wjfo.println("public interface " + className + " {");
        wjfo.println();
        wjfo.println(FactoryHelper.generateStaticDSL(className));
        wjfo.println();
        bodyProvider.get().forEach(wjfo::println);
        wjfo.println("}");
    }

    public static String generateStaticDSL(String className) {
        return String.format("  /**\n   * Use this static field to access all the DSL syntax, without be required to implements this interface.\n  */\n  public static final %1$s DSL = new %1$s() {};\n\n", className);
    }
}

